/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.popup;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.PopupUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.swing.ResizableWindow;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import sun.awt.EmbeddedFrame;

public class JidePopup
extends JComponent
implements Accessible,
WindowConstants {
    private JRootPane rootPane;
    private boolean rootPaneCheckingEnabled = false;
    private boolean _attachable = true;
    private boolean _movable = false;
    private boolean _detached;
    private ResizableWindow _window;
    private ResizablePanel _panel;
    protected ResizableSupport _resizableSupport;
    private ComponentAdapter _componentListener;
    private WindowAdapter _windowListener;
    private ComponentAdapter _ownerComponentListener;
    private HierarchyListener _hierarchyListener;
    private boolean _resizable = true;
    private Component _owner;
    private Border _popupBorder;
    private boolean _transient = true;
    private int _timeout = 0;
    private Component _defaultFocusComponent;
    private int _defaultMoveOperation = 0;
    private int DISTANCE_TO_SCREEN_BORDER = 10;
    private List<Component> _excludedComponents = new ArrayList<Component>();
    private int _gripperLocation = 1;
    private ComponentAdapter _popupResizeListener;
    private Dimension _previousSize;
    protected Component _actualOwner;
    protected Point _actualOwnerLocation;
    private int _popupType = 2;
    private ActionListener _escapeActionListener;
    private Insets _insets = null;
    private boolean _isDragging = false;
    private double _relativeX;
    private double _relativeY;
    private Point _startPoint;
    private Window _currentWindow;
    private JPanel _currentPanel;
    private AWTEventListener _awtEventListener;
    private static boolean checkedUnpostPopup;
    private static boolean unpostPopup;

    public JidePopup() {
        boolean bl;
        JidePopup jidePopup;
        JRootPane jRootPane = new JRootPane();
        jRootPane.getContentPane().setLayout(new BorderLayout());
        JidePopup jidePopup2 = this;
        if (jidePopup2.rootPane != null) {
            jidePopup2.rootPane.removeAll();
            jidePopup2.remove(jidePopup2.rootPane);
        }
        JRootPane jRootPane2 = jidePopup2.getRootPane();
        jidePopup2.rootPane = jRootPane;
        if (jidePopup2.rootPane != null) {
            jidePopup = jidePopup2;
            boolean bl2 = jidePopup.rootPaneCheckingEnabled;
            try {
                bl = false;
                jidePopup = jidePopup2;
                jidePopup2.rootPaneCheckingEnabled = bl;
                jidePopup2.add((Component)jidePopup2.rootPane, "Center");
            }
            finally {
                bl = bl2;
                jidePopup = jidePopup2;
                jidePopup2.rootPaneCheckingEnabled = bl;
            }
        }
        jidePopup2.firePropertyChange("rootPane", jRootPane2, jRootPane);
        this.setLayout(new BorderLayout());
        bl = true;
        jidePopup = this;
        this.rootPaneCheckingEnabled = bl;
        this.setFocusable(false);
        this.updateUI();
    }

    public void updateUI() {
        boolean bl;
        JidePopup jidePopup;
        if (UIDefaultsLookup.get("JidePopupUI") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        PopupUI popupUI = (PopupUI)UIManager.getUI(this);
        JidePopup jidePopup2 = jidePopup = this;
        boolean bl2 = jidePopup.rootPaneCheckingEnabled;
        try {
            bl = false;
            jidePopup2 = jidePopup;
            jidePopup.rootPaneCheckingEnabled = bl;
            super.setUI(popupUI);
        }
        finally {
            bl = bl2;
            jidePopup2 = jidePopup;
            jidePopup.rootPaneCheckingEnabled = bl;
        }
        this.invalidate();
    }

    public String getUIClassID() {
        return "JidePopupUI";
    }

    protected void addImpl(Component component, Object object, int n) {
        JidePopup jidePopup = this;
        if (jidePopup.rootPaneCheckingEnabled) {
            jidePopup = this;
            jidePopup.getRootPane().getContentPane().add(component, object, n);
            return;
        }
        super.addImpl(component, object, n);
    }

    public void remove(Component component) {
        int n = this.getComponentCount();
        super.remove(component);
        if (n == this.getComponentCount()) {
            JidePopup jidePopup = this;
            jidePopup.getRootPane().getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        JidePopup jidePopup = this;
        if (jidePopup.rootPaneCheckingEnabled) {
            jidePopup = this;
            jidePopup.getRootPane().getContentPane().setLayout(layoutManager);
            return;
        }
        super.setLayout(layoutManager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        if (bl != bl2) {
            super.setVisible(bl);
            this.firePropertyChange("visible", bl2, bl);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePopup(this);
        }
        return this.accessibleContext;
    }

    public final void showPopup() {
        this.showPopup(new Insets(0, 0, 0, 0), null);
    }

    public final void showPopup(Insets serializable, Component serializable2) {
        Point point;
        Cloneable cloneable;
        Serializable serializable3;
        this._insets = serializable;
        if (serializable2 != null) {
            serializable3 = serializable2;
        } else {
            serializable = this;
            serializable3 = serializable = ((JidePopup)serializable)._owner;
        }
        if (serializable3 != null && ((Component)serializable).isShowing()) {
            serializable2 = ((Component)serializable).getLocationOnScreen();
            this.internalShowPopup(((Point)serializable2).x, ((Point)serializable2).y, (Component)serializable);
            return;
        }
        JidePopup jidePopup = this;
        boolean bl = false;
        JidePopup jidePopup2 = jidePopup;
        jidePopup2 = null;
        int n = 0;
        jidePopup2 = jidePopup;
        jidePopup.setDetached(true);
        Serializable serializable4 = null;
        if (null != null && ((Component)serializable4).isShowing()) {
            cloneable = ((Component)serializable4).getBounds();
            Point point2 = ((Component)serializable4).getLocationOnScreen();
            cloneable.x = point2.x;
            cloneable.y = point2.y;
        } else {
            cloneable = PortingUtils.getLocalScreenBounds();
        }
        serializable4 = cloneable;
        cloneable = jidePopup2.getSize();
        cloneable = ((Dimension)cloneable).width == 0 ? jidePopup2.getPreferredSize() : cloneable;
        int n2 = n;
        Serializable serializable5 = serializable4;
        serializable4 = jidePopup2;
        switch (n2) {
            case 0: {
                point = new Point(((Rectangle)serializable5).x + (((Rectangle)serializable5).width - ((Dimension)cloneable).width) / 2, ((Rectangle)serializable5).y + (((Rectangle)serializable5).height - ((Dimension)cloneable).height) / 2);
                break;
            }
            case 5: {
                point = new Point(((Rectangle)serializable5).x + (((Rectangle)serializable5).width - ((Dimension)cloneable).width) / 2, ((Rectangle)serializable5).y + ((Rectangle)serializable5).height - ((Dimension)cloneable).height - ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER);
                break;
            }
            case 1: {
                point = new Point(((Rectangle)serializable5).x + (((Rectangle)serializable5).width - ((Dimension)cloneable).width) / 2, ((Rectangle)serializable5).y + ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER);
                break;
            }
            case 3: {
                point = new Point(((Rectangle)serializable5).x + ((Rectangle)serializable5).width - ((Dimension)cloneable).width - ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER, ((Rectangle)serializable5).y + (((Rectangle)serializable5).height - ((Dimension)cloneable).height) / 2);
                break;
            }
            case 7: {
                point = new Point(((Rectangle)serializable5).x + ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER, ((Rectangle)serializable5).y + (((Rectangle)serializable5).height - ((Dimension)cloneable).height) / 2);
                break;
            }
            case 6: {
                point = new Point(((Rectangle)serializable5).x + ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER, ((Rectangle)serializable5).y + ((Rectangle)serializable5).height - ((Dimension)cloneable).height - ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER);
                break;
            }
            case 2: {
                point = new Point(((Rectangle)serializable5).x + ((Rectangle)serializable5).width - ((Dimension)cloneable).width - ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER, ((Rectangle)serializable5).y + ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER);
                break;
            }
            case 8: {
                point = new Point(((Rectangle)serializable5).x + ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER, ((Rectangle)serializable5).y + ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER);
                break;
            }
            default: {
                point = new Point(((Rectangle)serializable5).x + ((Rectangle)serializable5).width - ((Dimension)cloneable).width - ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER, ((Rectangle)serializable5).y + ((Rectangle)serializable5).height - ((Dimension)cloneable).height - ((JidePopup)serializable4).DISTANCE_TO_SCREEN_BORDER);
            }
        }
        serializable5 = point;
        jidePopup2.internalShowPopup(((Point)serializable5).x, ((Point)serializable5).y, null);
    }

    private Point getPopupLocation(Point point, Dimension dimension, Component serializable) {
        Component component;
        if (serializable != null) {
            component = serializable;
        } else {
            JidePopup jidePopup = this;
            component = jidePopup._owner;
        }
        Serializable serializable2 = component;
        serializable2 = component != null ? serializable2.getSize() : new Dimension(0, 0);
        serializable = PortingUtils.getScreenSize(serializable);
        if (dimension.width == 0) {
            dimension = this.getPreferredSize();
        }
        serializable2 = new Point(point.x + this._insets.left, point.y + ((Dimension)serializable2).height - this._insets.bottom);
        int n = ((Point)serializable2).x + dimension.width;
        int n2 = ((Point)serializable2).y + dimension.height;
        if (n > ((Dimension)serializable).width) {
            ((Point)serializable2).x -= n - ((Dimension)serializable).width;
        }
        if (n2 > ((Dimension)serializable).height) {
            ((Point)serializable2).y = point.y + this._insets.top - dimension.height;
            JidePopup jidePopup = this;
            if (jidePopup._resizable) {
                this.setupResizeCorner(4);
            }
        } else {
            JidePopup jidePopup = this;
            if (jidePopup._resizable) {
                this.setupResizeCorner(16);
            }
        }
        return serializable2;
    }

    private void setupResizeCorner(int n) {
        switch (n) {
            case 4: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(4);
                JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(this){
                    private /* synthetic */ JidePopup this$0;
                    {
                        this.this$0 = jidePopup;
                    }

                    public final boolean condition(Component component) {
                        return component instanceof JideScrollPane;
                    }

                    public final void action(Component component) {
                        Resizable.ResizeCorner resizeCorner = new Resizable.ResizeCorner(4);
                        resizeCorner.addMouseListener(this.this$0._resizableSupport.getResizable().getMouseInputAdapter());
                        resizeCorner.addMouseMotionListener(this.this$0._resizableSupport.getResizable().getMouseInputAdapter());
                        ((JideScrollPane)component).setScrollBarCorner("VERTICAL_TOP", resizeCorner);
                        ((JideScrollPane)component).setScrollBarCorner("VERTICAL_BOTTOM", null);
                    }
                });
                return;
            }
            case 16: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(16);
                JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(this){
                    private /* synthetic */ JidePopup this$0;
                    {
                        this.this$0 = jidePopup;
                    }

                    public final boolean condition(Component component) {
                        return component instanceof JideScrollPane;
                    }

                    public final void action(Component component) {
                        Resizable.ResizeCorner resizeCorner = new Resizable.ResizeCorner(16);
                        resizeCorner.addMouseListener(this.this$0._resizableSupport.getResizable().getMouseInputAdapter());
                        resizeCorner.addMouseMotionListener(this.this$0._resizableSupport.getResizable().getMouseInputAdapter());
                        ((JideScrollPane)component).setScrollBarCorner("VERTICAL_BOTTOM", resizeCorner);
                        ((JideScrollPane)component).setScrollBarCorner("VERTICAL_TOP", null);
                    }
                });
                return;
            }
            default: {
                if (this._resizableSupport == null) break;
                this._resizableSupport.getResizable().setResizableCorners(n);
            }
        }
    }

    private static Component getTopLevelAncestor(Component component) {
        if (component == null) {
            return null;
        }
        while (component != null) {
            if (component instanceof Window || component instanceof Applet) {
                return component;
            }
            component = component.getParent();
        }
        return null;
    }

    public final void packPopup() {
        if (this._popupType == 0) {
            if (this._panel == null) {
                return;
            }
            this._panel.setSize(this._panel.getPreferredSize());
            return;
        }
        if (this._popupType == 2) {
            if (this._window == null) {
                return;
            }
            this._window.pack();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void internalShowPopup(int var1_1, int var2_3, Component var3_5) {
        block36: {
            block38: {
                block39: {
                    block35: {
                        block37: {
                            if (var3_5 != null) {
                                v0 = var3_5;
                            } else {
                                var3_5 = this;
                                v0 = this._actualOwner = var3_5._owner;
                            }
                            if (this._actualOwner != null) {
                                try {
                                    this._actualOwnerLocation = this._actualOwner.getLocationOnScreen();
                                }
                                catch (IllegalComponentStateException v1) {
                                    return;
                                }
                            }
                            var4_14 = var2_3;
                            var3_6 = var1_1;
                            var2_4 = this._actualOwner;
                            var1_2 = this;
                            if (var1_2._popupType == 0) {
                                if (var1_2._panel == null) {
                                    var5_15 /* !! */  = var1_2;
                                    var6_17 = new ResizablePanel(var5_15 /* !! */ ){

                                        protected final Resizable createResizable() {
                                            return new Resizable(this, this){
                                                private /* synthetic */ 3 this$1;
                                                {
                                                    this.this$1 = var1_1;
                                                    super(jComponent);
                                                }

                                                public final void resizing$2e715812(int n, int n2, int n3, int n4) {
                                                    this.this$1.setBounds(n, n2, n3, n4);
                                                }
                                            };
                                        }
                                    };
                                    var6_17.setVisible(false);
                                    var6_17.setOpaque(false);
                                    var6_17.setLayout(new BorderLayout());
                                    var6_17.add(var5_15 /* !! */ );
                                    var1_2._panel = var6_17;
                                    var1_2._resizableSupport = var1_2._panel;
                                    var1_2.installListeners();
                                    var1_2.installBorder();
                                }
                                if (var1_2._previousSize != null) {
                                    var1_2._panel.setSize(var1_2._previousSize);
                                    var1_2._previousSize = null;
                                } else {
                                    var1_2.packPopup();
                                }
                                if (var1_2._insets != null) {
                                    var5_15 /* !! */  = var1_2.getPopupLocation(new Point(var3_6, var4_14), var1_2._panel.getSize(), (Component)var2_4);
                                    var3_6 = var5_15 /* !! */ .x;
                                    var4_14 = var5_15 /* !! */ .y;
                                }
                                if ((var5_15 /* !! */  = JideSwingUtilities.getOutermostRootPane((Component)var2_4)) != null) {
                                    var2_4 = var5_15 /* !! */ .getLayeredPane();
                                    var3_7 = new Point(var3_6, var4_14);
                                    SwingUtilities.convertPointFromScreen(var3_7, (Component)var2_4);
                                    var2_4.add((Component)var1_2._panel, JLayeredPane.PALETTE_LAYER);
                                    if (SystemInfo.isJdk15Above()) {
                                        var2_4.setComponentZOrder(var1_2._panel, 0);
                                    }
                                    var1_2._panel.setLocation(var3_7.x, var3_7.y);
                                }
                            } else if (var1_2._popupType == 2) {
                                if (var1_2._window == null) {
                                    var6_18 = var2_4;
                                    var5_16 /* !! */  = var1_2;
                                    var7_19 = JidePopup.getTopLevelAncestor(var6_18);
                                    if (var7_19 instanceof Frame) {
                                        var6_18 = new ResizableWindow((Frame)var7_19);
                                    } else if (var7_19 instanceof Window) {
                                        var6_18 = new ResizableWindow((Window)var7_19);
                                    } else {
                                        var6_18 = JidePopup.getFrame(var6_18);
                                        var6_18 = new ResizableWindow((Frame)var6_18);
                                    }
                                    var6_18.setName("JidePopup");
                                    var6_18.getContentPane().add(var5_16 /* !! */ );
                                    var1_2._window = var6_18;
                                    var1_2._resizableSupport = var1_2._window;
                                    var1_2.installListeners();
                                    var1_2.installBorder();
                                }
                                if (var1_2._previousSize != null) {
                                    var1_2._window.setSize(var1_2._previousSize);
                                    var1_2._previousSize = null;
                                } else {
                                    var1_2.packPopup();
                                }
                                if (var1_2._insets != null) {
                                    var5_16 /* !! */  = var1_2.getPopupLocation(new Point(var3_6, var4_14), var1_2._window.getSize(), (Component)var2_4);
                                    var3_6 = var5_16 /* !! */ .x;
                                    var4_14 = var5_16 /* !! */ .y;
                                }
                                var1_2._window.setLocation(var3_6, var4_14);
                            }
                            var1_2 = this;
                            if (var1_2._popupType != 0) break block35;
                            if (var1_2._panel == null) break block36;
                            var1_2._panel.applyComponentOrientation(var1_2.getComponentOrientation());
                            var1_2.firePopupMenuWillBecomeVisible();
                            if (!var1_2._panel.isVisible()) {
                                var1_2.packPopup();
                                var1_2._panel.setVisible(true);
                            }
                            var1_2.firePropertyChange("visible", Boolean.FALSE, Boolean.TRUE);
                            if (var1_2.isFocusable()) break block37;
                            var3_8 = var1_2;
                            if (var3_8._defaultFocusComponent == null) break block38;
                        }
                        var3_9 = var1_2;
                        if (var3_9._defaultFocusComponent != null) {
                            var2_4 = new Runnable(var1_2){
                                private /* synthetic */ JidePopup this$0;
                                {
                                    this.this$0 = jidePopup;
                                }

                                public final void run() {
                                    this.this$0.getDefaultFocusComponent().requestFocus();
                                }
                            };
                            SwingUtilities.invokeLater((Runnable)var2_4);
                        }
                        break block38;
                    }
                    if (var1_2._popupType != 2) break block38;
                    if (var1_2._window == null) break block36;
                    var1_2._window.applyComponentOrientation(var1_2.getComponentOrientation());
                    var1_2.firePopupMenuWillBecomeVisible();
                    if (var1_2.isFocusable()) ** GOTO lbl-1000
                    var3_10 = var1_2;
                    if (var3_10._defaultFocusComponent == null) {
                        var1_2._window.setFocusableWindowState(false);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var1_2.setFocusCycleRoot(true);
                    }
                    if (!var1_2._window.isVisible()) {
                        var1_2._window.pack();
                        var1_2._window.setVisible(true);
                    }
                    var1_2.firePropertyChange("visible", Boolean.FALSE, Boolean.TRUE);
                    if (var1_2.isFocusable()) break block39;
                    var3_11 = var1_2;
                    if (var3_11._defaultFocusComponent == null) break block38;
                }
                var1_2._window.setFocusable(true);
                var3_12 = var1_2;
                if (var3_12._defaultFocusComponent != null) {
                    var2_4 = new Runnable(var1_2){
                        private /* synthetic */ JidePopup this$0;
                        {
                            this.this$0 = jidePopup;
                        }

                        public final void run() {
                            this.this$0.getDefaultFocusComponent().requestFocus();
                        }
                    };
                    SwingUtilities.invokeLater((Runnable)var2_4);
                }
            }
            var3_13 = var1_2;
        }
    }

    public final void showPopup(int n, int n2) {
        Component component = null;
        int n3 = n2;
        n2 = n;
        JidePopup jidePopup = this;
        jidePopup.internalShowPopup(n2, n3, component);
    }

    private static Frame getFrame(Component component) {
        while (!(component instanceof Frame) && component != null) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private void installListeners() {
        Component component;
        SwingUtilities.invokeLater(new Runnable(this){
            private /* synthetic */ JidePopup this$0;
            {
                this.this$0 = jidePopup;
            }

            public final void run() {
                JidePopup.access$000(this.this$0);
            }
        });
        this._componentListener = new ComponentAdapter(this){
            private /* synthetic */ JidePopup this$0;
            {
                this.this$0 = jidePopup;
            }

            public final void componentHidden(ComponentEvent componentEvent) {
                this.this$0.hidePopup();
            }
        };
        this._escapeActionListener = new ActionListener(this){
            private /* synthetic */ JidePopup this$0;
            {
                this.this$0 = jidePopup;
            }

            public final void actionPerformed(ActionEvent serializable) {
                serializable = this.this$0.getActualOwner();
                this.this$0.hidePopupImmediately(true);
                if (serializable != null) {
                    ((Component)serializable).requestFocus();
                }
            }
        };
        this.registerKeyboardAction(this._escapeActionListener, KeyStroke.getKeyStroke(27, 0), 1);
        if (this._popupType == 2) {
            this._window.addComponentListener(this._componentListener);
            this._windowListener = new WindowAdapter(this){
                private /* synthetic */ JidePopup this$0;
                {
                    this.this$0 = jidePopup;
                }

                public final void windowClosing(WindowEvent windowEvent) {
                    this.this$0.hidePopup();
                }
            };
            this._window.addWindowListener(this._windowListener);
        }
        if ((component = this.getActualOwner()) != null) {
            this._ownerComponentListener = new ComponentAdapter(this){
                private /* synthetic */ JidePopup this$0;
                {
                    this.this$0 = jidePopup;
                }

                public final void componentHidden(ComponentEvent componentEvent) {
                    this.this$0.ancestorHidden();
                }

                public final void componentMoved(ComponentEvent componentEvent) {
                    if (this.this$0._actualOwnerLocation == null || this.this$0._actualOwner == null || !this.this$0._actualOwner.getLocationOnScreen().equals(this.this$0._actualOwnerLocation)) {
                        this.this$0.ancestorMoved();
                    }
                }
            };
            component.addComponentListener(this._ownerComponentListener);
            this._hierarchyListener = new HierarchyListener(this){
                private /* synthetic */ JidePopup this$0;
                {
                    this.this$0 = jidePopup;
                }

                public final void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    this.this$0.ancestorHidden();
                }
            };
            component.addHierarchyListener(this._hierarchyListener);
        }
        this._popupResizeListener = new ComponentAdapter(this){
            private /* synthetic */ JidePopup this$0;
            {
                this.this$0 = jidePopup;
            }

            public final void componentResized(ComponentEvent componentEvent) {
                this.this$0.removeComponentListener(this.this$0._popupResizeListener);
                this.this$0.contentResized();
                this.this$0.addComponentListener(this.this$0._popupResizeListener);
            }
        };
        this.addComponentListener(this._popupResizeListener);
    }

    protected final void contentResized() {
        this.packPopup();
    }

    private void installBorder() {
        JidePopup jidePopup = this;
        if (jidePopup._popupBorder != null) {
            jidePopup = this;
            if (jidePopup._resizable) {
                this._resizableSupport.getResizable().setResizableCorners(255);
            } else {
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
            jidePopup = this;
            this._resizableSupport.setBorder(jidePopup._popupBorder);
            return;
        }
        jidePopup = this;
        if (jidePopup._detached) {
            jidePopup = this;
            if (jidePopup._resizable) {
                this._resizableSupport.getResizable().setResizableCorners(255);
            } else {
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
            this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
            return;
        }
        jidePopup = this;
        if (jidePopup._resizable) {
            this._resizableSupport.getResizable().setResizableCorners(56);
        } else {
            this._resizableSupport.getResizable().setResizableCorners(0);
        }
        this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("PopupMenu.border"));
    }

    private static void convertPointToScreen(Point point, Component component, boolean bl) {
        do {
            int point2;
            int n;
            block6: {
                if (component instanceof JComponent) {
                    n = component.getX();
                    point2 = component.getY();
                } else {
                    if (component instanceof Applet || component instanceof Window) {
                        try {
                            Point point3 = component.getLocationOnScreen();
                            n = point3.x;
                            point2 = point3.y;
                            break block6;
                        }
                        catch (IllegalComponentStateException illegalComponentStateException) {}
                    }
                    n = component.getX();
                    point2 = component.getY();
                }
            }
            point.x += n;
            point.y += point2;
        } while (!(component instanceof Window) && !(component instanceof Applet) && (component = component.getParent()) != null);
    }

    private static boolean isWithinAroundArea(Point cloneable, Point point) {
        cloneable = new Rectangle(cloneable.x - 10, cloneable.y - 10, cloneable.x + 10, cloneable.y + 10);
        return ((Rectangle)cloneable).contains(point);
    }

    private static boolean isAncestorOf(Component component, Object object) {
        if (component == null) {
            return false;
        }
        while (component != null) {
            if (component == object) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void handleMousePressed(MouseEvent mouseEvent) {
        Window window;
        Component component = mouseEvent.getComponent();
        if (component == null) {
            return;
        }
        component = SwingUtilities.getDeepestComponentAt(component, mouseEvent.getX(), mouseEvent.getY());
        if (!this.isClickOnPopup(mouseEvent)) {
            Component component2 = component;
            component = this;
            boolean bl = ((JidePopup)component)._excludedComponents.contains(component2);
            if (!bl) {
                Component component3;
                Object object = ((JidePopup)component)._excludedComponents.iterator();
                while (object.hasNext()) {
                    component3 = object.next();
                    if (!(component3 instanceof Container) || !((Container)component3).isAncestorOf(component2)) continue;
                    return;
                }
                if (component2 instanceof JComponent && (object = ((JComponent)component2).getTopLevelAncestor()) instanceof RootPaneContainer && (component3 = JidePopup.getRealParent((RootPaneContainer)object)) != null && ((JComponent)component3).getTopLevelAncestor() == ((JComponent)component).getTopLevelAncestor()) {
                    return;
                }
            }
            boolean bl2 = bl;
            if (bl2) {
                return;
            }
            this.ancestorHidden();
            return;
        }
        if (!this.isPopupVisible()) return;
        Serializable serializable = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), this);
        Serializable serializable2 = null;
        if (this._popupType == 0) {
            serializable2 = this._panel.getBounds();
            Container container = this._panel.getParent();
            if (SystemInfo.isJdk15Above() && this.isClickOnPopup(mouseEvent) && container.getComponentZOrder(this._panel) != 0) {
                container.setComponentZOrder(this._panel, 0);
                container.repaint();
            }
        } else if (this._popupType == 2 && (window = SwingUtilities.getWindowAncestor(component)) == this._window) {
            serializable2 = this._window.getBounds();
            if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() != this._window) {
                this._window.toFront();
            }
        }
        if (serializable2 == null) return;
        this._relativeX = (double)((Point)serializable).x / (double)((Rectangle)serializable2).width;
        this._relativeY = (double)((Point)serializable).y / (double)((Rectangle)serializable2).height;
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        JidePopup.convertPointToScreen(point, component, true);
        Component component4 = component;
        component = this;
        if (!JidePopup.isAncestorOf(component4, ((PopupUI)((JidePopup)component).ui).getGripper())) return;
        double d = this._relativeY;
        double d2 = this._relativeX;
        serializable = this;
        component = this;
        this._relativeX = d2;
        ((JidePopup)component)._relativeY = d;
        serializable2 = ((JidePopup)component).getActualOwner();
        if (((JidePopup)component)._popupType == 0) {
            ((JidePopup)component)._currentPanel = ((JidePopup)component)._panel;
            ((JidePopup)component)._isDragging = true;
            serializable = component;
            if (((JidePopup)serializable)._detached && serializable2 != null) {
                ((JidePopup)component)._startPoint = ((Component)serializable2).getLocationOnScreen();
                ((JidePopup)component)._startPoint.y += ((Component)serializable2).getHeight();
            } else {
                ((JidePopup)component)._startPoint = ((JidePopup)component)._currentPanel.getLocationOnScreen();
            }
        } else if (((JidePopup)component)._popupType == 2) {
            if (((JComponent)serializable).getTopLevelAncestor() instanceof JWindow) {
                ((JidePopup)component)._currentWindow = (JWindow)((JComponent)serializable).getTopLevelAncestor();
            }
            if (((JComponent)serializable).getTopLevelAncestor() instanceof JDialog) {
                ((JidePopup)component)._currentWindow = (JDialog)((JComponent)serializable).getTopLevelAncestor();
            }
            if (((JidePopup)component)._currentWindow instanceof JWindow && ((JWindow)((JidePopup)component)._currentWindow).getGlassPane() != null) {
                ((JWindow)((JidePopup)component)._currentWindow).getGlassPane().setVisible(true);
                ((JWindow)((JidePopup)component)._currentWindow).getGlassPane().setCursor(Cursor.getPredefinedCursor(13));
            } else if (((JidePopup)component)._currentWindow instanceof JDialog && ((JDialog)((JidePopup)component)._currentWindow).getGlassPane() != null) {
                ((JDialog)((JidePopup)component)._currentWindow).getGlassPane().setVisible(true);
                ((JDialog)((JidePopup)component)._currentWindow).getGlassPane().setCursor(Cursor.getPredefinedCursor(13));
            }
            ((JidePopup)component)._isDragging = true;
            serializable = component;
            if (((JidePopup)serializable)._detached && serializable2 != null) {
                ((JidePopup)component)._startPoint = ((Component)serializable2).getLocationOnScreen();
                ((JidePopup)component)._startPoint.y += ((Component)serializable2).getHeight();
            } else {
                ((JidePopup)component)._startPoint = ((JidePopup)component)._currentWindow.getLocationOnScreen();
            }
        }
        mouseEvent.consume();
    }

    protected final void handleMouseReleased(MouseEvent mouseEvent) {
        JidePopup jidePopup = this;
        if (jidePopup._isDragging) {
            jidePopup = this;
            this._isDragging = false;
            if (jidePopup._popupType == 0) {
                jidePopup._currentPanel = null;
            } else if (jidePopup._popupType == 2) {
                if (jidePopup._currentWindow instanceof JWindow && ((JWindow)jidePopup._currentWindow).getGlassPane() != null) {
                    ((JWindow)jidePopup._currentWindow).getGlassPane().setVisible(false);
                    ((JWindow)jidePopup._currentWindow).getGlassPane().setCursor(Cursor.getDefaultCursor());
                } else if (jidePopup._currentWindow instanceof JDialog && ((JDialog)jidePopup._currentWindow).getGlassPane() != null) {
                    ((JDialog)jidePopup._currentWindow).getGlassPane().setVisible(false);
                    ((JDialog)jidePopup._currentWindow).getGlassPane().setCursor(Cursor.getDefaultCursor());
                }
                jidePopup._currentWindow = null;
            }
            jidePopup._relativeX = 0.0;
            jidePopup._relativeY = 0.0;
            mouseEvent.consume();
        }
    }

    protected final void handleMouseDragged(MouseEvent mouseEvent) {
        Serializable serializable = this;
        if (serializable._isDragging) {
            Serializable serializable2 = mouseEvent.getPoint();
            JidePopup.convertPointToScreen((Point)serializable2, (Component)mouseEvent.getSource(), true);
            int n = ((Point)serializable2).x;
            int n2 = ((Point)serializable2).y;
            mouseEvent.getModifiersEx();
            int n3 = n2;
            int n4 = n;
            serializable2 = this;
            if (((JidePopup)serializable2)._popupType == 0) {
                serializable = new Rectangle(n4 -= (int)((double)((JidePopup)serializable2)._currentPanel.getWidth() * ((JidePopup)serializable2)._relativeX), n3 -= (int)((double)((JidePopup)serializable2)._currentPanel.getHeight() * ((JidePopup)serializable2)._relativeY), ((JidePopup)serializable2)._currentPanel.getWidth(), ((JidePopup)serializable2)._currentPanel.getHeight());
                Rectangle rectangle = PortingUtils.getScreenBounds(((JidePopup)serializable2)._currentPanel);
                if (((Rectangle)serializable).y + ((Rectangle)serializable).height > rectangle.y + rectangle.height) {
                    ((Rectangle)serializable).y = rectangle.y + rectangle.height - ((Rectangle)serializable).height;
                }
                if (((Rectangle)serializable).y < rectangle.y) {
                    ((Rectangle)serializable).y = rectangle.y;
                }
                serializable = serializable2;
                if (serializable._attachable && JidePopup.isWithinAroundArea(new Point(n4, n3), ((JidePopup)serializable2)._startPoint)) {
                    Point point = new Point(((JidePopup)serializable2)._startPoint);
                    SwingUtilities.convertPointFromScreen(point, ((JidePopup)serializable2)._currentPanel.getParent());
                    ((JidePopup)serializable2)._currentPanel.setLocation(point);
                    super.setDetached(false);
                } else {
                    Point point = new Point(n4, n3);
                    SwingUtilities.convertPointFromScreen(point, ((JidePopup)serializable2)._currentPanel.getParent());
                    ((JidePopup)serializable2)._currentPanel.setLocation(point);
                    super.setDetached(true);
                }
            } else if (((JidePopup)serializable2)._popupType == 2) {
                serializable = new Rectangle(n4 -= (int)((double)((JidePopup)serializable2)._currentWindow.getWidth() * ((JidePopup)serializable2)._relativeX), n3 -= (int)((double)((JidePopup)serializable2)._currentWindow.getHeight() * ((JidePopup)serializable2)._relativeY), ((JidePopup)serializable2)._currentWindow.getWidth(), ((JidePopup)serializable2)._currentWindow.getHeight());
                Rectangle rectangle = PortingUtils.getScreenBounds(((JidePopup)serializable2)._currentWindow);
                if (((Rectangle)serializable).y + ((Rectangle)serializable).height > rectangle.y + rectangle.height) {
                    ((Rectangle)serializable).y = rectangle.y + rectangle.height - ((Rectangle)serializable).height;
                }
                if (((Rectangle)serializable).y < rectangle.y) {
                    ((Rectangle)serializable).y = rectangle.y;
                }
                serializable = serializable2;
                if (serializable._attachable && JidePopup.isWithinAroundArea(new Point(n4, n3), ((JidePopup)serializable2)._startPoint)) {
                    ((JidePopup)serializable2)._currentWindow.setLocation(((JidePopup)serializable2)._startPoint);
                    super.setDetached(false);
                } else {
                    ((JidePopup)serializable2)._currentWindow.setLocation(n4, n3);
                    super.setDetached(true);
                }
            }
            mouseEvent.consume();
        }
    }

    protected final void handleMouseEntered(MouseEvent serializable) {
        block1: {
            block0: {
                if (this._popupType != 0) break block0;
                if (this._panel == null || !this._panel.isAncestorOf((Component)serializable.getSource())) break block1;
                serializable = this;
                break block1;
            }
            if (this._popupType != 2 || this._window == null || !this._window.isAncestorOf((Component)serializable.getSource())) break block1;
            serializable = this;
        }
    }

    protected final void handleMouseExited(MouseEvent serializable) {
        block1: {
            block0: {
                if (this._popupType != 0) break block0;
                if (this._panel == null || !this._panel.isAncestorOf((Component)serializable.getSource())) break block1;
                serializable = this;
                break block1;
            }
            if (this._popupType != 2 || this._window == null || !this._window.isAncestorOf((Component)serializable.getSource())) break block1;
            serializable = this;
        }
    }

    protected final void handleWindowEvent(WindowEvent serializable) {
        Component component = this.getActualOwner();
        if (((EventObject)serializable).getSource() != this.getTopLevelAncestor() && JidePopup.isAncestorOf(component, ((WindowEvent)serializable).getWindow())) {
            if (((AWTEvent)serializable).getID() == 201 || ((AWTEvent)serializable).getID() == 203) {
                this.hidePopup(true);
                return;
            }
            component = this;
            if (((JidePopup)component)._transient && ((AWTEvent)serializable).getID() == 206 && !(((WindowEvent)serializable).getWindow() instanceof EmbeddedFrame)) {
                if (!checkedUnpostPopup) {
                    unpostPopup = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                        public final Object run() {
                            String string = "sun.swing.unpostPopupsOnWindowDeactivation";
                            string = System.getProperty("sun.swing.unpostPopupsOnWindowDeactivation", "true");
                            return Boolean.valueOf(string);
                        }
                    });
                    checkedUnpostPopup = true;
                }
                if (unpostPopup) {
                    if ((serializable = ((WindowEvent)serializable).getOppositeWindow()) == this.getTopLevelAncestor()) {
                        return;
                    }
                    if (serializable instanceof RootPaneContainer && (serializable = JidePopup.getRealParent((RootPaneContainer)((Object)serializable))) != null && ((JComponent)serializable).getTopLevelAncestor() == this.getTopLevelAncestor()) {
                        return;
                    }
                    this.hidePopup(true);
                }
            }
        }
    }

    private static JComponent getRealParent(RootPaneContainer object) {
        if ((object = JideSwingUtilities.getFirstJComponent((RootPaneContainer)object)) != null && (object = ((JComponent)object).getClientProperty("JidePopup.actualOwner")) instanceof JComponent) {
            return (JComponent)object;
        }
        return null;
    }

    protected final void handleComponentEvent(ComponentEvent componentEvent) {
        Component component = this.getActualOwner();
        if (componentEvent.getID() == 103 && JidePopup.isAncestorOf(component, componentEvent.getSource())) {
            this.ancestorHidden();
            return;
        }
        if (componentEvent.getID() == 100 && JidePopup.isAncestorOf(component, componentEvent.getSource()) && (this._actualOwnerLocation == null || this._actualOwner == null || !this._actualOwner.getLocationOnScreen().equals(this._actualOwnerLocation))) {
            this.ancestorMoved();
        }
    }

    protected final void ancestorHidden() {
        JidePopup jidePopup = this;
        if (jidePopup._transient) {
            this.hidePopupImmediately(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void ancestorMoved() {
        JidePopup jidePopup = this;
        if (jidePopup._defaultMoveOperation != 1) {
            JidePopup jidePopup2 = this;
            if (jidePopup2._defaultMoveOperation != 0) return;
            JidePopup jidePopup3 = this;
            if (!jidePopup3._transient) return;
            this.hidePopupImmediately(true);
            return;
        }
        JidePopup jidePopup4 = this;
        if (!jidePopup4.isPopupVisible()) return;
        JidePopup jidePopup5 = jidePopup4;
        if (jidePopup5._detached) return;
        if (jidePopup4._actualOwner == null) return;
        if (jidePopup4._insets != null) {
            jidePopup4.showPopup(jidePopup4._insets, jidePopup4._actualOwner);
            return;
        }
        if (jidePopup4._actualOwnerLocation == null) return;
        Point point = jidePopup4._actualOwner.getLocationOnScreen();
        Point point2 = null;
        if (jidePopup4._popupType == 0) {
            point2 = jidePopup4._panel.getLocationOnScreen();
        } else if (jidePopup4._popupType == 2) {
            point2 = jidePopup4._window.getLocationOnScreen();
        }
        if (point2 == null) return;
        point2.x += point.x - jidePopup4._actualOwnerLocation.x;
        point2.y += point.y - jidePopup4._actualOwnerLocation.y;
        Component component = jidePopup4._actualOwner;
        int n = point2.y;
        int n2 = point2.x;
        JidePopup jidePopup6 = jidePopup4;
        jidePopup6.internalShowPopup(n2, n, component);
    }

    public final void hidePopup() {
        this.hidePopup(false);
    }

    public final void hidePopup(boolean bl) {
        if (!this.isPopupVisible()) {
            return;
        }
        this.hidePopupImmediately(bl);
    }

    public final boolean isPopupVisible() {
        if (this._popupType == 0) {
            return this._panel != null && this._panel.isVisible();
        }
        if (this._popupType == 2) {
            return this._window != null && this._window.isShowing();
        }
        return false;
    }

    public final void hidePopupImmediately(boolean bl) {
        Component component = this.getActualOwner();
        if (component != null) {
            component.removeHierarchyListener(this._hierarchyListener);
            this._hierarchyListener = null;
            component.removeComponentListener(this._ownerComponentListener);
            this._ownerComponentListener = null;
        }
        if (this._escapeActionListener != null) {
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
            this._escapeActionListener = null;
        }
        if (this._window != null) {
            this._window.removeWindowListener(this._windowListener);
            this._windowListener = null;
            this._window.removeComponentListener(this._componentListener);
            this._componentListener = null;
            this._window.getContentPane().remove(this);
            if (bl) {
                this.firePopupMenuCanceled();
            }
            this.firePopupMenuWillBecomeInvisible();
        }
        if (this._panel != null) {
            this._panel.remove(this);
            if (bl) {
                this.firePopupMenuCanceled();
            }
            this.firePopupMenuWillBecomeInvisible();
        }
        if (this._popupResizeListener != null) {
            this.removeComponentListener(this._popupResizeListener);
            this._popupResizeListener = null;
        }
        if (this._window != null) {
            this._previousSize = this._window.getSize();
            this._window.setVisible(false);
            this._window.removeAll();
            this._window.dispose();
            this._window = null;
            this.firePropertyChange("visible", Boolean.TRUE, Boolean.FALSE);
        }
        if (this._panel != null) {
            this._previousSize = this._panel.getSize();
            this._panel.setVisible(false);
            Container container = this._panel.getParent();
            if (container != null) {
                container.remove(this._panel);
            }
            this._panel = null;
            this.firePropertyChange("visible", Boolean.TRUE, Boolean.FALSE);
        }
        SwingUtilities.invokeLater(new Runnable(this){
            private /* synthetic */ JidePopup this$0;
            {
                this.this$0 = jidePopup;
            }

            public final void run() {
                JidePopup.access$200(this.this$0);
            }
        });
        this._resizableSupport = null;
        this._owner = null;
        this._actualOwner = null;
        this._actualOwnerLocation = null;
    }

    public final void hidePopupImmediately() {
        this.hidePopupImmediately(false);
    }

    private static boolean shouldAWTEventListenerBeUsed() {
        return SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"));
    }

    public final void setOwner(Component component) {
        if (this._owner != component) {
            Component component2 = this._owner;
            this._owner = component;
            this.firePropertyChange("owner", component2, this._owner);
            this.removeExcludedComponent(component2);
            this.addExcludedComponent(this._owner);
        }
    }

    public final boolean isMovable() {
        return this._movable;
    }

    public final void setMovable(boolean bl) {
        bl = this._movable;
        if (bl) {
            this._movable = false;
            this.firePropertyChange("movable", bl, this._movable);
        }
    }

    public final void setResizable(boolean bl) {
        if (!this._resizable) {
            bl = this._resizable;
            this._resizable = true;
            this.firePropertyChange("resizable", bl, this._resizable);
        }
    }

    private void setDetached(boolean bl) {
        if (this._detached != bl) {
            boolean bl2 = this._detached;
            this._detached = bl;
            this.firePropertyChange("detacted", bl2, this._detached);
            if (this._resizableSupport != null) {
                if (this._detached) {
                    JidePopup jidePopup = this;
                    if (jidePopup._popupBorder == null) {
                        this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
                    } else {
                        jidePopup = this;
                        this._resizableSupport.setBorder(jidePopup._popupBorder);
                    }
                    jidePopup = this;
                    if (jidePopup._resizable) {
                        this._resizableSupport.getResizable().setResizableCorners(255);
                        return;
                    }
                    this._resizableSupport.getResizable().setResizableCorners(0);
                    return;
                }
                JidePopup jidePopup = this;
                if (jidePopup._popupBorder == null) {
                    this._resizableSupport.setBorder(UIDefaultsLookup.getBorder("PopupMenu.border"));
                } else {
                    jidePopup = this;
                    this._resizableSupport.setBorder(jidePopup._popupBorder);
                }
                jidePopup = this;
                if (jidePopup._resizable) {
                    this._resizableSupport.getResizable().setResizableCorners(56);
                    return;
                }
                this._resizableSupport.getResizable().setResizableCorners(0);
            }
        }
    }

    public final void setPopupBorder(Border border) {
        this._popupBorder = border;
    }

    public final void setTransient(boolean bl) {
        bl = this._transient;
        if (!bl) {
            this._transient = true;
            this.firePropertyChange("transient", bl, true);
        }
    }

    public final Component getDefaultFocusComponent() {
        return this._defaultFocusComponent;
    }

    public final void setDefaultFocusComponent(Component component) {
        this._defaultFocusComponent = component;
    }

    public final void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    private void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    private void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    private void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    public final void setDefaultMoveOperation(int n) {
        this._defaultMoveOperation = 0;
    }

    public final void addExcludedComponent(Component component) {
        if (component != null && !this._excludedComponents.contains(component)) {
            this._excludedComponents.add(component);
        }
    }

    public final void removeExcludedComponent(Component component) {
        this._excludedComponents.remove(component);
    }

    public final int getGripperLocation() {
        return this._gripperLocation;
    }

    public final void setPopupType(int n) {
        if (n != 0 && n != 2) {
            throw new IllegalArgumentException("invalid popup type. It must be JidePopup.HEAVY_WEIGHT_POPUP or JidePopup.LIGHT_WEIGHT_POPUP.");
        }
        this._popupType = n;
    }

    private boolean isClickOnPopup(MouseEvent serializable) {
        Component component = serializable.getComponent();
        if (component == null) {
            return false;
        }
        serializable = SwingUtilities.getDeepestComponentAt(component, serializable.getX(), serializable.getY());
        component = this;
        if (((JidePopup)component)._popupType == 2) {
            return JidePopup.isAncestorOf((Component)serializable, this._window);
        }
        return JidePopup.isAncestorOf((Component)serializable, this._panel);
    }

    protected final Component getActualOwner() {
        if (this._actualOwner != null) {
            return this._actualOwner;
        }
        JidePopup jidePopup = this;
        return jidePopup._owner;
    }

    static /* synthetic */ void access$000(JidePopup jidePopup) {
        if (!JidePopup.shouldAWTEventListenerBeUsed()) {
            if (jidePopup._awtEventListener == null) {
                jidePopup._awtEventListener = new AWTEventListener(jidePopup){
                    private /* synthetic */ JidePopup this$0;
                    {
                        this.this$0 = jidePopup;
                    }

                    public final void eventDispatched(AWTEvent aWTEvent) {
                        if ("sun.awt.UngrabEvent".equals(aWTEvent.getClass().getName())) {
                            this.this$0.hidePopupImmediately(true);
                            return;
                        }
                        if (aWTEvent instanceof MouseEvent) {
                            if (aWTEvent.getID() == 501) {
                                this.this$0.handleMousePressed((MouseEvent)aWTEvent);
                                return;
                            }
                            if (aWTEvent.getID() == 506) {
                                this.this$0.handleMouseDragged((MouseEvent)aWTEvent);
                                return;
                            }
                            if (aWTEvent.getID() == 502) {
                                this.this$0.handleMouseReleased((MouseEvent)aWTEvent);
                                return;
                            }
                            if (aWTEvent.getID() == 504) {
                                this.this$0.handleMouseEntered((MouseEvent)aWTEvent);
                                return;
                            }
                            if (aWTEvent.getID() == 505) {
                                this.this$0.handleMouseExited((MouseEvent)aWTEvent);
                                return;
                            }
                        } else {
                            if (aWTEvent instanceof WindowEvent) {
                                this.this$0.handleWindowEvent((WindowEvent)aWTEvent);
                                return;
                            }
                            if (aWTEvent instanceof ComponentEvent) {
                                this.this$0.handleComponentEvent((ComponentEvent)aWTEvent);
                            }
                        }
                    }
                };
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction(jidePopup){
                    private /* synthetic */ JidePopup this$0;
                    {
                        this.this$0 = jidePopup;
                    }

                    public final Object run() {
                        Toolkit.getDefaultToolkit().addAWTEventListener(this.this$0._awtEventListener, 113L);
                        return null;
                    }
                });
                return;
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
        }
    }

    static /* synthetic */ void access$200(JidePopup jidePopup) {
        if (!JidePopup.shouldAWTEventListenerBeUsed()) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(jidePopup){
                    private /* synthetic */ JidePopup this$0;
                    {
                        this.this$0 = jidePopup;
                    }

                    public final Object run() {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this.this$0._awtEventListener);
                        JidePopup.access$302(this.this$0, null);
                        return null;
                    }
                });
                return;
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
        }
    }

    static /* synthetic */ AWTEventListener access$302(JidePopup jidePopup, AWTEventListener aWTEventListener) {
        jidePopup._awtEventListener = null;
        return null;
    }

    public final class AccessiblePopup
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JidePopup this$0;

        protected AccessiblePopup(JidePopup jidePopup) {
            this.this$0 = jidePopup;
            super(jidePopup);
        }

        public final String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return this.this$0.getName();
        }

        public final AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public final AccessibleValue getAccessibleValue() {
            return this;
        }

        public final Number getCurrentAccessibleValue() {
            if (this.isVisible()) {
                return 1;
            }
            return 0;
        }

        public final boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                if (number.intValue() == 0) {
                    this.setVisible(true);
                } else {
                    this.setVisible(false);
                }
                return true;
            }
            return false;
        }

        public final Number getMinimumAccessibleValue() {
            return Integer.MIN_VALUE;
        }

        public final Number getMaximumAccessibleValue() {
            return Integer.MAX_VALUE;
        }
    }
}

