/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.plaf.xerto.XertoUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public final class SlidingFrameBorder
implements Border,
UIResource {
    private Color _highlight;
    private Color _lightHighlight;
    private Color _shadow;
    private Color _darkShadow;
    private Insets _insets;
    private static double LOG10 = Math.log(10.0);

    public SlidingFrameBorder(Color color, Color color2, Color color3, Color color4, Insets insets) {
        this._highlight = color;
        this._lightHighlight = color2;
        this._shadow = color3;
        this._darkShadow = color4;
        this._insets = insets;
    }

    public final Insets getBorderInsets(Component component) {
        return this._insets;
    }

    public final boolean isBorderOpaque() {
        return true;
    }

    public final void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this._insets.top >= 10) {
            graphics.setColor(XertoUtils.getFrameBorderColor());
            graphics.drawRect(n, n2 + this._insets.top - 1, n3, n4 - this._insets.top + 1);
            graphics.setColor(this._highlight);
            graphics.drawLine(n, n2 + this._insets.top - 5, n + n3, n2 + this._insets.top - 5);
            graphics.setColor(this._lightHighlight);
            graphics.drawLine(n, n2 + this._insets.top - 4, n + n3, n2 + this._insets.top - 4);
            graphics.setColor(this._highlight);
            graphics.drawLine(n, n2 + this._insets.top - 3, n + n3, n2 + this._insets.top - 3);
            graphics.drawLine(n, n2 + this._insets.top - 2, n + n3, n2 + this._insets.top - 2);
            SlidingFrameBorder.paintGradient(graphics, new Rectangle(n, n2, n3, this._insets.top - 5), true, 40, false);
        }
        if (this._insets.left >= 10) {
            graphics.setColor(XertoUtils.getFrameBorderColor());
            graphics.drawRect(n + this._insets.left - 1, n2, n3 - this._insets.left, n4);
            graphics.setColor(this._highlight);
            graphics.drawLine(n + this._insets.left - 5, n2, n + this._insets.left - 5, n2 + n4);
            graphics.setColor(this._lightHighlight);
            graphics.drawLine(n + this._insets.left - 4, n2, n + this._insets.left - 4, n2 + n4);
            graphics.setColor(this._highlight);
            graphics.drawLine(n + this._insets.left - 3, n2, n + this._insets.left - 3, n2 + n4);
            graphics.drawLine(n + this._insets.left - 2, n2, n + this._insets.left - 2, n2 + n4);
            SlidingFrameBorder.paintGradient(graphics, new Rectangle(n, n2, this._insets.left - 5, n4), false, 40, false);
        }
        if (this._insets.bottom >= 10) {
            graphics.setColor(XertoUtils.getFrameBorderColor());
            graphics.drawRect(n, n2, n3, n4 - this._insets.bottom);
            graphics.setColor(this._highlight);
            graphics.drawLine(n, n2 + n4 - this._insets.bottom + 1, n + n3, n2 + n4 - this._insets.bottom + 1);
            graphics.drawLine(n, n2 + n4 - this._insets.bottom + 2, n + n3, n2 + n4 - this._insets.bottom + 2);
            graphics.setColor(this._shadow);
            graphics.drawLine(n, n2 + n4 - this._insets.bottom + 3, n + n3, n2 + n4 - this._insets.bottom + 3);
            graphics.setColor(this._darkShadow);
            graphics.drawLine(n, n2 + n4 - this._insets.bottom + 4, n + n3, n2 + n4 - this._insets.bottom + 4);
            SlidingFrameBorder.paintGradient(graphics, new Rectangle(n, n2 + n4 - this._insets.bottom + 4, n3, this._insets.bottom - 5), true, 100, true);
        }
        if (this._insets.right >= 10) {
            graphics.setColor(XertoUtils.getFrameBorderColor());
            graphics.drawRect(n, n2, n3 - this._insets.right, n4);
            graphics.setColor(this._highlight);
            graphics.drawLine(n + n3 - this._insets.right + 1, n2, n + n3 - this._insets.right + 1, n2 + n4);
            graphics.drawLine(n + n3 - this._insets.right + 2, n2, n + n3 - this._insets.right + 2, n2 + n4);
            graphics.setColor(this._shadow);
            graphics.drawLine(n + n3 - this._insets.right + 3, n2, n + n3 - this._insets.right + 3, n2 + n4);
            graphics.setColor(this._darkShadow);
            graphics.drawLine(n + n3 - this._insets.right + 4, n2, n + n3 - this._insets.right + 4, n2 + n4);
            SlidingFrameBorder.paintGradient(graphics, new Rectangle(n + n3 - this._insets.right + 4, n2, this._insets.right - 5, n4), false, 100, true);
        }
    }

    private static void paintGradient(Graphics graphics, Rectangle rectangle, boolean n, int n2, boolean bl) {
        if (n != 0) {
            for (n = 1; n < rectangle.height; ++n) {
                int n3 = (int)((1.0 - Math.log(n) / LOG10) * (double)n2);
                graphics.setColor(new Color(0, 0, 0, n3));
                if (bl) {
                    graphics.drawLine(rectangle.x, rectangle.y + n, rectangle.x + rectangle.width, rectangle.y + n);
                    continue;
                }
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - n, rectangle.x + rectangle.width, rectangle.y + rectangle.height - n);
            }
            return;
        }
        for (n = 1; n < rectangle.width; ++n) {
            int n4 = (int)((1.0 - Math.log(n) / LOG10) * (double)n2);
            graphics.setColor(new Color(0, 0, 0, n4));
            if (bl) {
                graphics.drawLine(rectangle.x + n, rectangle.y, rectangle.x + n, rectangle.y + rectangle.height);
                continue;
            }
            graphics.drawLine(rectangle.x + rectangle.width - n, rectangle.y, rectangle.x + rectangle.width - n, rectangle.y + rectangle.height);
        }
    }
}

