/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public final class EclipseUtils {
    private static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);

    public static void fillRectWithHatch(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(color);
        graphics2D.setStroke(DOTTED_STROKE);
        for (int i = 0; i < rectangle.width; ++i) {
            if (i % 2 == 0) {
                graphics2D.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + rectangle.height - 1);
                continue;
            }
            graphics2D.drawLine(rectangle.x + i, rectangle.y + 1, rectangle.x + i, rectangle.y + rectangle.height - 1);
        }
        graphics2D.setStroke(stroke);
    }

    private static int getLightColor(int n, double d) {
        return (int)((double)(255 - n) * d + (double)n);
    }

    private static Color getLighterColor(Color color, double d) {
        int n = EclipseUtils.getLightColor(color.getRed(), d);
        int n2 = EclipseUtils.getLightColor(color.getGreen(), d) + 1;
        int n3 = EclipseUtils.getLightColor(color.getBlue(), d);
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    static Color getSelectedAndFocusedButtonColor(Color color) {
        return EclipseUtils.getLighterColor(color, 0.67);
    }

    static Color getFocusedButtonColor(Color color) {
        return EclipseUtils.getLighterColor(color, 0.78);
    }

    static Color getSelectedButtonColor(Color color) {
        return EclipseUtils.getLighterColor(color, 0.86);
    }
}

