/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.XMLElement;
import com.jidesoft.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class BinaryPListParser {
    private int refCount;
    private int topLevelOffset;
    private ArrayList objectTable;

    public final XMLElement parse(File file) throws IOException {
        Object object;
        RandomAccessFile randomAccessFile = null;
        Object var3_7 = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            int n = randomAccessFile.readInt();
            int n2 = randomAccessFile.readInt();
            if (n != 1651534953 || n2 != 1936994352) {
                throw new IOException("parseHeader: File does not start with 'bplist00' magic.");
            }
            randomAccessFile.seek(randomAccessFile.length() - 32L);
            randomAccessFile.readLong();
            this.refCount = (int)randomAccessFile.readLong();
            randomAccessFile.readLong();
            this.topLevelOffset = (int)randomAccessFile.readLong();
            object = new byte[this.topLevelOffset - 8];
            randomAccessFile.seek(8L);
            randomAccessFile.readFully((byte[])object);
        }
        catch (Throwable throwable) {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            throw throwable;
        }
        randomAccessFile.close();
        this.objectTable = new ArrayList();
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
            this.parseObjectTable((DataInputStream)filterInputStream);
        }
        catch (Throwable throwable) {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
            throw throwable;
        }
        filterInputStream.close();
        XMLElement xMLElement = new XMLElement(new HashMap(), false, false);
        object = xMLElement;
        xMLElement.setName("plist");
        ((XMLElement)object).setAttribute("version", "1.0");
        this.convertObjectTableToXML((XMLElement)object, this.objectTable.get(0));
        return object;
    }

    private void convertObjectTableToXML(XMLElement xMLElement, Object object) {
        XMLElement xMLElement2 = xMLElement.createAnotherElement();
        if (object instanceof BPLDict) {
            BPLDict bPLDict = (BPLDict)object;
            xMLElement2.setName("dict");
            int n = 0;
            while (n < bPLDict.keyref.length) {
                XMLElement xMLElement3 = xMLElement.createAnotherElement();
                xMLElement3.setName("key");
                int n2 = n;
                BPLDict bPLDict2 = bPLDict;
                xMLElement3.setContent(bPLDict2.objectTable.get(bPLDict2.keyref[n2]).toString());
                xMLElement2.addChild(xMLElement3);
                n2 = n++;
                bPLDict2 = bPLDict;
                this.convertObjectTableToXML(xMLElement2, bPLDict2.objectTable.get(bPLDict2.objref[n2]));
            }
        } else if (object instanceof BPLArray) {
            BPLArray bPLArray = (BPLArray)object;
            xMLElement2.setName("array");
            int n = 0;
            while (n < bPLArray.objref.length) {
                int n3 = n++;
                BPLArray bPLArray2 = bPLArray;
                this.convertObjectTableToXML(xMLElement2, bPLArray2.objectTable.get(bPLArray2.objref[n3]));
            }
        } else if (object instanceof String) {
            xMLElement2.setName("string");
            xMLElement2.setContent((String)object);
        } else if (object instanceof Integer) {
            xMLElement2.setName("integer");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Long) {
            xMLElement2.setName("integer");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Float) {
            xMLElement2.setName("real");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Double) {
            xMLElement2.setName("real");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Boolean) {
            xMLElement2.setName("boolean");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof byte[]) {
            xMLElement2.setName("data");
            xMLElement2.setContent(Base64.encodeBytes((byte[])object));
        } else if (object instanceof Date) {
            xMLElement2.setName("date");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            xMLElement2.setContent(simpleDateFormat.format((Date)object));
        } else {
            xMLElement2.setName("unsupported");
            xMLElement2.setContent(object.toString());
        }
        xMLElement.addChild(xMLElement2);
    }

    private void parseObjectTable(DataInputStream dataInputStream) throws IOException {
        int n;
        while ((n = dataInputStream.read()) != -1) {
            block0 : switch ((n & 0xF0) >> 4) {
                case 0: {
                    int n2 = n & 0xF;
                    BinaryPListParser binaryPListParser = this;
                    switch (n2) {
                        case 0: {
                            binaryPListParser.objectTable.add(null);
                            break block0;
                        }
                        case 8: {
                            binaryPListParser.objectTable.add(Boolean.FALSE);
                            break block0;
                        }
                        case 9: {
                            binaryPListParser.objectTable.add(Boolean.TRUE);
                            break block0;
                        }
                        case 15: {
                            break block0;
                        }
                    }
                    throw new IOException("parsePrimitive: illegal primitive " + Integer.toBinaryString(n2));
                }
                case 1: {
                    n = 1 << (n & 0xF);
                    this.parseInt(dataInputStream, n);
                    break;
                }
                case 2: {
                    int n3 = n = 1 << (n & 0xF);
                    DataInputStream dataInputStream2 = dataInputStream;
                    BinaryPListParser binaryPListParser = this;
                    switch (n3) {
                        case 4: {
                            binaryPListParser.objectTable.add(Float.valueOf(dataInputStream2.readFloat()));
                            break block0;
                        }
                        case 8: {
                            binaryPListParser.objectTable.add(dataInputStream2.readDouble());
                            break block0;
                        }
                    }
                    throw new IOException("parseReal: unsupported byte count:" + n3);
                }
                case 3: {
                    if ((n & 0xF) != 3) {
                        throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                    }
                    DataInputStream dataInputStream3 = dataInputStream;
                    BinaryPListParser binaryPListParser = this;
                    dataInputStream3.readDouble();
                    binaryPListParser.objectTable.add(new Date());
                    break;
                }
                case 4: {
                    if ((n &= 0xF) == 15) {
                        n = BinaryPListParser.readCount(dataInputStream);
                    }
                    int n4 = n;
                    DataInputStream dataInputStream4 = dataInputStream;
                    BinaryPListParser binaryPListParser = this;
                    byte[] byArray = new byte[n4];
                    dataInputStream4.readFully(byArray);
                    binaryPListParser.objectTable.add(byArray);
                    break;
                }
                case 5: {
                    if ((n &= 0xF) == 15) {
                        n = BinaryPListParser.readCount(dataInputStream);
                    }
                    int n5 = n;
                    Object object = dataInputStream;
                    BinaryPListParser binaryPListParser = this;
                    byte[] byArray = new byte[n5];
                    ((DataInputStream)object).readFully(byArray);
                    object = new String(byArray, "ASCII");
                    binaryPListParser.objectTable.add(object);
                    break;
                }
                case 6: {
                    if ((n &= 0xF) == 15) {
                        n = BinaryPListParser.readCount(dataInputStream);
                    }
                    this.parseUnicodeString(dataInputStream, n);
                    break;
                }
                case 7: {
                    System.out.println("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                    return;
                }
                case 8: {
                    n = (n & 0xF) + 1;
                    System.out.println("uid " + n);
                    break;
                }
                case 9: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 10: {
                    if ((n &= 0xF) == 15) {
                        n = BinaryPListParser.readCount(dataInputStream);
                    }
                    if (this.refCount > 255) {
                        this.parseShortArray(dataInputStream, n);
                        break;
                    }
                    this.parseByteArray(dataInputStream, n);
                    break;
                }
                case 11: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 12: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 13: {
                    if ((n &= 0xF) == 15) {
                        n = BinaryPListParser.readCount(dataInputStream);
                    }
                    if (this.refCount > 256) {
                        this.parseShortDict(dataInputStream, n);
                        break;
                    }
                    this.parseByteDict(dataInputStream, n);
                    break;
                }
                case 14: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 15: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
            }
        }
    }

    private static int readCount(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        if (n == -1) {
            throw new IOException("variableLengthInt: Illegal EOF in marker");
        }
        if ((n & 0xF0) >> 4 != 1) {
            throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(n));
        }
        n = 1 << (n & 0xF);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = dataInputStream.read();
            if (n3 == -1) {
                throw new IOException("variableLengthInt: Illegal EOF in value");
            }
            n2 = n2 << 8 | n3;
        }
        return n2;
    }

    private void parseByteArray(DataInputStream dataInputStream, int n) throws IOException {
        BPLArray bPLArray = new BPLArray();
        new BPLArray().objectTable = this.objectTable;
        bPLArray.objref = new int[n];
        for (int i = 0; i < n; ++i) {
            bPLArray.objref[i] = dataInputStream.readByte() & 0xFF;
            if (bPLArray.objref[i] != -1) continue;
            throw new IOException("parseByteArray: illegal EOF in objref*");
        }
        this.objectTable.add(bPLArray);
    }

    private void parseShortArray(DataInputStream dataInputStream, int n) throws IOException {
        BPLArray bPLArray = new BPLArray();
        new BPLArray().objectTable = this.objectTable;
        bPLArray.objref = new int[n];
        for (int i = 0; i < n; ++i) {
            bPLArray.objref[i] = dataInputStream.readShort() & 0xFFFF;
            if (bPLArray.objref[i] != -1) continue;
            throw new IOException("parseShortArray: illegal EOF in objref*");
        }
        this.objectTable.add(bPLArray);
    }

    private void parseByteDict(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        BPLDict bPLDict = new BPLDict();
        new BPLDict().objectTable = this.objectTable;
        bPLDict.keyref = new int[n];
        bPLDict.objref = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            bPLDict.keyref[n2] = dataInputStream.readByte() & 0xFF;
        }
        for (n2 = 0; n2 < n; ++n2) {
            bPLDict.objref[n2] = dataInputStream.readByte() & 0xFF;
        }
        this.objectTable.add(bPLDict);
    }

    private void parseShortDict(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        BPLDict bPLDict = new BPLDict();
        new BPLDict().objectTable = this.objectTable;
        bPLDict.keyref = new int[n];
        bPLDict.objref = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            bPLDict.keyref[n2] = dataInputStream.readShort() & 0xFFFF;
        }
        for (n2 = 0; n2 < n; ++n2) {
            bPLDict.objref[n2] = dataInputStream.readShort() & 0xFFFF;
        }
        this.objectTable.add(bPLDict);
    }

    private void parseInt(DataInputStream dataInputStream, int n) throws IOException {
        if (n > 8) {
            throw new IOException("parseInt: unsupported byte count:" + n);
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.read();
            if (n2 == -1) {
                throw new IOException("parseInt: Illegal EOF in value");
            }
            l = l << 8 | (long)n2;
        }
        this.objectTable.add(l);
    }

    private void parseUnicodeString(DataInputStream dataInputStream, int n) throws IOException {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        String string = new String(cArray);
        this.objectTable.add(string);
    }

    static final class BPLDict {
        ArrayList objectTable;
        int[] keyref;
        int[] objref;

        private BPLDict(byte by) {
        }

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer("BPLDict{");
            for (int i = 0; i < this.keyref.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                if (this.keyref[i] < 0 || this.keyref[i] >= this.objectTable.size()) {
                    stringBuffer.append("#" + this.keyref[i]);
                } else if (this.objectTable.get(this.keyref[i]) == this) {
                    stringBuffer.append("*" + this.keyref[i]);
                } else {
                    stringBuffer.append(this.objectTable.get(this.keyref[i]));
                }
                stringBuffer.append(":");
                if (this.objref[i] < 0 || this.objref[i] >= this.objectTable.size()) {
                    stringBuffer.append("#" + this.objref[i]);
                    continue;
                }
                if (this.objectTable.get(this.objref[i]) == this) {
                    stringBuffer.append("*" + this.objref[i]);
                    continue;
                }
                stringBuffer.append(this.objectTable.get(this.objref[i]));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }

        /* synthetic */ BPLDict() {
            this(0);
        }
    }

    static final class BPLArray {
        ArrayList objectTable;
        int[] objref;

        private BPLArray(byte by) {
        }

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer("Array{");
            for (int i = 0; i < this.objref.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                if (this.objectTable.size() > this.objref[i] && this.objectTable.get(this.objref[i]) != this) {
                    stringBuffer.append(this.objectTable.get(this.objref[i]));
                    continue;
                }
                stringBuffer.append("*" + this.objref[i]);
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }

        /* synthetic */ BPLArray() {
            this(0);
        }
    }
}

