/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.util.Globals;
import javax.jms.Message;

class MessageAckThread
implements Runnable {
    private Thread ackThread = null;
    private BrokerAdmin ba;
    private boolean msgReceived = false;
    private long timeout = 30000L;
    private boolean debug = BrokerAdmin.getDebug();
    private boolean stopRequested = false;

    public MessageAckThread(BrokerAdmin brokerAdmin) {
        if (this.debug) {
            Globals.stdOutPrintln("***** Created MessageAckThread");
        }
        this.ba = brokerAdmin;
    }

    public synchronized void start() {
        if (this.ackThread == null) {
            this.ackThread = new Thread((Runnable)this, "JMQ Administration MessageAckThread");
            this.ackThread.start();
            if (this.debug) {
                Globals.stdOutPrintln("***** Started MessageAckThread");
            }
        }
    }

    public synchronized void stop() {
        this.stopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Message message = null;
        this.ba.setBusy(true);
        while (!this.msgReceived) {
            try {
                MessageAckThread messageAckThread;
                message = this.ba.receiver.receive(this.timeout);
                if (message != null) {
                    if (this.debug) {
                        Globals.stdOutPrintln("***** MessageAckThread: received reply message !");
                    }
                    this.msgReceived = true;
                    if (this.debug) {
                        Globals.stdOutPrintln("***** MessageAckThread: acknowledging reply message.");
                    }
                    message.acknowledge();
                    messageAckThread = this;
                    synchronized (messageAckThread) {
                        this.ba.setBusy(false);
                        this.ba.sendStatusEvent(message, null);
                        continue;
                    }
                }
                messageAckThread = this;
                synchronized (messageAckThread) {
                    if (this.stopRequested) {
                        if (this.debug) {
                            Globals.stdOutPrintln("***** MessageAckThread: receive() timed out. Not retrying (stop requested).");
                        }
                        this.stopRequested = false;
                        this.ackThread = null;
                        return;
                    }
                }
                if (!this.debug) continue;
                Globals.stdOutPrintln("***** MessageAckThread: receive() timed out. Retrying...");
            }
            catch (Exception exception) {
                MessageAckThread messageAckThread = this;
                synchronized (messageAckThread) {
                    this.ba.setBusy(false);
                    this.ba.sendStatusEvent(null, exception);
                }
            }
        }
        this.ba.setBusy(false);
    }
}

