# subscription by config
from twisted.python import log
from twisted.internet import reactor
from twisted.internet.defer import Deferred
from twisted.web.client import getPage

class CustomFeed(object):
    def __init__(self, config, environ):
        self.config = config
        self.deferred = None
        
    def execute(self, content=None):
        url = self.config["url"]
        return getPage(url).addCallback(
            self.gotPage).addErrback(
            self.gotErr)

    def gotErr(self, failure):
        self.deferred.errback(failure)

    def gotPage(self, content):
        body = ""
        capture = self.config.get("capture", None)
        if capture:
            matched = re.findall(capture, content, re.MULTILINE)
            if matched:
                body = matched[0]
        else:
            body = content

        splitter = self.config.get("split", None)
        if splitter:
            items = [{"summary": s} for s in re.split(splitter, body) if s]
        else:
            items = [{"summary":body}]

        reTitle = self.config.get("title", "(.*)")
        for item in items:
            matched = re.findall(reTitle, item["summary"], re.MULTILINE)
            if matched:
                item["title"] = matched[0]
            else:
                item["title"] = item["summary"][:40]
        
        # TODO: find date

        reLink = self.config.get("link", "#")
        for item in items:
            item["link"] = reLink

        return dict(entries=item)


def create(config, environ):
    return CustomFeed(config, environ)
