
import email
import email.Header
import time

def date2struct_time(datestring):
    parsed_date = email.Utils.parsedate(datestring)
    return time.struct_time(parsed_date)



source = open("mail.txt").read()
message = email.message_from_string(source)

# header extraction
messageId = message.get("message-id").replace("<", "").replace(">", "")
published = message.get("date")
published_parsed = date2struct_time(published)

subj = email.Header.decode_header(message.get("subject"))
decodedSubj = []
for e in subj:
    encoding = "us-ascii"
    if e[1]:
        encoding = e[1]
    decodedSubj.append(unicode(e[0], encoding))
subject = u" ".join(decodedSubj)



body = u""
attachments = []
for part in message.walk():
    if part.get_content_maintype() == "multipart":
        continue
    partType = part.get_content_type()
    if not body and partType == "text/plain":
        body = part.get_payload(decode=True).decode(part.get_charsets()[0])
    elif partType.find("image") == 0:
        filename = part.get_filename()
        fileBody = part.get_payload(decode=True)
        info = dict(title = filename,
                    value = fileBody,
                    type = partType)
        attachments.append(info)

print messageId
print published
print subject.encode("utf-8")
print body.encode("utf-8")

for a in attachments:
    print a["title"]
