from twisted.python import log


class MoblogFormatter(object):
    def __init__(self, config, environ):
        self.config = config
        self.envrion = environ

    def _filter(self, body, attachments, secretKey):
        if len(body) > 3 and body[0] == secretKey and body[1] == "" \
               and len(attachments):
            return True
        log.msg("MoblogFormatter : filtered content")
        return False
    
    def execute(self, content):
        newEntries = []
        secretKey = self.config.setdefault("secretkey", "")
        for entry in content["entries"]:
            body = entry["summary"].splitlines()
            attachments = entry.setdefault("file", [])
            if self._filter(body, attachments, secretKey):
                body = "\n".join(body[2:])
                entry["summary"] = body
                entry["summary_detail"]["value"] = body
                newEntries.append(entry)
        content["entries"] = newEntries
        
        return content



def create(config, environ):
    return MoblogFormatter(config, environ)
