import habu.habuutils
import re
import filter


def makeFunc(expr):
    def evalExpr(entry):
        return eval(expr, {"entry": entry})
    
    return evalExpr


MAP_EXPR_FUNC = {
    "str": labmda expr: expr,
    "re": lambda expr: re.compile(expr, re.MILTILINE),
    "eval": makeFunc
    }

class Grep:
    def __init__(self, config, environ):
        condition = self.getCondition(config)
        exclusive = config.get("exclusive", False)
        self.filter = habu.habuutils.Filter(exclusive=exclusive, **condition)
    
    def getCondtion(self, config):
        condition = {}
        for exprKey, exprFunc in MAP_EXPR_FUNC.iteritems():
            for key, value in config.get(exprKey, {}).iteritems():
                condition[key] = exprFunc(value)

        return condition

    def execute(self, content):
        content["entries"] = [ entry for entry in 
                               self.filter.iterEntries(content) ]
        
        return content


def create(config, environ):
    return Grep(config, environ)
