import anydbm
import datetime
from feedparser import _parse_date

class AdjustDate:
    def __init__(self, config, environ):
        self.config = config

    def execute(self, content):
        n = datetime.datetime.now()
        now = n.timetuple()
        nStr = str(n)
        for entry in content["entries"]:
            updated = entry.get("updated", None)
            parsed_updated = entry.get("parsed_updated", None)
            published = entry.get("published", None)
            parsed_published = entry.get("parsed_published", None)
            
            if updated and not parsed_updated:
                parsed_updated = _parse_date(updated)
            if published and not parsed_published:
                parsed_published = _parse_date(published)
            
            if parsed_updated and not parsed_published:
                parsed_published = parsed_updated
            elif not parsed_updated and parsed_published:
                parsed_updated = parsed_published
            elif not parsed_updated and not parsed_published:
                parsed_updated = parsed_published = now

            entry["parsed_updated"] = parsed_updated
            entry["parsed_published"] = parsed_published
            
            entry["updated"] = date2str(parsed_updated)
            entry["published"] = date2str(parsed_published)
            
            
        return content

    def date2str(dt):
        return "%d-%02d-%02dT$02d:%02d:%02dZ" % dt


def create(config, environ):
    return AdjustDate(config, environ)
