#!/usr/bin/env python
# Python Antenna Organizer

import httplib
import urlparse
import sys
import rfc822
import time

class SiteInfo:
    def __init__(self):
        self.last_modified = None
        self.last_detected = None
        self.time_diff = None
        self.content_length = None
        self.url = None
        self.title = None
        self.author = None
        self.misc = None

# $Format: "version = $ProjectVersion$"$
version = 0.3

useragent  = "Pyano/%s"  % version

urls = []

table = []

for url in open('pyano.conf'):
    url = url.strip()
    host,path = urlparse.urlparse(url)[1:3]
    conn = httplib.HTTPConnection(host)
    conn.request("HEAD", path, '', {'User-Agent':  useragent})
    r = conn.getresponse()
    lm = r.getheader('Last-Modified')
    table.append((url,rfc822.mktime_tz(rfc822.parsedate_tz(lm))))


table.sort(lambda x,y : -cmp(x[1], y[1]))
for i in  table:
    # print time.localtime(i[1])
    print i[0], time.strftime("%Y-%m-%d %H:%M:%S %Z",time.localtime(i[1]))

