<?php
/**
 * RdbObject and its Manager
 * class for manupulating data stored in relational database server.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * @author Haruki Setoyama <haruki@planewave.org> 
 * @copyright Copyright &copy; 2003, Haruki SETOYAMA <haruki@planewave.org>
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @package rdbObject
 * @since 2003.06
 * @version 0.2 $Id: rdbobjectmanager.pgsql.php,v 1.1 2003/11/24 15:18:35 haruki Exp $
 * @link http://www.planewave.org/rdbobject/
 */
/**
 * rdbObjectManager_mysql
 * 
 * @access public 
 */
class rdbObjectManager_pgsql extends rdbObjectManager {
    function _query($sql)
    {
		if (isset($this->logger)) {
			$this->_log($sql); 
		} 
		return pg_query($this->_linkid, $sql);
    }

    function _query_error($sql = '')
    {
		$msg = '<b>Query error</b>: ';
		$msg .= pg_result_error($this->_linkid)."<br>\n";
		$msg .= $sql."<br>\n";
        return $this->raiseError($msg, RDBOBJECT_ERROR_INTERNAL);
    } 

    function _fetch($result)
    {
        return pg_fetch_array($result, NULL, PGSQL_ASSOC);
    }

    function _compose_limit_sql($condition)
    {
        $limit = '';
        if (isset($condition->limit)) {
            $limit .= ' LIMIT '.abs(intval($condition->limit));
        }
        if (isset($condition->start)) {
            $limit .= ' OFFSET '.abs(intval($condition->start));
        }
        return $limit;
    }

	function _compose_select_sql($select, $from, $condition, $order = true, $group =null)
	{
		$sql = 'SELECT '.$select.' FROM '.$from;
		if (isset($condition)) {
			$sql .= $condition->render();
			if (isset($group)) {
			    $sql .= ' GROUP BY '.$group;
			}
			$sql .= $this->_compose_limit_sql($condition);
		}
		return $sql;
	}

    function _gen_id()
    {
        $seq = $this->_table.'_'.$this->_pkey.'_seq';
        $sql = 'SELECT nextval(\''.$seq.'\')';
        $result = $this->_query($sql);
        if (! $result) {
            return $this->_create_generator();
        }
        $row = pg_fetch_row($result);
        if ($row === false) {
           return false;
        }
        return intval($row[0]);
    }

    function _create_generator()
    {
        $sql = 'SELECT COUNT(*) FROM '.$this->_table;
        $result = $this->_query($sql);
        if ($result === false) {
            $this->_query_error($sql);
            return false;
        }
        $row = pg_fetch_row($result);
        if ($row[0] == 0) {
            $num = 1;
        } else {
            $sql = 'SELECT MAX('.$this->_column_quoted[$this->_pkey].') FROM '.$this->_table;
            $result = $this->_query($sql);
            if ($result === false) {
                $this->_query_error($sql);
                return false;
            }
            $row = pg_fetch_row($result);
            $num = intval($row[0])+1;
        }

        $seq = $this->_table.'_'.$this->_pkey.'_seq';
        $sql = 'CREATE SEQUENCE '.$seq;
        $result = $this->_query($sql);
        if ($result === false) {
            $this->_query_error($sql);
            return false;
        }

        $sql = 'SELECT setval(\''.$seq.'\', '.$num.')';
        $result = $this->_query($sql);
        if ($result === false) {
            $this->_query_error($sql);
            return false;
        }
        return $num;
    }

    function _quote($value, $varname)
    {
        if ($value === null) {
            return 'NULL';
        } elseif (!($this->_type[$varname] & RDBOBJECT_ELEMENT_NUMERIC)) {
            return '\'' . pg_escape_string($value) . '\'';
        } elseif (!is_numeric($value)) {
            return '\'' . pg_escape_string($value) . '\'';
        }else {
            return $value;
        } 
    } 

    function _quote_column($column)
    {
        return $column;
    }
	
    function _quote_table($table)
	{
        return $table;
	}

    function _fetch_values($sql, $key = false)
    {
        $result = $this->_query($sql);
        if (! $result) {
            $this->_query_error($sql);
            return false;
        } 
        $vals = array();
        if ($key) {
            while ($ret = $this->_fetch($result)) {
                $vals[$ret['ky']] = $ret['vl'];
            }
        } else {
            while ($ret = $this->_fetch($result)) {
                $vals[] = $ret['vl'];
            }
        }
        return $vals;
    }

} 

?>