<?php
/**
 * RdbObject and its Manager
 * class for manupulating data stored in relational database server.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * @author Haruki Setoyama <haruki@planewave.org> 
 * @copyright Copyright &copy; 2003, Haruki SETOYAMA <haruki@planewave.org>
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @package rdbObject
 * @since 2003.06
 * @version 0.2 $Id: rdbobjectmanager.mysql.php,v 1.12 2003/11/24 07:24:22 haruki Exp $
 * @link http://www.planewave.org/rdbobject/
 */
/**
 * rdbObjectManager_mysql
 * 
 * @access public 
 */
class rdbObjectManager_mysql extends rdbObjectManager {
    function _query($sql)
    {
		if (isset($this->logger)) {
			$this->_log($sql); 
		} 
		return mysql_unbuffered_query($sql, $this->_linkid);
    } 

    function _query_error($sql = '')
    {
		$msg = '<b>Query error</b>: ';
		$msg .= '('.mysql_errno() . ') ' . mysql_error()."<br>\n";
		$msg .= $sql."<br>\n";
        return $this->raiseError($msg, RDBOBJECT_ERROR_INTERNAL);
    } 

    function _fetch($result)
    {
        return mysql_fetch_assoc($result);
    }

    function _compose_limit_sql($condition)
    {
        $limit = '';
        if (isset($condition->start)) {
            $limit .= abs(intval($condition->start)) . ', ';
        } 

        if (isset($condition->limit)) {
            $limit .= abs(intval($condition->limit));
        } elseif (isset($condition->start)) {
            $limit .= '-1';
        } 

        if ($limit != '') $limit = ' LIMIT ' . $limit;

        return $limit;
    }
	
	function _compose_select_sql($select, $from, $condition, $order = true, $group =null)
	{
		$sql = 'SELECT '.$select.' FROM '.$from;
		if (isset($condition)) {
			$sql .= $condition->render();
			if (isset($group)) {
			    $sql .= ' GROUP BY '.$group;
			}
			$sql .= $this->_compose_limit_sql($condition);
		}
		return $sql;
	}   

    function _insert(&$object)
    {
        $column4save = $this->_column;
        unset($column4save[$this->_pkey]);
        $varnames = array_keys($column4save);

        $fields = array();
        $data = array();
        foreach ($column4save as $varname => $column) {
            $fields[] = $this->_column_quoted[$varname];
            $data[] = $this->_quote($object->_dbRawData[$column], $varname);
        } 
        $sql = sprintf("INSERT INTO %s ( %s ) VALUES ( %s )" 
						, $this->_table
						, implode(', ', $fields)
						, implode(', ', $data));
        $result = $this->_query($sql);
        if (! $result) {
            $this->_query_error($sql);
			return false;
        } 
        $id = intval(mysql_insert_id($this->_linkid));
        if ($id <= 0) {
            $this->raiseError('Fail to insert' , RDBOBJECT_ERROR_INTERNAL);
			return false;
        } 

        $object->_dbRawData[$this->_pkey_column] = $id;
        $object->change = array();
        $this->_cache[$id] = &$object;
        return $id;
    } 

    function _quote($value, $varname)
    {
        if ($value === null) {
            return 'NULL';
        } elseif (!($this->_type[$varname] & RDBOBJECT_ELEMENT_NUMERIC)) {
            return '\'' . mysql_escape_string($value) . '\'';
        } elseif (!is_numeric($value)) {
            return '\'' . mysql_escape_string($value) . '\'';
        }else {
            return $value;
        } 
    } 

    function _quote_column($column)
    {
        return '`' . mysql_escape_string($column) . '`';
    } 
	
    function _quote_table($table) 
	{
        return '`' . mysql_escape_string($table) . '`';
	}

} 

?>