////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// sym.h
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#ifndef _sym_h_
#define _sym_h_

#include <stdint.h>

#define SYM_TBL_MAX	1024

struct sym_t {
	char*		name;
	uint32_t	term;
};

class sym {
    private:
	sym_t			m_table[SYM_TBL_MAX];
	uint32_t		m_entry;

    public:
	sym() {
		for(int i = 0; i < SYM_TBL_MAX; i++) {
			m_table[i].name = 0;
		}
	}

	~sym() {
		for(int i = 0; i < SYM_TBL_MAX; i++) {
			free(m_table[i].name);
		}
	}

	int		index_of(char* n);
	int		find(char* n);
	sym_t&		operator[] (uint32_t a) { return m_table[a]; }

    private:
	int		alloc(char* n);
};
	

#endif	// _sym_h_

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
