////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// seq.h
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#ifndef	_seq_h_
#define	_seq_h_

#include <systemc>
#include <iostream>
#include <iomanip>
#include "trans.h"
#include "io.h"
#include "asm2obj.h"

using namespace sc_core;

class seq : public sc_module {
    public:
	sc_in_clk		CLK;
	sc_out < bool >		RSTn;

    private:
	trans_m&		m_m;
	trans_s&		m_s;

	char*			m_term;

	obj			m_obj;

    public:
	SC_HAS_PROCESS(seq);
	seq(sc_module_name n, trans_m& m, trans_s& s, char* term) :
			sc_module(n), m_m(m), m_s(s), m_term(term) {
		SC_THREAD(process);
		sensitive << CLK.pos();
	}

    private:
	void process(void);

	uint32_t  sread(uint32_t a) {
		return m_s.read(a);
	}
};

#endif	// _seq_h_

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
