////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// lazy.cc
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#include <systemc>
#include <iostream>

#include "trans.h"
#include "io.h"
#include "seq.h"
#include "VPUZZLE_BOX.h"

using namespace sc_core;

int sc_main(int argc, char* argv[])
{
	if(argc != 2) {
		std :: cerr << "usage: lazy [program file name]" << std :: endl;
		exit(-1);
	}

	sc_clock 		CLK("clk", 20, SC_NS);
	sc_signal < bool >	RSTn;

	sc_signal < bool >	SREQ;
	sc_signal < bool >	SWRITE;
	sc_signal < uint32_t >	SA;
	sc_signal < uint32_t >	SWD;
	sc_signal < uint32_t >	SRD;

	sc_signal < bool >	MAREQ;
	sc_signal < bool >	MABSY;
	sc_signal < bool >	MAWRITE;
	sc_signal < uint32_t >	MAA;
	sc_signal < emd_t >	MAD;
	sc_signal < uint32_t >	MAS;

	sc_signal < bool >	MRREQ;
	sc_signal < bool >	MRBSY;
	sc_signal < emd_t >	MRD;

	sc_signal < bool >	ISREQ;
	sc_signal < bool >	ISBSY;
	sc_signal < bool >	ISLAST;
	sc_signal < uint32_t >	ISD;

	sc_signal < bool >	OSREQ;
	sc_signal < bool >	OSBSY;
	sc_signal < bool >	OSLAST;
	sc_signal < uint32_t >	OSD;

	// DUT
	VPUZZLE_BOX	vt("top");

	vt.CLK		(CLK);
	vt.RSTn		(RSTn);

	vt.SREQ		(SREQ);
	vt.SWRITE	(SWRITE);
	vt.SA		(SA);
	vt.SWD		(SWD);
	vt.SRD		(SRD);

	vt.MAREQ	(MAREQ);
	vt.MABSY	(MABSY);
	vt.MAWRITE	(MAWRITE);
	vt.MAA		(MAA);
	vt.MAD		(MAD);
	vt.MAS		(MAS);

	vt.MRREQ	(MRREQ);
	vt.MRBSY	(MRBSY);
	vt.MRD		(MRD);

	vt.ISREQ	(ISREQ);
	vt.ISBSY	(ISBSY);
	vt.ISLAST	(ISLAST);
	vt.ISD		(ISD);

	vt.OSREQ	(OSREQ);
	vt.OSBSY	(OSBSY);
	vt.OSLAST	(OSLAST);
	vt.OSD		(OSD);

	// Transactor (Slave)
	trans_s		ts("ts");

	ts.CLK		(CLK);

	ts.SREQ		(SREQ);
	ts.SWRITE	(SWRITE);
	ts.SA		(SA);
	ts.SWD		(SWD);
	ts.SRD		(SRD);

	// Transactor (External Memory)
	trans_m		tm("tm");

	tm.CLK		(CLK);

	tm.MAREQ	(MAREQ);
	tm.MABSY	(MABSY);
	tm.MAWRITE	(MAWRITE);
	tm.MAA		(MAA);
	tm.MAD		(MAD);
	tm.MAS		(MAS);

	tm.MRREQ	(MRREQ);
	tm.MRBSY	(MRBSY);
	tm.MRD		(MRD);

	// Transactor (Stream input)
	trans_is_fio	is("is", stdin);

	is.CLK		(CLK);

	is.ISREQ	(ISREQ);
	is.ISBSY	(ISBSY);
	is.ISLAST	(ISLAST);
	is.ISD		(ISD);

	// Transactor (Stream output)
	trans_os_fio	os("os", stdout);

	os.CLK		(CLK);

	os.OSREQ	(OSREQ);
	os.OSBSY	(OSBSY);
	os.OSLAST	(OSLAST);
	os.OSD		(OSD);

	// Sequencer
	seq	seq1("seq", tm, ts, argv[1]);

	seq1.CLK	(CLK);
	seq1.RSTn	(RSTn);

	// exec simulation
	sc_start();

	return 0;
}
