////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// io.h
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#ifndef _io_h_
#define _io_h_

#include <systemc>
#include <iostream>
#include "conf.h"

using namespace sc_core;

#ifdef PB_DS_BITS_16BIT
  typedef uint32_t	emd_t;
#else
  typedef uint64_t	emd_t;
#endif

class trans_is_fio : public sc_module {
    public:
	sc_in_clk			CLK;

	sc_in  < bool >			ISREQ;
	sc_out < bool >			ISBSY;
	sc_out < bool >			ISLAST;
	sc_out < uint32_t >		ISD;

    private:
	FILE*				m_fp;
	int				m_c;


    public:
	SC_HAS_PROCESS(trans_is_fio);
	trans_is_fio(sc_module_name n, FILE* fp) : sc_module(n), m_fp(fp), m_c(0) {
		SC_THREAD(proc);
		sensitive << CLK.pos();
	}

    private:
	void proc(void);
	int get_int(void);
};


class trans_os_fio : public sc_module {
    public:
	sc_in_clk			CLK;

	sc_in  < bool >			OSREQ;
	sc_out < bool >			OSBSY;
	sc_in  < bool >			OSLAST;
	sc_in  < uint32_t >		OSD;

    private:
	FILE*				m_fp;

    public:
	SC_HAS_PROCESS(trans_os_fio);
	trans_os_fio(sc_module_name n, FILE *fp) : sc_module(n), m_fp(fp) {
		SC_THREAD(proc);
		sensitive << CLK.pos();
	}

    private:
	void proc(void);
	void put_int(int d) { fprintf(m_fp, "%d ", d); }
};


#endif	// _io_h_
////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
