////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// tb.cc
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#include <systemc>
#include <iostream>

#include "trans.h"
#include "stim.h"
#include "VPUZZLE_BOX.h"

using namespace sc_core;

#ifdef VM_TRACE
#include <SpTraceVcdC.h>	// Trace file format header (from SystemPerl)

template < typename T >
class trace: public sc_module {
    private:
	T&			m_top;
	SpTraceVcdCFile*	m_tfp;
	uint32_t		m_time;

    public:
	SC_HAS_PROCESS(trace);
	trace(sc_module_name n, T& top): sc_module(n), m_top(top), m_time(0) {
		SC_THREAD(dump);
	}
	~trace() {
		m_tfp->close();
	}

    public:
	void end_of_elaboration(void) {
		sc_module :: end_of_elaboration();

		Verilated :: traceEverOn(true);
		m_tfp = new SpTraceVcdCFile;
		m_top.trace(m_tfp, 99);
		m_tfp->open("PUZZLE_BOX.vcd");
	}

    private:
	void dump(void) {
		for(;;) {
			wait(1, SC_NS);
			m_tfp->dump(m_time++);
		}
	}
};

#endif	// VM_TRACE


int sc_main(int argc, char* argv[])
{
	sc_clock 		CLK("clk", 20, SC_NS);
	sc_signal < bool >	RSTn;

	sc_signal < bool >	SREQ;
	sc_signal < bool >	SWRITE;
	sc_signal < uint32_t >	SA;
	sc_signal < uint32_t >	SWD;
	sc_signal < uint32_t >	SRD;

	sc_signal < bool >	MAREQ;
	sc_signal < bool >	MABSY;
	sc_signal < bool >	MAWRITE;
	sc_signal < uint32_t >	MAA;
	sc_signal < emd_t >	MAD;
	sc_signal < uint32_t >	MAS;

	sc_signal < bool >	MRREQ;
	sc_signal < bool >	MRBSY;
	sc_signal < emd_t >	MRD;

	sc_signal < bool >	ISREQ;
	sc_signal < bool >	ISBSY;
	sc_signal < bool >	ISLAST;
	sc_signal < uint32_t >	ISD;

	sc_signal < bool >	OSREQ;
	sc_signal < bool >	OSBSY;
	sc_signal < bool >	OSLAST;
	sc_signal < uint32_t >	OSD;

	// DUT
	VPUZZLE_BOX	vt("top");

	vt.CLK		(CLK);
	vt.RSTn		(RSTn);

	vt.SREQ		(SREQ);
	vt.SWRITE	(SWRITE);
	vt.SA		(SA);
	vt.SWD		(SWD);
	vt.SRD		(SRD);

	vt.MAREQ	(MAREQ);
	vt.MABSY	(MABSY);
	vt.MAWRITE	(MAWRITE);
	vt.MAA		(MAA);
	vt.MAD		(MAD);
	vt.MAS		(MAS);

	vt.MRREQ	(MRREQ);
	vt.MRBSY	(MRBSY);
	vt.MRD		(MRD);

	vt.ISREQ	(ISREQ);
	vt.ISBSY	(ISBSY);
	vt.ISLAST	(ISLAST);
	vt.ISD		(ISD);

	vt.OSREQ	(OSREQ);
	vt.OSBSY	(OSBSY);
	vt.OSLAST	(OSLAST);
	vt.OSD		(OSD);

	// Transactor (Slave)
	trans_s		ts("ts");

	ts.CLK		(CLK);

	ts.SREQ		(SREQ);
	ts.SWRITE	(SWRITE);
	ts.SA		(SA);
	ts.SWD		(SWD);
	ts.SRD		(SRD);

	// Transactor (External Memory)
	trans_m		tm("tm");

	tm.CLK		(CLK);

	tm.MAREQ	(MAREQ);
	tm.MABSY	(MABSY);
	tm.MAWRITE	(MAWRITE);
	tm.MAA		(MAA);
	tm.MAD		(MAD);
	tm.MAS		(MAS);

	tm.MRREQ	(MRREQ);
	tm.MRBSY	(MRBSY);
	tm.MRD		(MRD);

	// Transactor (Stream input)
	trans_is	is("is");

	is.CLK		(CLK);

	is.ISREQ	(ISREQ);
	is.ISBSY	(ISBSY);
	is.ISLAST	(ISLAST);
	is.ISD		(ISD);

	// Transactor (Stream output)
	trans_os	os("os");

	os.CLK		(CLK);

	os.OSREQ	(OSREQ);
	os.OSBSY	(OSBSY);
	os.OSLAST	(OSLAST);
	os.OSD		(OSD);

	// Stimulus
	stim	stim1("stim", tm, ts, is, os);

	stim1.CLK	(CLK);
	stim1.RSTn	(RSTn);

#ifdef VM_TRACE
	// trace on
	trace < VPUZZLE_BOX >	trace1("trace1", vt);
#endif

	// exec simulation
//	sc_start(300, SC_NS);
	sc_start();

	return 0;
}
