////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// stim.cc
// Copyright(C) 2009 OHSAWA Naotaka. All rights reserved.
//
// $Rev$
// $Date$
// $Author$

#include <stdint.h>
#include "conf.h"
#include "stim.h"

#define SYM_S		0x1ULL
#define SYM_K		(0x1ULL | 0x4)
#define SYM_I		(0x1ULL | 0x8)
#define SYM_L		(0x1ULL | 0xc)
#define SYM_N		(0x1ULL | 0x10)
#define MINT(X)		((X) << 2)
#define CONSA(X)	(((X) << 2 ) | 0x3ULL)

#ifdef PB_DS_BITS_16BIT
  #define CONS(X,Y)	(((X) << 16 ) | Y)
#else
  #define CONS(X,Y)	(((X) << 32 ) | Y)
#endif

void stim :: process(void)
{
	// execute asynchronus reset
	RSTn = true;
	wait(35, SC_NS);
	RSTn = false;
	wait(60, SC_NS);
	RSTn = true;
	wait();

	// stimulus
	
	// PUZZLE_BOX Slave check
	// 1. initial register values
	std :: cout << "1. checking Initial Register value...";
#ifdef DEBUG_VERBOSE
	std :: cout << std :: endl;
#endif

	sread(0, 0x0000000);
	sread(1, 0x0000000);
	sread(2, 0x0000003);
	sread(3, 0x0000000);
	sread(4, 0x0000000);
	sread(5, 0x0000000);
	sread(6, 0x0000000);

	std :: cout << " Done." << std :: endl;

	// 2. read/write check
	std :: cout << "2. checking register read/write via slave...";
#ifdef DEBUG_VERBOSE
	std :: cout << std :: endl;
#endif
	m_s.write(2, 0xfffffffc);
	if(sizeof(emd_t) == 8) {
		sread(2, 0xffffffff);
	} else {
		sread(2, 0x0000ffff);
	}

	m_s.write(4, 0xffffffff);
	sread(4, 0x000003ff);

	m_s.write(6, 0xffffffff);
	if(sizeof(emd_t) == 8) {
		sread(6, 0xffffffff);
	} else {
		sread(6, 0x0000ffff);
	}

	std :: cout << " Done." << std :: endl;

	// EXTERNAL MEMORY interface for testbench check
	std :: cout << "3. checking external memory read/write...";
#ifdef DEBUG_VERBOSE
	std :: cout << std :: endl;
#endif
	for(uint32_t i = 0; i < (1<<14); i++) {
		m_m[i] = 0xdead0000 | i;
	}
	for(uint32_t i = 0; i < (1<<14); i++) {
		mread(i, 0xdead0000 | i);
	}

	std :: cout << " Done." << std :: endl;
	
	// REDUCTION test
	std :: cout << "4. checking reduction core:" << std :: endl;

	// 1. car = S, K, I or machine integer
	exec_verify("I", "I");
	sread(2, (m_base << 2) + 3);	// FPSA

	exec_verify("K", "K");
	sread(2, (m_base << 2) + 3);	// FPSA

	exec_verify("S", "S");
	sread(2, (m_base << 2) + 3);	// FPSA

	std :: cout << "start reduction from 1 to 1 ...";
#ifdef DEBUG_VERBOSE
	std :: cout << std :: endl;
#endif
	m_s.write(6, MINT(1));		// 1
	m_s.write(2, 0);		// FPSA
	m_s.write(0, 0x3);		// INIT and START
	while(sread(0) != 0) {		// wait for end
		wait();
	}
	sread(1, MINT(1));
	sread(2, 3);			// FPSA
	sread(3, 0);			// ESNUM
	std :: cout << " Done." << std :: endl;
	
	// 2. (S K) -> (S K) (no reduction but car reg is updated)
	exec_verify("(SK)", "(SK)");
	sread(2, (m_base << 2) + 3);	// FPSA

	// 3. (I K) -> K (cons read and one reduction)
	exec_verify("(IK)", "K");
	sread(2, (m_base << 2) + 3);	// FPSA

	// 4. (K I) -> (K I) (no reduction but car reg is updated)
	exec_verify("(KI)", "(KI)");
	sread(2, (m_base << 2) + 3);	// FPSA

	// 5. (K S I) -> S (one reduction)
	exec_verify("((KS)I)", "S");
	sread(2, (m_base << 2) + 3);	// FPSA

	// 6. (S K K I) -> I (one reduction)
	exec_verify("(((SK)K)I)", "I");
	sread(2, (m_base << 2) + 7);	// FPSA

	// 7. (S K K (S K)) -> (S K) (one reduction)
	exec_verify("(((SK)K)(SK))", "(SK)");
	sread(2, (m_base << 2) + 7);	// FPSA

	// 8. (S K K (S (S K))) -> (S (S K)) (one reduction)
	exec_verify("(((SK)K)(S(SK)))", "(S(SK))");

	// 9. (S S K S K) -> (S K (K S K)) (two reductions)
	exec_verify("((((SS)K)S)K)", "((SK)((KS)K))");

	// 10. (1+ 0) -> 1 (many reductions)
	exec_verify("(((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))(KI)))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))((S(KK))I)))))((S((S(KS))((S(KK))(KK))))(KI))))))((S(KK))(KI))))(KI))", "((S(((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))(KI)))(KI)))(((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))((S(KK))I)))))((S((S(KS))((S(KK))(KK))))(KI))))))((S(KK))(KI)))(KI)))");

	// 11. (car (cons 0 1)) -> 0
	exec_verify("(((SI)((S((S(KS))((S(KK))(KK))))(KI)))((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))(KI))((S((S(KS))((S(KK))I)))(KI))))", "(KI)");

	// 12. (cdr (cons 0 1)) -> 1
	exec_verify("(((SI)((S(KK))(KI)))((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))(KI))((S((S(KS))((S(KK))I)))(KI))))", "((S((S(KS))((S(KK))I)))(KI))");

	// 13. (0 INC 0) -> 0 (machine integer)
	exec_verify("(((KI)N)Z)", (uint32_t)0);

	// 14. (1 INC 0) -> 1 (machine integer)
	exec_verify("((((S((S(KS))((S(KK))I)))(KI))N)Z)", 1);

	// 15. (1+ 0) -> 1 (machine integer)
	exec_verify("(((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))(KI)))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))((S(KK))I)))))((S((S(KS))((S(KK))(KK))))(KI))))))((S(KK))(KI))))(KI))N)Z)", 1);

	// 16. (* 8 2) -> 16 (machine integer)
	exec_verify("((((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))((S(KK))I)))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))(KI)))))((S(KK))(KI))))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))(KI))))))))))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))(KI))))N)Z)", (uint32_t)16);

	// 17. (cons 0 1) -> 0  (car and machine integer)
	exec_verify_lazyk_1("((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))(KI))((S((S(KS))((S(KK))I)))(KI)))", 0);

	// 18. (cons 1 2) -> 1  (car and machine integer)
	exec_verify_lazyk_1("((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))((S((S(KS))((S(KK))I)))(KI)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))(KI))))", 1);

	// 19. (cons 1 (cons 2 (cons 3 (cons 4 5)))) -> 1, 2, 3, 4
	exec_verify_lazyk_1("((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))((S((S(KS))((S(KK))I)))(KI)))((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))(KI))))((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))(KI)))))((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))(KI))))))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))((S((S(KS))((S(KK))I)))(KI))))))))))", 1);
	exec_verify_lazyk_1_cont(2);
	exec_verify_lazyk_1_cont(3);
	exec_verify_lazyk_1_cont(4);

	// 20. (cons 1 2) -> 1  (car and machine integer) using builtin reference to church number
	exec_verify("((((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))((S(KK))I)))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S(KK))(KK))))(KI)))))((S(KK))(KI))))3)4)N)Z)", 12);

	// 21. (cons 1 (cons 2 (cons 3 (cons 4 5)))) -> 1, 2, 3, 4 using builtin reference to church number
	exec_verify_lazyk_1("((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))1)((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))2)((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))3)((((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))4)5))))", 1);
	exec_verify_lazyk_1_cont(2);
	exec_verify_lazyk_1_cont(3);
	exec_verify_lazyk_1_cont(4);

	// 22. LazyRead -> input
	for(int i = 0; i < 4; i++) {
		m_is.write(i);
	}
	exec_verify_lazyk_1("(IL)", 0);
	exec_verify_lazyk_1_cont(1);
	exec_verify_lazyk_1_cont(2);
	exec_verify_lazyk_1_cont(3);

	// 23. (cdr (cdr LazyRead))
	for(int i = 0; i < 8; i++) {
		m_is.write(i);
	}
	exec_verify_lazyk_1("(((SI)((S(KK))(KI)))(((SI)((S(KK))(KI)))(IL)))",2);
	exec_verify_lazyk_1_cont(3);
	exec_verify_lazyk_1_cont(4);
	exec_verify_lazyk_1_cont(5);
	exec_verify_lazyk_1_cont(6);
	exec_verify_lazyk_1_cont(7);

	// 24. (cdr (cdr LazyRead))
	uint32_t	d[256];
	for(int i = 0; i < 8; i++) {
		m_is.write(i);
	}
	for(int i = 0; i < 6; i++) {
		d[i] = i + 2;
	}
	exec_verify_lazyk("(((SI)((S(KK))(KI)))(((SI)((S(KK))(KI)))(IL)))", d, 6);

	wait(100, SC_NS);
	sc_stop();
}

void stim :: exec_verify(char* s, char* d)
{
	std :: cout << std :: endl << "REDUCTION term is: " << s << std :: endl;
	if(d) {
		std :: cout << "start reduction to " << d << " ...";
	} else {
		std :: cout << "start reduction ...";
	}
#ifdef DEBUG_VERBOSE
	std :: cout << std :: endl;
#endif
	parse_and_setup_memory(s);
	m_s.write(0, 0x1);			// START
	while((sread(0) & 0x1) != 0) {		// wait for end
		wait();
	}
	sread(0, 0);				// no error

#ifdef DEBUG
	if(d) {
		parse_and_verify_stack_memory(d);
	}
#endif

	std :: cout << " Done." << std :: endl;
#ifdef DEBUG_VERBOSE
	std :: cout << "\tSTACK LEN: " << m_s.read(3) << ", MAX ALLOC: " << (m_s.read(2) >> 2) << "." << std :: endl;
#endif
}

void stim :: exec_verify(char* s, uint32_t d)
{
	std :: cout << std :: endl << "REDUCTION term is: " << s << std :: endl;
	std :: cout << "start reduction to " << d << " (machine integer) ...";
#ifdef DEBUG_VERBOSE
	std :: cout << std :: endl;
#endif
	parse_and_setup_memory(s);
	m_s.write(0, 0x1);			// START
	while((sread(0) & 0x1) != 0) {		// wait for end
		wait();
	}
	sread(0, 0);				// no error

#ifdef DEBUG
	sread(1, MINT(d));			// CAR: result
	sread(3, 0);				// stack len: 0
#endif

	std :: cout << " Done." << std :: endl;
#ifdef DEBUG_VERBOSE
	std :: cout << "\tSTACK LEN: " << m_s.read(3) << ", MAX ALLOC: " << (m_s.read(2) >> 2) << "." << std :: endl;
#endif
}

void stim :: exec_verify_lazyk(char* s, uint32_t* d, size_t num)
{
	std :: cout << std :: endl << "REDUCTION term is: " << s << std :: endl;
	parse_and_setup_memory(s);

	std :: cout << "start reduction using lazyk (continuous execution)...";
#ifdef DEBUG_VERBOSE
	std :: cout << std :: endl;
#endif
	m_s.write(0, 0xd);			// START
	for(unsigned i = 0; i < num; i++) {
		osread(d[i]);			// read integer
	std :: cout << " " << d[i];
	}
	osread(256);				// EOS
	std :: cout << " EOF.";

	while((sread(0) & 0x1) != 0) {		// wait for end
		wait();
	}
	sread(0, 0);				// no error

#ifdef DEBUG
	sread(3, 0);				// stack len: 0
#endif

	std :: cout << " Done." << std :: endl;
#ifdef DEBUG_VERBOSE
	std :: cout << "\tSTACK LEN: " << m_s.read(3) << ", MAX ALLOC: " << (m_s.read(2) >> 2) << "." << std :: endl;
#endif
}

void stim :: exec_verify_lazyk_1(char* s, uint32_t d)
{
	std :: cout << std :: endl << "REDUCTION term is: " << s << std :: endl;
	parse_and_setup_memory(s);
	exec_verify_lazyk_1_cont(d);
}

void stim :: exec_verify_lazyk_1_cont(uint32_t d)
{
	std :: cout << "start reduction to " << d << " (machine integer) using lazyk (one output term)...";
#ifdef DEBUG_VERBOSE
	std :: cout << std :: endl;
#endif
	m_s.write(0, 0x5);			// START
	osread(d);				// read integer
	while((sread(0) & 0x1) != 0) {		// wait for end
		wait();
	}
	sread(0, 0);				// no error

#ifdef DEBUG
	sread(3, 0);				// stack len: 0
#endif

	std :: cout << " Done." << std :: endl;
#ifdef DEBUG_VERBOSE
	std :: cout << "\tSTACK LEN: " << m_s.read(3) << ", MAX ALLOC: " << (m_s.read(2) >> 2) << "." << std :: endl;
#endif
}

void stim :: parse_and_setup_memory(char* s)
{
	// setup builtin function: cons
	m_base = 257;
	char *fun = "((S((S(KS))((S((S(KS))((S(KK))(KS))))((S((S(KS))((S((S(KS))((S(KK))(KS))))((S(KK))(KI)))))((S((S(KS))((S(KK))(KK))))((S(KK))I))))))((S((S(KS))((S(KK))(KK))))(KI)))";

	parse(&fun);

	// setup builtin church number
	m_m[0] = CONS(SYM_K, SYM_I);		// (KI) for cdr and 0 in LazyK
	m_m[1] = CONS(SYM_I, SYM_I);		// I for 1 in LazyK
	for(int i = 2; i < 257; i++) {
		m_m[i] = CONS(CONSA(m_base), CONSA(i-1));
	}

	// setup builtin function: inc
	fun = "(S((S(KS))((S(KK))I)))";
	parse(&fun);

	m_s.write(0, 0x2);			// INIT
	m_s.write(6, parse(&s));		// CDR
	m_s.write(2, m_base << 2);		// FP
#ifdef DEBUG_VERBOSE
	std :: cout << "\tCODE ALLOC: " << (m_s.read(2) >> 2) << "." << std :: endl;
#endif

	return ;
}

uint32_t stim :: parse(char** s)
{
	uint32_t	ptr;

	// skip space
	for(;**s == ' '; (*s)++) ;

	if(**s == '(' ) {
		if(m_base > (1<<PB_MEM_MAX_BITS)) {
			std :: cerr << "error: out of memory." << std :: endl;
			abort();
		}
		ptr = CONSA(m_base);
		m_base++;
		(*s)++;

		emd_t d = CONS((emd_t)parse(s), parse(s));
//		printf("%08x: %08x\n", ptr >> 2, d);
		m_m[ptr>>2] = d;

		// skip space
		for(;**s == ' '; (*s)++) ;
		if(**s != ')') {
			fprintf(stderr, "parse error: expected ')'.\n");
			exit(-1);
		}
	} else {
		if(**s == 'S') {
			ptr = SYM_S;
		} else if(**s == 'K') {
			ptr = SYM_K;
		} else if(**s == 'I') {
			ptr = SYM_I;
		} else if(**s == 'L') {
			ptr = SYM_L;
		} else if(**s == 'N') {
			ptr = SYM_N;
		} else if(**s == 'Z') {
			ptr = MINT(0);
		} else {
			char* upd;
			int n = strtol(*s, &upd, 10);
			if(*s == upd) {
				fprintf(stderr, "parse error: expected symbol or integer.\n");
				exit(-1);
			} else {
				if(n > 256) {
					fprintf(stderr, "parse error: integer must be less than 257.\n");
					exit(-1);
				}
				ptr = CONSA(n);
				*s = upd - 1;
			}
		}
	}

	(*s)++;

	return ptr;
}

void stim :: parse_and_verify_stack_memory(char* s)
{
	// go to the end of string
	for(;*s != '\0'; s++) ;
	s--;
	parse_and_verify_stack(&s, 0);

	return ;
}

void stim :: parse_and_verify_stack(char** s, uint32_t base)
{
	// skip space
	for(;**s == ' '; (*s)--) ;

	if(**s == ')' ) {
		(*s)--;

		// skip space
		for(;**s == ' '; (*s)--) ;

		m_s.write(4, base);
		if(**s == ')') {
			uint32_t d = m_s.read(5);
			if(d & 0x3 != 0x3) {
				fprintf(stderr, "error: expected cons.\n");
				wait(100, SC_NS);
				sc_stop();
			}

			parse_and_verify_memory(s, d);
		} else {
			if(**s == 'S') {
				sread(5, SYM_S);
			} else if(**s == 'K') {
				sread(5, SYM_K);
			} else if(**s == 'I') {
				sread(5, SYM_I);
			} else {
				fprintf(stderr, "parse error: expected symbol.\n");
				exit(-1);
			}
			(*s)--;
		}
		parse_and_verify_stack(s, base + 1);

		// skip space
		for(;**s == ' '; (*s)--) ;
		if(**s != '(') {
			fprintf(stderr, "parse error: expected '('.\n");
			exit(-1);
		}
	} else {
		sread(3, base);			// ESNUM
		if(**s == 'S') {
			sread(1, SYM_S);
		} else if(**s == 'K') {
			sread(1, SYM_K);
		} else if(**s == 'I') {
			sread(1, SYM_I);
		} else {
			fprintf(stderr, "parse error: expected symbol.\n");
			exit(-1);
		}
	}

	(*s)--;

	return ;
}

void stim :: parse_and_verify_memory(char** s, uint32_t base)
{
	// skip space
	for(;**s == ' '; (*s)--) ;

	if(**s == ')' ) {
		(*s)--;
		if(base & 0x3 != 0x3) {
			fprintf(stderr, "error: expected cons.\n");
			wait(100, SC_NS);
			sc_stop();
		}

		emd_t d = m_m[base >> 2];
#ifdef PB_DS_BITS_16BIT
		parse_and_verify_memory(s, d & 0xffff);
		parse_and_verify_memory(s, d >> 16);
#else
		parse_and_verify_memory(s, d & 0xffffffff);
		parse_and_verify_memory(s, d >> 32);
#endif

		// skip space
		for(;**s == ' '; (*s)--) ;
		if(**s != '(') {
			fprintf(stderr, "parse error: expected '('.\n");
			exit(-1);
		}
	} else {
		uint32_t sym;
		if(**s == 'S') {
			sym = SYM_S;
		} else if(**s == 'K') {
			sym = SYM_K;
		} else if(**s == 'I') {
			sym = SYM_I;
		} else {
			fprintf(stderr, "parse error: expected symbol.\n");
			exit(-1);
		}
		if(base != sym) {
			fprintf(stderr, "error: symbol %08x, expected %08x.\n", base, sym);
			wait(100, SC_NS);
			sc_stop();
		} else {
#ifdef DEBUG_VERBOSE
			std :: cout << sc_time_stamp() << " stim: parse_and_verify_memory: read symbol match for data " << std :: hex << base << "." << std :: endl;
#endif
		}
	}

	(*s)--;

	return ;
}

////////////////////////////////////////////////////////////////////////////////
// END OF IMPLEMENTATION
////////////////////////////////////////////////////////////////////////////////
