;
; lazyc.l
; Compiler from lambda calculus to SKI combinator format suitable for
; PuzzleBox linker
;


(defvar *obj*)

(setf *obj* nil)

(defmacro defzfun (name arg e)
  `(format *obj* "~(~A~) ~A~%" ',name
	   (with-caf-form
	    (compile-to-ski '(lambda ,arg ,e)))))

(defun print-symbol (x)
  (if (consp x) x
    (if (or (eq x 'S)
	    (eq x 'K)
	    (eq x 'I)) x
      (format nil "~(~A~)" x))))

(defun with-caf-form (e)
  (labels ((rec (x)
	     (if (atom x) x
	       (format nil "(~A ~A)"
		       (rec (print-symbol (car x)))
		       (rec (print-symbol (cdr x)))))))
    (rec (curry e))))

; compile function from lambda calculus to SKI combinator
(defun compile-to-ski (e)
  (uncurry
   (compile-to-ski-curry
    (curry e))))

(defun compile-to-ski-curry (e)
  (cond ((is-id e) e)
	((is-application e)
	 (create-application
	  (compile-to-ski-curry (get-function e))
	  (compile-to-ski-curry (get-argument e))))
	(t (abstract (get-id e) (get-body e)))))

(defun abstract (x e)
  (cond ((is-id e)
	 (if (eq x e) 'I (create-application 'K e)))
	((is-function e) (abstract x (compile-to-ski-curry e)))
	(t (create-application
	    (create-application 'S (abstract x (get-function e)))
	    (abstract x (get-argument e))))))

(defun is-id (x)
  (atom x))

(defun is-function (x)
  (and (consp x) (eq 'lambda (car x))))

(defun is-application (x)
  (and (consp x) (not (is-function x))))

(defun create-function (id body)
  `(lambda (,id) ,body))

(defun create-application (x y)
  (cons x y))

(defun get-id (x)
  (caadr x))

(defun get-body (x)
  (caddr x))

(defun get-function (x)
  (car x))

(defun get-argument (x)
  (cdr x))

; currying & uncurrying functions
(defun curry (list)
  (labels ((rec (acc list)
	     (if (null list) acc
	       (rec (cons acc (curry (car list))) (cdr list))))
	   (rec-lambda (arg body)
	     (if (null arg) body
	       `(lambda (,(car arg)) ,(rec-lambda (cdr arg) body)))))
    (cond ((atom list) list)
	  ((eq 'lambda (car list)) (rec-lambda (cadr list) (curry (caddr list))))
	  (t (rec (curry (car list)) (cdr list))))))

(defun uncurry (list)
  (labels ((rec (acc list)
	     (if (or (atom list) (eq (car list) 'lambda)) (cons (uncurry list) acc)
	       (rec (cons (uncurry (cdr list)) acc) (car list))))
	   (rec-lambda (acc body)
	     (if (and (consp body) (eq 'lambda (car body))) (rec-lambda (append acc (cadr body)) (caddr body))
	       `(lambda ,acc ,(uncurry body)))))
    (cond ((atom list) list)
	  ((eq 'lambda (car list)) (rec-lambda (cadr list) (caddr list)))
	  (t (rec nil list)))))

