
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/pci.h>
#include <linux/init.h>
#include <linux/interrupt.h>

#include <asm/system.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>

#include	"pt1_com.h"
#include	"pt1_pci.h"
#include	"pt1_i2c.h"
#include	"pt1_tuner.h"
#include	"pt1_tuner_data.h"
/***************************************************************************/
/* BSͥơ֥                                                      */
/***************************************************************************/
ISDB_S_CH_TABLE		isdb_t_table[11] ={
	{151, 0, 0},			// 151chBSī
	{161, 0, 1},			// 161chBS-i
	{171, 1, 1},			// 171chBSѥ
	{211, 4, 0},			// 211chBS11ǥ
	{222, 4, 2},			// 222chTwellV
	{141, 6, 0},			// 141chBSƥ
	{181, 6, 1},			// 181chBSե
	{101, 7, 0},			// 101chNHK1(BS1)
	{101, 7, 0},			// 102chNHK2(BS2)
	{103, 7, 1},			// 103chNHKϥӥ(BShi)
	{0, 0, 0}				// 
};

/***************************************************************************/
/* ϥơ֥                                                          */
/***************************************************************************/
/*
ISDB-Sξ
                       C0 C1
:7Bit Address Mode(1b/19):17:00
ISDB-Sξ̵(ޥ)
                       C0 C1
:7Bit Address Mode(1B/19):fe:c0:f0:04
:7Bit Address Mode(1B/19):17:01
*/
WBLOCK	isdb_s_wake = {
	0,
	4,
	{0xFE, 0xC0, 0xF0, 0x04}
};
WBLOCK	isdb_s_sleep = {
	0,
	2,
	{0x17, 0x00}
};
/*
ISDB-Tξ
                       C0 C1
:7Bit Address Mode(1A/18):03:80

ISDB-Tξ̵(ޥ)
                       C0 C1
:7Bit Address Mode(1A/18):fe:c2
:7Bit Address Mode(1A/18):03:90
*/

WBLOCK	isdb_t_wake = {
	0,
	2,
	{0xFE, 0xC2}
};
WBLOCK	isdb_t_sleep = {
	0,
	2,
	{0x03, 0x80}
};

/***************************************************************************/
/* ǡ()                                                  */
/***************************************************************************/
WBLOCK	com_initdata = {
	0,
	2,
	{0x01, 0x80}
};

/***************************************************************************/
/* ǡ(ISDB-S)                                                */
/***************************************************************************/
// ISDB-Sͣ
WBLOCK	isdb_s_init1 ={
	0,
	1,
	{0x07}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init2 ={
	0,
	2,
	{0x04, 0x02}
};

// ISDB-Sͣ
WBLOCK	isdb_s_init3 ={
	0,
	2,
	{0x0D, 0x55}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init4 ={
	0,
	2,
	{0x11, 0x40}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init5 ={
	0,
	2,
	{0x13, 0x80}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init6 ={
	0,
	2,
	{0x17, 0x01}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init7 ={
	0,
	2,
	{0x1C, 0x0A}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init8 ={
	0,
	2,
	{0x1D, 0xAA}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init9 ={
	0,
	2,
	{0x1E, 0x20}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init10 ={
	0,
	2,
	{0x1F, 0x88}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init11 ={
	0,
	2,
	{0x51, 0xB0}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init12 ={
	0,
	2,
	{0x52, 0x89}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init13 ={
	0,
	2,
	{0x53, 0xB3}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init14 ={
	0,
	2,
	{0x5A, 0x2D}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init15 ={
	0,
	2,
	{0x5B, 0xD3}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init16 ={
	0,
	2,
	{0x85, 0x69}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init17 ={
	0,
	2,
	{0x87, 0x04}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init18 ={
	0,
	2,
	{0x8E, 0x02}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init19 ={
	0,
	2,
	{0xA3, 0xF7}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init20 ={
	0,
	2,
	{0xA5, 0xC0}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init21 ={
	0,
	4,
	{0xFE, 0xC0, 0xF0, 0x04}
};
/***************************************************************************/
/* ǡ(ISDB-T)                                                */
/***************************************************************************/
// ISDB-Tͣ
WBLOCK	isdb_t_init1 ={
	0,
	2,
	{0x03, 0x90}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init2 ={
	0,
	2,
	{0x14, 0x8F}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init3 ={
	0,
	2,
	{0x1C, 0x2A}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init4 ={
	0,
	2,
	{0x1D, 0xA8}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init5 ={
	0,
	2,
	{0x1E, 0xA2}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init6 ={
	0,
	2,
	{0x22, 0x83}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init7 ={
	0,
	2,
	{0x31, 0x0D}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init8 ={
	0,
	2,
	{0x32, 0xE0}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init9 ={
	0,
	2,
	{0x39, 0xD3}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init10 ={
	0,
	2,
	{0x3A, 0x00}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init11 ={
	0,
	2,
	{0x5C, 0x40}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init12 ={
	0,
	2,
	{0x5F, 0x80}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init13 ={
	0,
	2,
	{0x75, 0x02}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init14 ={
	0,
	2,
	{0x76, 0x4E}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init15 ={
	0,
	2,
	{0x77, 0x03}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init16 ={
	0,
	2,
	{0xEF, 0x01}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init17 ={
	0,
	7,
	{0xFE, 0xC2, 0x01, 0x8F, 0xC1, 0x80, 0x80}
};

/***************************************************************************/
/* ǡ֥å(ISDB-S)                                        */
/***************************************************************************/
WBLOCK	*isdb_s_initial[MAX_ISDB_S_INIT] =
{
	&isdb_s_init2, &isdb_s_init3, &isdb_s_init4, &isdb_s_init5,
	&isdb_s_init6, &isdb_s_init7, &isdb_s_init8, &isdb_s_init9,
	&isdb_s_init10, &isdb_s_init11, &isdb_s_init12, &isdb_s_init13,
	&isdb_s_init14, &isdb_s_init15, &isdb_s_init16, &isdb_s_init17,
	&isdb_s_init18, &isdb_s_init19, &isdb_s_init20
};
/***************************************************************************/
/* ǡ֥å(ISDB-T)                                        */
/***************************************************************************/
WBLOCK	*isdb_t_initial[MAX_ISDB_T_INIT] =
{
	&isdb_t_init1, &isdb_t_init2, &isdb_t_init3, &isdb_t_init4,
	&isdb_t_init5, &isdb_t_init6, &isdb_t_init7, &isdb_t_init8,
	&isdb_t_init9, &isdb_t_init10, &isdb_t_init11, &isdb_t_init12,
	&isdb_t_init13, &isdb_t_init14, &isdb_t_init15, &isdb_t_init16
};
/***************************************************************************/
/* Ͼǥѥǡ                                                    */
/***************************************************************************/
/***************************************************************************/
/* ȿơ֥                                                      */
/* £Ӥ˴ؤƤΤߡȤꤢơ֥Ȥ׻ǻнʤ      */
/* ׻ǻФ롣                                                      */
/***************************************************************************/
WBLOCK isdb_t_pll_000 = {
	0,
	6,
	{0xFE, 0xC2, 0x04, 0x1B, 0x80, 0x81}
};
WBLOCK isdb_t_pll_001 = {
	0,
	6,
	{0xFE, 0xC2, 0x04, 0x45, 0x80, 0x81}
};
WBLOCK isdb_t_pll_002 = {
	0,
	6,
	{0xFE, 0xC2, 0x04, 0x6F, 0x80, 0x81}
};
WBLOCK isdb_t_pll_003 = {
	0,
	6,
	{0xFE, 0xC2, 0x04, 0x99, 0x80, 0x81}
};
WBLOCK isdb_t_pll_004 = {
	0,
	6,
	{0xFE, 0xC2, 0x04, 0xC3, 0x80, 0x81}
};
WBLOCK isdb_t_pll_005 = {
	0,
	6,
	{0xFE, 0xC2, 0x04, 0xED, 0x80, 0x81}
};
WBLOCK isdb_t_pll_006 = {
	0,
	6,
	{0xFE, 0xC2, 0x05, 0x17, 0x80, 0x81}
};
WBLOCK isdb_t_pll_007 = {
	0,
	6,
	{0xFE, 0xC2, 0x05, 0x41, 0x80, 0x81}
};
WBLOCK isdb_t_pll_008 = {
	0,
	6,
	{0xFE, 0xC2, 0x05, 0x6B, 0x80, 0xA1}
};
WBLOCK isdb_t_pll_009 = {
	0,
	6,
	{0xFE, 0xC2, 0x05, 0x95, 0x80, 0xA1}
};
WBLOCK isdb_t_pll_010 = {
	0,
	6,
	{0xFE, 0xC2, 0x05, 0xBF, 0x80, 0xA1}
};
WBLOCK isdb_t_pll_011 = {
	0,
	6,
	{0xFE, 0xC2, 0x05, 0xE9, 0x80, 0xA1}
};
WBLOCK isdb_t_pll_012 = {
	0,
	6,
	{0xFE, 0xC2, 0x06, 0x21, 0x80, 0xA1}
};
WBLOCK isdb_t_pll_013 = {
	0,
	6,
	{0xFE, 0xC2, 0x06, 0x4B, 0x80, 0x62}
};
WBLOCK isdb_t_pll_014 = {
	0,
	6,
	{0xFE, 0xC2, 0x06, 0x75, 0x80, 0x62}
};
WBLOCK isdb_t_pll_015 = {
	0,
	6,
	{0xFE, 0xC2, 0x06, 0x9F, 0x80, 0x62}
};
WBLOCK isdb_t_pll_016 = {
	0,
	6,
	{0xFE, 0xC2, 0x06, 0xC9, 0x80, 0x62}
};
WBLOCK isdb_t_pll_017 = {
	0,
	6,
	{0xFE, 0xC2, 0x06, 0xE5, 0x80, 0x62}
};
WBLOCK isdb_t_pll_018 = {
	0,
	6,
	{0xFE, 0xC2, 0x07, 0x0F, 0x80, 0x62}
};
WBLOCK isdb_t_pll_019 = {
	0,
	6,
	{0xFE, 0xC2, 0x07, 0x39, 0x80, 0x62}
};
WBLOCK isdb_t_pll_020 = {
	0,
	6,
	{0xFE, 0xC2, 0x07, 0x63, 0x80, 0x62}
};
WBLOCK isdb_t_pll_021 = {
	0,
	6,
	{0xFE, 0xC2, 0x07, 0x8d, 0x80, 0x62}
};
WBLOCK isdb_t_pll_022 = {
	0,
	6,
	{0xFE, 0xC2, 0x07, 0xB7, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_023 = {
	0,
	6,
	{0xFE, 0xC2, 0x07, 0xE1, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_024 = {
	0,
	6,
	{0xFE, 0xC2, 0x08, 0x0B, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_025 = {
	0,
	6,
	{0xFE, 0xC2, 0x08, 0x35, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_026 = {
	0,
	6,
	{0xFE, 0xC2, 0x08, 0x5F, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_027 = {
	0,
	6,
	{0xFE, 0xC2, 0x08, 0x89, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_028 = {
	0,
	6,
	{0xFE, 0xC2, 0x08, 0xB3, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_029 = {
	0,
	6,
	{0xFE, 0xC2, 0x08, 0xDD, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_030 = {
	0,
	6,
	{0xFE, 0xC2, 0x09, 0x07, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_031 = {
	0,
	6,
	{0xFE, 0xC2, 0x09, 0x31, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_032 = {
	0,
	6,
	{0xFE, 0xC2, 0x09, 0x5B, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_033 = {
	0,
	6,
	{0xFE, 0xC2, 0x09, 0x85, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_034 = {
	0,
	6,
	{0xFE, 0xC2, 0x09, 0xAF, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_035 = {
	0,
	6,
	{0xFE, 0xC2, 0x09, 0xD9, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_036 = {
	0,
	6,
	{0xFE, 0xC2, 0x0a, 0x03, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_037 = {
	0,
	6,
	{0xFE, 0xC2, 0x0A, 0x2D, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_038 = {
	0,
	6,
	{0xFE, 0xC2, 0x0A, 0x57, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_039 = {
	0,
	6,
	{0xFE, 0xC2, 0x0A, 0x81, 0x80, 0xA2}
};
WBLOCK isdb_t_pll_040 = {
	0,
	6,
	{0xFE, 0xC2, 0x0A, 0xAB, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_041 = {
	0,
	6,
	{0xFE, 0xC2, 0x0A, 0xD5, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_042 = {
	0,
	6,
	{0xFE, 0xC2, 0x0A, 0xFF, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_043 = {
	0,
	6,
	{0xFE, 0xC2, 0x0B, 0x29, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_044 = {
	0,
	6,
	{0xFE, 0xC2, 0x0B, 0x53, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_045 = {
	0,
	6,
	{0xFE, 0xC2, 0x0B, 0x7D, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_046 = {
	0,
	6,
	{0xFE, 0xC2, 0x0B, 0xA7, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_047 = {
	0,
	6,
	{0xFE, 0xC2, 0x0B, 0xD1, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_048 = {
	0,
	6,
	{0xFE, 0xC2, 0x0B, 0xFB, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_049 = {
	0,
	6,
	{0xFE, 0xC2, 0x0C, 0x25, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_050 = {
	0,
	6,
	{0xFE, 0xC2, 0x0C, 0x4F, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_051 = {
	0,
	6,
	{0xFE, 0xC2, 0x0C, 0x79, 0x80, 0xE2}
};
WBLOCK isdb_t_pll_052 = {
	0,
	6,
	{0xFE, 0xC2, 0x0C, 0xA3, 0x80, 0x64}
};
WBLOCK isdb_t_pll_053 = {
	0,
	6,
	{0xFE, 0xC2, 0x0C, 0xCD, 0x80, 0x64}
};
WBLOCK isdb_t_pll_054 = {
	0,
	6,
	{0xFE, 0xC2, 0x0C, 0xF7, 0x80, 0x64}
};
WBLOCK isdb_t_pll_055 = {
	0,
	6,
	{0xFE, 0xC2, 0x0D, 0x21, 0x80, 0x64}
};
WBLOCK isdb_t_pll_056 = {
	0,
	6,
	{0xFE, 0xC2, 0x0D, 0x4B, 0x80, 0x64}
};
WBLOCK isdb_t_pll_057 = {
	0,
	6,
	{0xFE, 0xC2, 0x0D, 0x75, 0x80, 0x64}
};
WBLOCK isdb_t_pll_058 = {
	0,
	6,
	{0xFE, 0xC2, 0x0D, 0x9F, 0x80, 0x64}
};
WBLOCK isdb_t_pll_059 = {
	0,
	6,
	{0xFE, 0xC2, 0x0D, 0xc9, 0x80, 0x64}
};
WBLOCK isdb_t_pll_060 = {
	0,
	6,
	{0xFE, 0xC2, 0x0D, 0xF3, 0x80, 0x84}
};
WBLOCK isdb_t_pll_061 = {
	0,
	6,
	{0xFE, 0xC2, 0x0E, 0x1D, 0x80, 0x84}
};
WBLOCK isdb_t_pll_062 = {
	0,
	6,
	{0xFE, 0xC2, 0x0E, 0x47, 0x80, 0x84}
};
WBLOCK isdb_t_pll_063 = {
	0,
	6,
	{0xFE, 0xC2, 0x0E, 0x7F, 0x80, 0x84}
};
WBLOCK isdb_t_pll_064 = {
	0,
	6,
	{0xFE, 0xC2, 0x0E, 0xA9, 0x80, 0x84}
};
WBLOCK isdb_t_pll_065 = {
	0,
	6,
	{0xFE, 0xC2, 0x0E, 0xD3, 0x80, 0x84}
};
WBLOCK isdb_t_pll_066 = {
	0,
	6,
	{0xFE, 0xC2, 0x0E, 0xFD, 0x80, 0x84}
};
WBLOCK isdb_t_pll_067 = {
	0,
	6,
	{0xFE, 0xC2, 0x0F, 0x27, 0x80, 0x84}
};
WBLOCK isdb_t_pll_068 = {
	0,
	6,
	{0xFE, 0xC2, 0x0F, 0x51, 0x80, 0x84}
};
WBLOCK isdb_t_pll_069 = {
	0,
	6,
	{0xFE, 0xC2, 0x0F, 0x7B, 0x80, 0x84}
};
WBLOCK isdb_t_pll_070 = {
	0,
	6,
	{0xFE, 0xC2, 0x0F, 0xA5, 0x80, 0x84}
};
WBLOCK isdb_t_pll_071 = {
	0,
	6,
	{0xFE, 0xC2, 0x0F, 0xCF, 0x80, 0x84}
};
WBLOCK isdb_t_pll_072 = {
	0,
	6,
	{0xFE, 0xC2, 0x0F, 0xF9, 0x80, 0x84}
};
WBLOCK isdb_t_pll_073 = {
	0,
	6,
	{0xFE, 0xC2, 0x10, 0x23, 0x80, 0x84}
};
WBLOCK isdb_t_pll_074 = {
	0,
	6,
	{0xFE, 0xC2, 0x10, 0x4D, 0x80, 0x84}
};
WBLOCK isdb_t_pll_075 = {
	0,
	6,
	{0xFE, 0xC2, 0x10, 0x77, 0x80, 0x84}
};
WBLOCK isdb_t_pll_076 = {
	0,
	6,
	{0xFE, 0xC2, 0x10, 0xA1, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_077 = {
	0,
	6,
	{0xFE, 0xC2, 0x10, 0xCB, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_078 = {
	0,
	6,
	{0xFE, 0xC2, 0x10, 0xF5, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_079 = {
	0,
	6,
	{0xFE, 0xC2, 0x11, 0x1F, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_080 = {
	0,
	6,
	{0xFE, 0xC2, 0x11, 0x49, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_081 = {
	0,
	6,
	{0xFE, 0xC2, 0x11, 0x73, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_082 = {
	0,
	6,
	{0xFE, 0xC2, 0x11, 0x9D, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_083 = {
	0,
	6,
	{0xFE, 0xC2, 0x11, 0xC7, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_084 = {
	0,
	6,
	{0xFE, 0xC2, 0x11, 0xF1, 0x80, 0xA4}
};
WBLOCK isdb_t_pll_085 = {
	0,
	6,
	{0xFE, 0xC2, 0x12, 0x1B, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_086 = {
	0,
	6,
	{0xFE, 0xC2, 0x12, 0x45, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_087 = {
	0,
	6,
	{0xFE, 0xC2, 0x12, 0x6F, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_088 = {
	0,
	6,
	{0xFE, 0xC2, 0x12, 0x99, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_089 = {
	0,
	6,
	{0xFE, 0xC2, 0x12, 0xC3, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_090 = {
	0,
	6,
	{0xFE, 0xC2, 0x12, 0xED, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_091 = {
	0,
	6,
	{0xFE, 0xC2, 0x13, 0x17, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_092 = {
	0,
	6,
	{0xFE, 0xC2, 0x13, 0x41, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_093 = {
	0,
	6,
	{0xFE, 0xC2, 0x13, 0x6B, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_094 = {
	0,
	6,
	{0xFE, 0xC2, 0x13, 0x95, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_095 = {
	0,
	6,
	{0xFE, 0xC2, 0x13, 0xBF, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_096 = {
	0,
	6,
	{0xFE, 0xC2, 0x13, 0xE9, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_097 = {
	0,
	6,
	{0xFE, 0xC2, 0x14, 0x13, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_098 = {
	0,
	6,
	{0xFE, 0xC2, 0x14, 0x3D, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_099 = {
	0,
	6,
	{0xFE, 0xC2, 0x14, 0x67, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_100 = {
	0,
	6,
	{0xFE, 0xC2, 0x14, 0x91, 0x80, 0xC4}
};
WBLOCK isdb_t_pll_101 = {
	0,
	6,
	{0xFE, 0xC2, 0x14, 0xBB, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_102 = {
	0,
	6,
	{0xFE, 0xC2, 0x14, 0xE5, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_103 = {
	0,
	6,
	{0xFE, 0xC2, 0x15, 0x0F, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_104 = {
	0,
	6,
	{0xFE, 0xC2, 0x15, 0x39, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_105 = {
	0,
	6,
	{0xFE, 0xC2, 0x15, 0x63, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_106 = {
	0,
	6,
	{0xFE, 0xC2, 0x15, 0x8D, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_107 = {
	0,
	6,
	{0xFE, 0xC2, 0x15, 0xB7, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_108 = {
	0,
	6,
	{0xFE, 0xC2, 0x15, 0xE1, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_109 = {
	0,
	6,
	{0xFE, 0xC2, 0x16, 0x0B, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_110 = {
	0,
	6,
	{0xFE, 0xC2, 0x16, 0x35, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_111 = {
	0,
	6,
	{0xFE, 0xC2, 0x16, 0x5F, 0x80, 0xE4}
};
WBLOCK isdb_t_pll_112 = {
	0,
	4,
	{0xFE, 0xC2, 0x16, 0x89, 0x80, 0xE4}
};
/***************************************************************************/
/* ϥǥѥǡ                                                          */
/***************************************************************************/
WBLOCK	*isdb_t_pll[MAX_ISDB_T_CHANNEL] =
{
	&isdb_t_pll_000, &isdb_t_pll_001, &isdb_t_pll_002, &isdb_t_pll_003,
	&isdb_t_pll_004, &isdb_t_pll_005, &isdb_t_pll_006, &isdb_t_pll_007,
	&isdb_t_pll_008, &isdb_t_pll_009, &isdb_t_pll_010, &isdb_t_pll_011,
	&isdb_t_pll_012, &isdb_t_pll_013, &isdb_t_pll_014, &isdb_t_pll_015,
	&isdb_t_pll_016, &isdb_t_pll_017, &isdb_t_pll_018, &isdb_t_pll_019,
	&isdb_t_pll_020, &isdb_t_pll_021, &isdb_t_pll_022, &isdb_t_pll_023,
	&isdb_t_pll_024, &isdb_t_pll_025, &isdb_t_pll_026, &isdb_t_pll_027,
	&isdb_t_pll_028, &isdb_t_pll_029, &isdb_t_pll_030, &isdb_t_pll_031,
	&isdb_t_pll_032, &isdb_t_pll_033, &isdb_t_pll_034, &isdb_t_pll_035,
	&isdb_t_pll_036, &isdb_t_pll_037, &isdb_t_pll_038, &isdb_t_pll_039,
	&isdb_t_pll_040, &isdb_t_pll_041, &isdb_t_pll_042, &isdb_t_pll_043,
	&isdb_t_pll_044, &isdb_t_pll_045, &isdb_t_pll_046, &isdb_t_pll_047,
	&isdb_t_pll_048, &isdb_t_pll_049, &isdb_t_pll_050, &isdb_t_pll_051,
	&isdb_t_pll_052, &isdb_t_pll_053, &isdb_t_pll_054, &isdb_t_pll_055,
	&isdb_t_pll_056, &isdb_t_pll_057, &isdb_t_pll_058, &isdb_t_pll_059,
	&isdb_t_pll_060, &isdb_t_pll_061, &isdb_t_pll_062, &isdb_t_pll_063,
	&isdb_t_pll_064, &isdb_t_pll_065, &isdb_t_pll_066, &isdb_t_pll_067,
	&isdb_t_pll_068, &isdb_t_pll_069, &isdb_t_pll_070, &isdb_t_pll_071,
	&isdb_t_pll_072, &isdb_t_pll_073, &isdb_t_pll_074, &isdb_t_pll_075,
	&isdb_t_pll_076, &isdb_t_pll_077, &isdb_t_pll_078, &isdb_t_pll_079,
	&isdb_t_pll_080, &isdb_t_pll_081, &isdb_t_pll_082, &isdb_t_pll_083,
	&isdb_t_pll_084, &isdb_t_pll_085, &isdb_t_pll_086, &isdb_t_pll_087,
	&isdb_t_pll_088, &isdb_t_pll_089, &isdb_t_pll_090, &isdb_t_pll_091,
	&isdb_t_pll_092, &isdb_t_pll_093, &isdb_t_pll_094, &isdb_t_pll_095,
	&isdb_t_pll_096, &isdb_t_pll_097, &isdb_t_pll_098, &isdb_t_pll_099,
	&isdb_t_pll_100, &isdb_t_pll_101, &isdb_t_pll_102, &isdb_t_pll_103,
	&isdb_t_pll_104, &isdb_t_pll_105, &isdb_t_pll_106, &isdb_t_pll_107,
	&isdb_t_pll_108, &isdb_t_pll_109, &isdb_t_pll_110, &isdb_t_pll_111,
	&isdb_t_pll_112
};

/***************************************************************************/
/* ϥǥȿåå                                              */
/***************************************************************************/
WBLOCK	isdb_t_pll_lock = {
	0,
	2,
	{0xFE, 0xC3}
};

WBLOCK	isdb_t_check_tune = {
	0,
	2,
	{0x01, 0x40}
};

WBLOCK	isdb_t_tune_read = {
	0,
	1,
	{0x80}
};
WBLOCK	isdb_t_tmcc_read_1 = {
	0,
	1,
	{0xB2}
};
WBLOCK	isdb_t_tmcc_read_2 = {
	0,
	1,
	{0xB6}
};
/***************************************************************************/
/* ϥǥȿåå                                              */
/***************************************************************************/
WBLOCK	isdb_t_cn_1 = {
	0,
	1,
	{0x8B}
};
WBLOCK	isdb_t_cn_2 = {
	0,
	1,
	{0x8C}
};
WBLOCK	isdb_t_agc1 = {
	0,
	1,
	{0x8D}
};
WBLOCK	isdb_t_agc2 = {
	0,
	1,
	{0x82}
};
WBLOCK	isdb_t_lockedt1 = {
	0,
	1,
	{0x96}
};
WBLOCK	isdb_t_lockedt2 = {
	0,
	1,
	{0xB0}
};
WBLOCK	isdb_t_get_clock = {
	0,
	1,
	{0x86}
};
WBLOCK	isdb_t_get_carrir = {
	0,
	1,
	{0x84}
};

/***************************************************************************/
/* ϥǥѥǡ                                                          */
/***************************************************************************/

/***************************************************************************/
/* £ѥǡ                                                            */
/***************************************************************************/
/***************************************************************************/
/* £Ӽȿåå                                                */
/***************************************************************************/
WBLOCK	bs_pll_lock = {
	0,
	2,
	{0xFE, 0xC1}
};
/***************************************************************************/
/* TMCC                                                                */
/***************************************************************************/
WBLOCK	bs_tmcc_get_1 = {
	0,
	2,
	{0x03, 0x01}
};
WBLOCK	bs_tmcc_get_2 = {
	0,
	1,
	{0xC3}
};
/***************************************************************************/
/* TMCC                                                                */
/***************************************************************************/
WBLOCK	bs_get_slot_ts_id_1 = {
	0,
	1,
	{0xCE}
};
WBLOCK	bs_get_slot_ts_id_2 = {
	0,
	1,
	{0xD2}
};
WBLOCK	bs_get_slot_ts_id_3 = {
	0,
	1,
	{0xD6}
};
WBLOCK	bs_get_slot_ts_id_4 = {
	0,
	1,
	{0xDA}
};
/***************************************************************************/
/* TS-IDå                                                             */
/***************************************************************************/
WBLOCK	bs_set_ts_lock = {
	0,
	3,
	{0x8F, 0x00, 0x00}
};
/***************************************************************************/
/* TS-ID                                                               */
/***************************************************************************/
WBLOCK	bs_get_ts_lock = {
	0,
	1,
	{0xE6}
};
/***************************************************************************/
/* åȼ                                                            */
/***************************************************************************/
WBLOCK	bs_get_slot = {
	0,
	1,
	{0xE8}
};
/***************************************************************************/
/* CN/AGC/MAXAGC                                                       */
/***************************************************************************/
WBLOCK	bs_get_cn = {
	0,
	1,
	{0xBC}
};
WBLOCK	bs_get_agc = {
	0,
	1,
	{0xBD}
};
WBLOCK	bs_get_maxagc = {
	0,
	1,
	{0xBA}
};
/***************************************************************************/
/* åȿ                                                  */
/***************************************************************************/
WBLOCK	bs_get_clock = {
	0,
	1,
	{0xBE}
};
/***************************************************************************/
/* ꥢȿ                                                  */
/***************************************************************************/
WBLOCK	bs_get_carrir = {
	0,
	1,
	{0xBB}
};
/***************************************************************************/
/* ȿơ֥                                                      */
/* £Ӥ˴ؤƤΤߡȤꤢơ֥Ȥ׻ǻнʤ      */
/* ׻ǻФ롣                                                      */
/***************************************************************************/
/***************************************************************************/
/* BS̥ơ֥                                                          */
/***************************************************************************/
WBLOCK	bs_com_step2 = {
	0,
	3,
	{0xFE, 0xC0, 0xE4}
};
/***************************************************************************/
/* BS-1                                                                    */
/***************************************************************************/
WBLOCK	bs_1_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x48, 0x29, 0xE0, 0xD2}
};
WBLOCK	bs_1_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xD6}
};
/***************************************************************************/
/* BS-3                                                                    */
/***************************************************************************/
WBLOCK	bs_3_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x40, 0xE0, 0xE2}
};
WBLOCK	bs_3_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xE6}
};
/***************************************************************************/
/* BS-5                                                                    */
/***************************************************************************/
WBLOCK	bs_5_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x66, 0xE0, 0xE2}
};
WBLOCK	bs_5_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xE6}
};
/***************************************************************************/
/* BS-7                                                                    */
/***************************************************************************/
WBLOCK	bs_7_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x8D, 0xE0, 0x20}
};
WBLOCK	bs_7_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-9                                                                    */
/***************************************************************************/
WBLOCK	bs_9_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0xB3, 0xE0, 0x20}
};
WBLOCK	bs_9_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-11                                                                   */
/***************************************************************************/
WBLOCK	bs_11_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0xD9, 0xE0, 0x20}
};
WBLOCK	bs_11_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-13                                                                   */
/***************************************************************************/
WBLOCK	bs_13_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x00, 0xE0, 0x20}
};
WBLOCK	bs_13_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-15                                                                   */
/***************************************************************************/
WBLOCK	bs_15_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x26, 0xE0, 0x40}
};
WBLOCK	bs_15_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-17                                                                   */
/***************************************************************************/
WBLOCK	bs_17_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x73, 0xE0, 0x40}
};
WBLOCK	bs_17_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0X44}
};
/***************************************************************************/
/* BS-19                                                                   */
/***************************************************************************/
WBLOCK	bs_19_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x73, 0xE0, 0x40}
};
WBLOCK	bs_19_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-21                                                                   */
/***************************************************************************/
WBLOCK	bs_21_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x99, 0xE0, 0x40}
};
WBLOCK	bs_21_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-23                                                                   */
/***************************************************************************/
WBLOCK	bs_23_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0xBF, 0xE0, 0x60}
};
WBLOCK	bs_23_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x64}
};

/***************************************************************************/
/* BS-ȿơ֥                                                       */
/***************************************************************************/
WBLOCK_BS_PLL	bs_pll[MAX_BS_CHANNEL] = {
	{&bs_1_step1, &bs_com_step2, &bs_1_step3},
	{&bs_3_step1, &bs_com_step2, &bs_3_step3},
	{&bs_5_step1, &bs_com_step2, &bs_5_step3},
	{&bs_7_step1, &bs_com_step2, &bs_7_step3},
	{&bs_9_step1, &bs_com_step2, &bs_9_step3},
	{&bs_11_step1, &bs_com_step2, &bs_11_step3},
	{&bs_13_step1, &bs_com_step2, &bs_13_step3},
	{&bs_15_step1, &bs_com_step2, &bs_15_step3},
	{&bs_17_step1, &bs_com_step2, &bs_17_step3},
	{&bs_19_step1, &bs_com_step2, &bs_19_step3},
	{&bs_21_step1, &bs_com_step2, &bs_21_step3},
	{&bs_23_step1, &bs_com_step2, &bs_21_step3}
};
WBLOCK	*bs_get_ts_id[(MAX_BS_TS_ID / 2)] = {
	&bs_get_slot_ts_id_1,
	&bs_get_slot_ts_id_2,
	&bs_get_slot_ts_id_3,
	&bs_get_slot_ts_id_4
};
