/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesPartitionScanner;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.listener.IPropertiesDocumentListener;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.property.PropertyUtil;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.resources.Messages;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class PropertiesDocumentProvider
extends FileDocumentProvider {
    private static final String EXTENSION_POINT = "jp.gr.java_conf.ussiy.app.propedit.listeners";

    protected List computePropertiesDocumentListeners() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Object> results = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object listener = elements[j].createExecutableExtension("class");
                    if (listener instanceof IPropertiesDocumentListener) {
                        results.add(listener);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return results;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IPropertiesDocumentListener listener;
        IProject project;
        String readEncode = PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("readEncode");
        if (readEncode == null || readEncode.equals("")) {
            readEncode = this.getDefaultEncoding();
        }
        IDocument document = null;
        if (element instanceof IEditorInput && !this.setDocumentContent(document = this.createEmptyDocument(), (IEditorInput)element, readEncode = PropertyUtil.getEncode(project = ((IFileEditorInput)element).getFile().getProject(), readEncode))) {
            document = null;
        }
        List listeners = this.computePropertiesDocumentListeners();
        int i = 0;
        while (i < listeners.size()) {
            listener = (IPropertiesDocumentListener)listeners.get(i);
            try {
                listener.beforeConvertAtLoadingDocument(document.get(), element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (document != null) {
            try {
                document.set(EncodeChanger.unicodeEsc2Unicode(document.get()));
            }
            catch (Exception e) {
                Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                ILog log = PropertiesEditorPlugin.getDefault().getLog();
                log.log((IStatus)status);
                ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
            }
            i = 0;
            while (i < listeners.size()) {
                listener = (IPropertiesDocumentListener)listeners.get(i);
                try {
                    listener.afterConvertAtLoadingDocument(document.get(), element);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PropertiesPartitionScanner(), new String[]{"__dftl_partition_content_type", "__properties_comment", "__properties_separator", "__properties_value"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        block26: {
            if (element instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)element;
                IProject project = input.getFile().getProject();
                try {
                    String uniEscStr;
                    List listeners;
                    String encoding;
                    block25: {
                        ILog log;
                        Status status;
                        encoding = PropertyUtil.getEncode(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("readEncode"));
                        if (encoding == null || encoding.equals("")) {
                            encoding = this.getDefaultEncoding();
                        }
                        listeners = this.computePropertiesDocumentListeners();
                        int i = 0;
                        while (i < listeners.size()) {
                            IPropertiesDocumentListener listener = (IPropertiesDocumentListener)listeners.get(i);
                            try {
                                listener.beforeUnicodeConvertAtSavingDocument(monitor, document.get(), input);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ++i;
                        }
                        uniEscStr = null;
                        String charcase = PropertyUtil.getCharCase(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("convertCharCase"));
                        if (PropertyUtil.getNotAllConvert(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvert"))) {
                            uniEscStr = document.get();
                        } else if (PropertyUtil.getNotConvertComment(project, PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvertComment"))) {
                            try {
                                if (Messages.getString("eclipse.propertieseditor.preference.convert.char.uppercase").equals(charcase)) {
                                    uniEscStr = EncodeChanger.unicode2UnicodeEscWithoutComment(document.get(), 1);
                                    break block25;
                                }
                                uniEscStr = EncodeChanger.unicode2UnicodeEscWithoutComment(document.get(), 0);
                            }
                            catch (Exception e) {
                                status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                                log = PropertiesEditorPlugin.getDefault().getLog();
                                log.log((IStatus)status);
                                ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
                            }
                        } else {
                            try {
                                uniEscStr = Messages.getString("eclipse.propertieseditor.preference.convert.char.uppercase").equals(charcase) ? EncodeChanger.unicode2UnicodeEsc(document.get(), 1) : EncodeChanger.unicode2UnicodeEsc(document.get(), 0);
                            }
                            catch (Exception e) {
                                status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                                log = PropertiesEditorPlugin.getDefault().getLog();
                                log.log((IStatus)status);
                                ErrorDialog.openError(null, (String)Messages.getString("eclipse.propertieseditor.convert.error"), (String)Messages.getString("eclipse.propertieseditor.property.get.settings.error"), (IStatus)status);
                            }
                        }
                    }
                    int i = 0;
                    while (i < listeners.size()) {
                        IPropertiesDocumentListener listener = (IPropertiesDocumentListener)listeners.get(i);
                        try {
                            listener.afterUnicodeConvertAtSavingDocument(monitor, uniEscStr, input);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    ByteArrayInputStream stream = new ByteArrayInputStream(uniEscStr.toString().getBytes(encoding));
                    IFile file = input.getFile();
                    if (file.exists()) {
                        FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
                        if (info != null && !overwrite) {
                            this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
                        }
                        this.fireElementStateChanging(element);
                        try {
                            file.setContents((InputStream)stream, overwrite, true, monitor);
                        }
                        catch (CoreException x) {
                            this.fireElementStateChangeFailed(element);
                            throw x;
                        }
                        catch (RuntimeException x) {
                            this.fireElementStateChangeFailed(element);
                            throw x;
                        }
                        if (info != null) {
                            ResourceMarkerAnnotationModel model = (ResourceMarkerAnnotationModel)info.fModel;
                            model.updateMarkers(info.fDocument);
                            info.fModificationStamp = this.computeModificationStamp((IResource)file);
                        }
                        break block26;
                    }
                    super.doSaveDocument(monitor, element, document, overwrite);
                    return;
                }
                catch (IOException x) {
                    Status s = new Status(4, "org.eclipse.ui", 0, x.getMessage(), (Throwable)x);
                    throw new CoreException((IStatus)s);
                }
            }
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }
}

