/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.net.MalformedURLException;
import java.net.URL;
import jp.gr.java_conf.ussiy.app.propedit.PropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesOutlineContentProvider;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesOutlineLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class PropertiesContentOutlinePage
extends ContentOutlinePage {
    protected static String ALPHA_SORT_BTN_CHECK_KEY = "jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.alphaSortCheckKey";
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;
    protected PropertiesOutlineContentProvider contentProvider;

    public PropertiesContentOutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
        this.fDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput()).addDocumentListener((IDocumentListener)this.getContentProvider());
    }

    protected PropertiesOutlineContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new PropertiesOutlineContentProvider(this);
        }
        return this.contentProvider;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)this.getContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PropertiesOutlineLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
        PropertiesEditorPlugin.getDefault().getPluginPreferences().setDefault(ALPHA_SORT_BTN_CHECK_KEY, false);
        IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
        String label = PropertiesEditor.res.getString("eclipse.contentoutline.sort.label");
        Action action = new Action(label, 2){

            public void run() {
                PropertiesEditorPlugin.getDefault().getPluginPreferences().setValue(ALPHA_SORT_BTN_CHECK_KEY, this.isChecked());
                if (this.isChecked()) {
                    TreeViewer v = PropertiesContentOutlinePage.this.getTreeViewer();
                    v.setSorter(new ViewerSorter());
                    v.setInput(v.getInput());
                } else {
                    PropertiesContentOutlinePage.this.getTreeViewer().setSorter(null);
                    PropertiesContentOutlinePage.this.redraw();
                }
            }
        };
        action.setToolTipText(action.getText());
        URL url = PropertiesEditorPlugin.getDefault().getBundle().getEntry("/");
        String path = "icons/alphab_sort_co.gif";
        ImageDescriptor descriptor = null;
        try {
            descriptor = ImageDescriptor.createFromURL((URL)new URL(url, path));
        }
        catch (MalformedURLException e) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        action.setImageDescriptor(descriptor);
        toolbar.add((IAction)action);
        action.setChecked(PropertiesEditorPlugin.getDefault().getPluginPreferences().getBoolean(ALPHA_SORT_BTN_CHECK_KEY));
        action.run();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Segment segment = (Segment)((IStructuredSelection)selection).getFirstElement();
            int start = segment.position.getOffset();
            int length = segment.position.getLength();
            try {
                this.fTextEditor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException x) {
                this.fTextEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    protected void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    public void redraw() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected static class Segment {
        public String name;
        public Position position;

        public Segment(String name, Position position) {
            this.name = name;
            this.position = position;
        }

        public String toString() {
            return this.name;
        }
    }
}

