/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import jp.gr.java_conf.ussiy.app.propedit.PropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesPartitionScanner;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class PropertiesDocumentProvider
extends FileDocumentProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndMarkDuplicateKey(String text, IFileEditorInput editorInput) throws CoreException {
        String line = null;
        int cntLine = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String warn = PropertiesEditor.res.getString("eclipse_editor_key_duplicate");
        boolean multipleValueFlg = false;
        ArrayList<String> duplicateKeyList = new ArrayList<String>();
        IFile resource = editorInput.getFile();
        IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        int i = 0;
        while (i < markers.length) {
            markers[i].delete();
            ++i;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(text));
            while ((line = reader.readLine()) != null) {
                ++cntLine;
                if (line.startsWith("#")) continue;
                if (multipleValueFlg) {
                    if (line.endsWith("\\")) {
                        multipleValueFlg = true;
                        continue;
                    }
                    multipleValueFlg = false;
                    continue;
                }
                int index = line.indexOf("=");
                if (index == -1) continue;
                String key = line.substring(0, index);
                if (map.containsKey(key)) {
                    IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("transient", true);
                    marker.setAttribute("message", (Object)PropertiesDocumentProvider.replace(warn, key, "$key$"));
                    marker.setAttribute("lineNumber", cntLine);
                    if (!duplicateKeyList.contains(key)) {
                        int tmpCntLine = (Integer)map.get(key);
                        marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                        marker.setAttribute("severity", 1);
                        marker.setAttribute("transient", true);
                        marker.setAttribute("message", (Object)PropertiesDocumentProvider.replace(warn, key, "$key$"));
                        marker.setAttribute("lineNumber", tmpCntLine);
                    } else {
                        duplicateKeyList.add(key);
                    }
                }
                map.put(key, new Integer(cntLine));
                if (line.endsWith("\\")) {
                    multipleValueFlg = true;
                    continue;
                }
                multipleValueFlg = false;
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
            map.clear();
            map = null;
        }
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        document.set(EncodeChanger.UnicodeEsc2Unicode(document.get()));
        if (document != null) {
            DefaultPartitioner partitioner = new DefaultPartitioner((IPartitionTokenScanner)new PropertiesPartitionScanner(), new String[]{"__properties_comment", "__properties_key"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            this.checkAndMarkDuplicateKey(document.get(), input);
            try {
                String encoding = this.getEncoding(input);
                if (encoding == null) {
                    encoding = this.getDefaultEncoding();
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(EncodeChanger.Unicode2UnicodeEsc(document.get()).getBytes(encoding));
                IFile file = input.getFile();
                if (file.exists()) {
                    FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
                    if (info != null && !overwrite) {
                        this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
                    }
                    this.fireElementStateChanging(element);
                    try {
                        file.setContents((InputStream)stream, overwrite, true, monitor);
                    }
                    catch (CoreException x) {
                        this.fireElementStateChangeFailed(element);
                        throw x;
                    }
                    catch (RuntimeException x) {
                        this.fireElementStateChangeFailed(element);
                        throw x;
                    }
                    if (info == null) return;
                    ResourceMarkerAnnotationModel model = (ResourceMarkerAnnotationModel)info.fModel;
                    model.updateMarkers(info.fDocument);
                    info.fModificationStamp = this.computeModificationStamp((IResource)file);
                    return;
                }
                super.doSaveDocument(monitor, element, document, overwrite);
                return;
            }
            catch (IOException x) {
                Status s = new Status(4, "org.eclipse.ui", 0, x.getMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }

    public static String replace(String str, String toString, String fromString) {
        StringBuffer buf = new StringBuffer();
        int idx = str.indexOf(fromString, 0);
        if (idx == -1) {
            return str;
        }
        buf.append(str.substring(0, idx));
        buf.append(toString);
        buf.append(str.substring(idx + fromString.length(), str.length()));
        return buf.toString();
    }
}

