/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.model;

import java.util.List;
import java.util.Stack;
import jp.sf.propdev.model.AbstractNode;
import jp.sf.propdev.model.CommentNode;
import jp.sf.propdev.model.KeyNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class PropertiesNode
extends AbstractNode {
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private List outlineModel;

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private static String getLineString(IDocument document, int lineIndex) throws BadLocationException {
        int offset = document.getLineOffset(lineIndex);
        int length = document.getLineLength(lineIndex);
        String line = document.get(offset, length).trim();
        return line;
    }

    private static int getStartPos(String line) {
        int len = line.length();
        int keyStart = 0;
        while (keyStart < len) {
            if (whiteSpaceChars.indexOf(line.charAt(keyStart)) == -1) break;
            ++keyStart;
        }
        return keyStart;
    }

    public static PropertiesNode load(IDocument document) {
        PropertiesNode propNode = new PropertiesNode(null);
        Stack<AbstractNode> children = new Stack<AbstractNode>();
        try {
            propNode.setStartOffset(0);
            propNode.addLength(document.getLength());
            int lines = document.getNumberOfLines();
            int lineIndex = 0;
            while (lineIndex < lines) {
                String line = PropertiesNode.getLineString(document, lineIndex);
                if (line == null) {
                    line = "";
                }
                int len = line.length();
                int keyStart = PropertiesNode.getStartPos(line);
                if (keyStart != len) {
                    char firstChar = line.charAt(keyStart);
                    if (firstChar == '#' || firstChar == '!') {
                        CommentNode cn;
                        if (children.size() == 0) {
                            cn = new CommentNode(propNode);
                            cn.setStartLine(lineIndex);
                            children.push(cn);
                        } else if (!(children.peek() instanceof CommentNode)) {
                            cn = new CommentNode(propNode);
                            cn.setStartOffset(document.getLineOffset(lineIndex));
                            cn.setStartLine(lineIndex);
                            children.push(cn);
                        }
                        cn = (CommentNode)children.peek();
                        cn.addLength(document.getLineLength(lineIndex));
                        cn.setEndLine(lineIndex);
                    } else {
                        KeyNode kn = new KeyNode(propNode);
                        kn.setStartOffset(document.getLineOffset(lineIndex));
                        kn.setStartLine(lineIndex);
                        kn.addLength(document.getLineLength(lineIndex));
                        while (PropertiesNode.continueLine(line)) {
                            String nextLine;
                            if ((nextLine = PropertiesNode.getLineString(document, lineIndex++)) == null) {
                                nextLine = "";
                            }
                            String loppedLine = line.substring(0, len - 1);
                            int startIndex = 0;
                            while (startIndex < nextLine.length()) {
                                if (whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) == -1) break;
                                ++startIndex;
                            }
                            nextLine = nextLine.substring(startIndex, nextLine.length());
                            line = new String(String.valueOf(loppedLine) + nextLine);
                            len = line.length();
                            kn.addLength(document.getLineLength(lineIndex));
                        }
                        kn.setEndLine(lineIndex);
                        int separatorIndex = keyStart;
                        while (separatorIndex < len) {
                            char currentChar = line.charAt(separatorIndex);
                            if (currentChar == '\\') {
                                ++separatorIndex;
                            } else if (keyValueSeparators.indexOf(currentChar) != -1) break;
                            ++separatorIndex;
                        }
                        int valueIndex = separatorIndex;
                        while (valueIndex < len) {
                            if (whiteSpaceChars.indexOf(line.charAt(valueIndex)) == -1) break;
                            ++valueIndex;
                        }
                        if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                            ++valueIndex;
                        }
                        while (valueIndex < len) {
                            if (whiteSpaceChars.indexOf(line.charAt(valueIndex)) == -1) break;
                            ++valueIndex;
                        }
                        String key = line.substring(keyStart, separatorIndex);
                        key = PropertiesNode.loadConvert(key);
                        kn.setKey(key);
                        children.push(kn);
                    }
                }
                ++lineIndex;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        propNode.setOutlineModel(children);
        return propNode;
    }

    private static String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private PropertiesNode(AbstractNode parent) {
        super(parent);
    }

    public List getOutlineModel() {
        return this.outlineModel;
    }

    private void setOutlineModel(List outlineModel) {
        this.outlineModel = outlineModel;
    }
}

