/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import zephyr.util.BIMUtil;
import zephyr.util.BitType;
import zephyr.util.MultiHashMap;
import zephyr.util.VLineFinder;

public class CheckVlineSlope {
    private final int HALF_BAR_CHECK_DOT;
    private static PointComparator POINT_COMP = new PointComparator();

    public CheckVlineSlope(int n) {
        this.HALF_BAR_CHECK_DOT = BIMUtil.mm2dot(10.0, n);
    }

    public double check(File file) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(file);
        int n = bufferedImage.getWidth();
        int n2 = n / 2 - this.HALF_BAR_CHECK_DOT;
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(n2, 0, 2 * this.HALF_BAR_CHECK_DOT, bufferedImage.getHeight());
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < bufferedImage2.getWidth(); ++i) {
            int n5 = BIMUtil.vlineLen(bufferedImage2, i);
            if (n5 <= n3) continue;
            n3 = n5;
            n4 = i;
        }
        BitType[][] bitTypeArray = BitType.makeArray(bufferedImage2);
        LinkedList<int[]> linkedList = VLineFinder.find(bitTypeArray, n4);
        if (linkedList == null) {
            return -1.0;
        }
        Collections.sort(linkedList, POINT_COMP);
        double d = linkedList.getFirst()[0];
        double d2 = linkedList.getFirst()[1];
        double d3 = linkedList.getLast()[0];
        double d4 = linkedList.getLast()[1];
        double d5 = Math.toDegrees(Math.atan((d3 - d) / (d4 - d2)));
        return d5;
    }

    private void parse(String string) throws Exception {
        File file = new File(string);
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        MultiHashMap multiHashMap = new MultiHashMap();
        for (Object iterator : objectArray) {
            if (!((String)iterator).endsWith(".bmp") && !((String)iterator).endsWith(".jpg") && !((String)iterator).equals(".png")) continue;
            File file2 = new File(file, (String)iterator);
            double d = this.check(file2);
            multiHashMap.put(d, file2);
        }
        Object[] objectArray2 = multiHashMap.keySet().toArray(new Double[0]);
        Arrays.sort(objectArray2, new AbsComp());
        for (int i = objectArray2.length - 1; i >= 0; --i) {
            Object object = objectArray2[i];
            for (File file2 : multiHashMap.getList(object)) {
                System.out.printf("% .2f\t%s\n", object, file2.getName());
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 300;
        String string = stringArray.length > 1 ? stringArray[1] : "bmp";
        CheckVlineSlope checkVlineSlope = new CheckVlineSlope(n);
        checkVlineSlope.parse(string);
    }

    private static class AbsComp
    implements Comparator<Double> {
        private AbsComp() {
        }

        @Override
        public int compare(Double d, Double d2) {
            return Double.compare(Math.abs(d), Math.abs(d2));
        }
    }

    private static class PointComparator
    implements Comparator<int[]> {
        private PointComparator() {
        }

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            int n = nArray[1] - nArray2[1];
            if (n != 0) {
                return n;
            }
            return nArray[0] - nArray2[0];
        }
    }
}

