/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.awt.image.BufferedImage;

public enum BitType {
    BLACK,
    WHITE,
    CHECKING,
    OK,
    NG;


    public static BitType[][] makeArray(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BitType[][] bitTypeArray = new BitType[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bitTypeArray[i][j] = bufferedImage.getRGB(i, j) == -1 ? WHITE : BLACK;
            }
        }
        return bitTypeArray;
    }

    public static void dumpArray(BitType[][] bitTypeArray) {
        BitType.dumpArray(bitTypeArray, 'O', 'X');
    }

    public static void dumpArray(BitType[][] bitTypeArray, char c, char c2) {
        int n = bitTypeArray.length;
        int n2 = bitTypeArray[0].length;
        for (int i = 0; i < n2; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(i);
            stringBuilder.append("\t");
            block8: for (int j = 0; j < n; ++j) {
                switch (bitTypeArray[j][i]) {
                    case BLACK: {
                        stringBuilder.append('*');
                        continue block8;
                    }
                    case WHITE: {
                        stringBuilder.append('.');
                        continue block8;
                    }
                    case CHECKING: {
                        stringBuilder.append('?');
                        continue block8;
                    }
                    case OK: {
                        stringBuilder.append(c);
                        continue block8;
                    }
                    case NG: {
                        stringBuilder.append(c2);
                    }
                }
            }
            System.out.println(stringBuilder.toString());
        }
    }
}

