/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class MakeCharImages {
    private final Font font;
    private final File outDir;
    private static final Pattern UNICODE = Pattern.compile("U\\+0*([0-9A-F]+)");
    private final int WHITE = -1;
    private static final boolean OUTPUT_JIS = true;

    MakeCharImages(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "IPA\u660e\u671d";
        int n = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 50;
        this.font = new Font(string, 0, n);
        this.outDir = new File(stringArray.length > 2 ? stringArray[2] : "i");
    }

    private Integer[] usedUnicode() throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(new File("dkw2ucs.txt"));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            Matcher matcher = UNICODE.matcher(string);
            while (matcher.find()) {
                n = Integer.parseInt(matcher.group(1), 16);
                treeSet.add(n);
            }
            for (n = 0; n < string.length(); ++n) {
                int n2 = string.codePointAt(n);
                if (n2 >= 131072) {
                    treeSet.add(n2);
                    ++n;
                    continue;
                }
                if (n2 < 256) continue;
                treeSet.add(n2);
            }
        }
        bufferedReader.close();
        System.err.println(treeSet.size() + " chars");
        return treeSet.toArray(new Integer[0]);
    }

    private BufferedImage stringToBufferedImage(String string) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 12);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setFont(this.font);
        FontRenderContext fontRenderContext = graphics.getFontMetrics().getFontRenderContext();
        Rectangle2D rectangle2D = this.font.getStringBounds(string, fontRenderContext);
        graphics.dispose();
        if (rectangle2D.getWidth() <= 0.0 || rectangle2D.getHeight() <= 0.0) {
            return null;
        }
        bufferedImage = new BufferedImage((int)Math.ceil(rectangle2D.getWidth()), (int)Math.ceil(rectangle2D.getHeight()), 12);
        graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(Color.black);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        int n2 = fontMetrics.getAscent();
        graphics.drawString(string, n, n2);
        graphics.dispose();
        return bufferedImage;
    }

    private BufferedImage trim(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = bufferedImage.getWidth();
        int n8 = bufferedImage.getHeight();
        for (n6 = 0; n6 < n8; ++n6) {
            if (this.isWhiteHorizon(bufferedImage, n6)) continue;
            if (n6 >= 0) break;
            n6 = 0;
            break;
        }
        for (n5 = n8 - 1; n5 > n6; --n5) {
            if (this.isWhiteHorizon(bufferedImage, n5)) continue;
            if (n5 <= n8) break;
            n5 = n8;
            break;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            if (this.isWhiteVertical(bufferedImage, n4)) continue;
            if (n4 >= 0) break;
            n4 = 0;
            break;
        }
        for (n3 = n7 - 1; n3 > n4; --n3) {
            if (this.isWhiteVertical(bufferedImage, n3)) continue;
            if (n3 <= n7) break;
            n3 = n7;
            break;
        }
        if ((n2 = n5 - n6) < this.font.getSize()) {
            if ((n6 -= (this.font.getSize() - n2) / 2) < 0) {
                n6 = 0;
            }
            if ((n5 = n6 + this.font.getSize()) > bufferedImage.getHeight()) {
                n5 = bufferedImage.getHeight();
            }
        }
        if ((n = n3 - n4) < this.font.getSize()) {
            if ((n4 -= (this.font.getSize() - n) / 2) < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + this.font.getSize()) > bufferedImage.getWidth()) {
                n3 = bufferedImage.getWidth();
            }
        }
        return bufferedImage.getSubimage(n4, n6, n3 - n4, n5 - n6);
    }

    private boolean isWhiteHorizon(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) == -1) continue;
            return false;
        }
        return true;
    }

    private boolean isWhiteVertical(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(n, i) == -1) continue;
            return false;
        }
        return true;
    }

    private void output() throws Exception {
        this.outDir.mkdirs();
        Integer[] integerArray = this.usedUnicode();
        int n = 0;
        int[] nArray = new int[1];
        for (Integer n2 : integerArray) {
            BufferedImage bufferedImage;
            if (!this.font.canDisplay(n2)) continue;
            nArray[0] = n2;
            String string = new String(nArray, 0, 1);
            if (n2 < 65536) {
                // empty if block
            }
            if ((bufferedImage = this.stringToBufferedImage(string)) == null) continue;
            File file = new File(this.outDir, String.format("%05X.bmp", n2));
            if (file.exists()) continue;
            ImageIO.write((RenderedImage)this.trim(bufferedImage), "bmp", file);
            if (++n % 1000 != 0) continue;
            System.out.print(n + " ");
        }
        System.out.println();
        System.out.println(n);
    }

    public static void main(String[] stringArray) throws Exception {
        MakeCharImages makeCharImages = new MakeCharImages(stringArray);
        makeCharImages.output();
    }
}

