/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.colorpane;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;

public class CSArrayBased {
    private JPanel panel;
    private PDColorSpace colorSpace = null;
    private int numberOfComponents = 0;
    private String errmsg = "";

    public CSArrayBased(COSArray array) {
        try {
            this.colorSpace = PDColorSpace.create(array);
            if (!(this.colorSpace instanceof PDPattern)) {
                this.numberOfComponents = this.colorSpace.getNumberOfComponents();
            }
        }
        catch (IOException ex) {
            this.errmsg = ex.getMessage();
        }
        this.initUI();
    }

    private void initUI() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setPreferredSize(new Dimension(300, 500));
        if (this.colorSpace == null) {
            JLabel error = new JLabel(this.errmsg);
            error.setAlignmentX(0.5f);
            error.setFont(new Font("Monospaced", 1, 15));
            this.panel.add(error);
            return;
        }
        JLabel colorSpaceLabel = new JLabel(this.colorSpace.getName() + " colorspace");
        colorSpaceLabel.setAlignmentX(0.5f);
        colorSpaceLabel.setFont(new Font("Monospaced", 1, 30));
        this.panel.add(colorSpaceLabel);
        if (this.numberOfComponents > 0) {
            JLabel colorCountLabel = new JLabel("Component Count: " + this.numberOfComponents);
            colorCountLabel.setAlignmentX(0.5f);
            colorCountLabel.setFont(new Font("Monospaced", 1, 20));
            this.panel.add(colorCountLabel);
        }
    }

    public Component getPanel() {
        return this.panel;
    }
}

