/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.oxford.oed.MakeLemmaList;

public class MakeSortedBody {
    private final TreeMap<String, String> entryMap = new TreeMap(new MakeLemmaList.LemmaComp());
    private static final Pattern SECTION = Pattern.compile("^(\u2020?)((([a-zA-Z0-9]+)\\. ([a-zA-Z0-9]+)\\.([a-zA-Z0-9\\.]*?\\4\\.\\5))|([a-zA-Z0-9\\.]+))");

    private String fixSection(String string) {
        Matcher matcher = SECTION.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(7);
            if (string2 != null) {
                if (!string2.contains(".")) {
                    return string;
                }
                string2 = string2.replaceFirst("([a-zA-Z0-9]+)\\.([a-zA-Z0-9\\.]*?\\1)", "<b>$2</b>");
                return matcher.group(1) + string2 + string.substring(matcher.end());
            }
            return matcher.group(1) + "<b>" + matcher.group(6) + "</b>" + string.substring(matcher.end());
        }
        return string;
    }

    private void addEntry(String string, LinkedList<String> linkedList) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String string2 : linkedList) {
            if (string2.equals(string)) continue;
            String string3 = string2.trim();
            if (string3.isEmpty()) {
                if (stringBuilder.length() <= 0 || bl) continue;
                stringBuilder.append("<br><br>\n");
                bl = true;
                continue;
            }
            string3 = this.fixSection(string3);
            string3 = string3.replaceAll("(\\xa0+)([ac \\xa0\\u2006]*[0-9\\-]+)", "$1<b>$2</b>");
            stringBuilder.append("<p>" + string3 + "</p>\n");
            bl = false;
        }
        this.entryMap.put(string, stringBuilder.toString());
    }

    private void loadFile(File file) throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        boolean bl = false;
        String string2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.equals("======")) {
                bl = false;
                if (!this.entryMap.containsKey(string2)) {
                    this.addEntry(string2, linkedList);
                }
                linkedList.clear();
                continue;
            }
            linkedList.add(string);
            if (bl || string.startsWith("Draft entry ") || string.startsWith("Additions ") || string.isEmpty()) continue;
            bl = true;
            string2 = string;
        }
        bufferedReader.close();
    }

    private void loadDir(String string) throws Exception {
        System.err.println("check " + string);
        for (int i = 0; i < 50; ++i) {
            File file = new File(string, "oed-" + i + ".txt");
            if (!file.exists()) continue;
            this.loadFile(file);
        }
    }

    private void output() {
        System.err.println(this.entryMap.size() + " entries");
        System.out.println("<html><body>");
        for (Map.Entry<String, String> entry : this.entryMap.entrySet()) {
            System.out.print("<dt>");
            System.out.print(entry.getKey());
            System.out.println("</dt><dd>");
            System.out.print(entry.getValue());
            System.out.println("</dd>");
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] stringArray) throws Exception {
        MakeSortedBody makeSortedBody = new MakeSortedBody();
        if (stringArray.length == 0) {
            File file = new File("data");
            for (String string : file.list()) {
                makeSortedBody.loadDir("data/" + string);
            }
        } else {
            makeSortedBody.loadDir(stringArray[0]);
        }
        makeSortedBody.output();
    }
}

