/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class UTF8toSJIS {
    private static final TreeSet<Character> extChSet = new TreeSet();
    private static final HashMap<Integer, String> extFixMap = new HashMap();
    private static final HashSet<Character> sjisOkSet;
    private static final Pattern HEX;
    private static final String UNICODE_REGEXP = "unicode=\"#x([^\"]*)\"";
    private static final Pattern convpat;
    private HashSet<Integer> gaijiUniSet = new HashSet();

    static {
        UTF8toSJIS.addExtFix('\u2776', UTF8toSJIS.kuromarunum(1));
        UTF8toSJIS.addExtFix('\u2777', UTF8toSJIS.kuromarunum(2));
        UTF8toSJIS.addExtFix('\u2778', UTF8toSJIS.kuromarunum(3));
        UTF8toSJIS.addExtFix('\u2779', UTF8toSJIS.kuromarunum(4));
        UTF8toSJIS.addExtFix('\u277a', UTF8toSJIS.kuromarunum(5));
        UTF8toSJIS.addExtFix('\u277b', UTF8toSJIS.kuromarunum(6));
        UTF8toSJIS.addExtFix('\u277c', UTF8toSJIS.kuromarunum(7));
        UTF8toSJIS.addExtFix('\u277d', UTF8toSJIS.kuromarunum(8));
        UTF8toSJIS.addExtFix('\u277e', UTF8toSJIS.kuromarunum(9));
        UTF8toSJIS.addExtFix('\u277f', UTF8toSJIS.kuromarunum(10));
        UTF8toSJIS.addExtFix('\u278a', UTF8toSJIS.kuromarunum(1));
        UTF8toSJIS.addExtFix('\u278b', UTF8toSJIS.kuromarunum(2));
        UTF8toSJIS.addExtFix('\u278c', UTF8toSJIS.kuromarunum(3));
        UTF8toSJIS.addExtFix('\u278d', UTF8toSJIS.kuromarunum(4));
        UTF8toSJIS.addExtFix('\u278e', UTF8toSJIS.kuromarunum(5));
        UTF8toSJIS.addExtFix('\u278f', UTF8toSJIS.kuromarunum(6));
        UTF8toSJIS.addExtFix('\u2790', UTF8toSJIS.kuromarunum(7));
        UTF8toSJIS.addExtFix('\u2791', UTF8toSJIS.kuromarunum(8));
        UTF8toSJIS.addExtFix('\u2792', UTF8toSJIS.kuromarunum(9));
        UTF8toSJIS.addExtFix('\u2793', UTF8toSJIS.kuromarunum(10));
        UTF8toSJIS.addExtFix('\u24eb', UTF8toSJIS.kuromarunum(11));
        UTF8toSJIS.addExtFix('\u24ec', UTF8toSJIS.kuromarunum(12));
        UTF8toSJIS.addExtFix('\u24ed', UTF8toSJIS.kuromarunum(13));
        UTF8toSJIS.addExtFix('\u24ee', UTF8toSJIS.kuromarunum(14));
        UTF8toSJIS.addExtFix('\u24ef', UTF8toSJIS.kuromarunum(15));
        UTF8toSJIS.addExtFix('\u24f0', UTF8toSJIS.kuromarunum(16));
        UTF8toSJIS.addExtFix('\u24f1', UTF8toSJIS.kuromarunum(17));
        UTF8toSJIS.addExtFix('\u24f2', UTF8toSJIS.kuromarunum(18));
        UTF8toSJIS.addExtFix('\u24f3', UTF8toSJIS.kuromarunum(19));
        UTF8toSJIS.addExtFix('\u24f4', UTF8toSJIS.kuromarunum(20));
        UTF8toSJIS.addExtFix('\u2460', UTF8toSJIS.siromarunum(1));
        UTF8toSJIS.addExtFix('\u2461', UTF8toSJIS.siromarunum(2));
        UTF8toSJIS.addExtFix('\u2462', UTF8toSJIS.siromarunum(3));
        UTF8toSJIS.addExtFix('\u2463', UTF8toSJIS.siromarunum(4));
        UTF8toSJIS.addExtFix('\u2464', UTF8toSJIS.siromarunum(5));
        UTF8toSJIS.addExtFix('\u2465', UTF8toSJIS.siromarunum(6));
        UTF8toSJIS.addExtFix('\u2466', UTF8toSJIS.siromarunum(7));
        UTF8toSJIS.addExtFix('\u2467', UTF8toSJIS.siromarunum(8));
        UTF8toSJIS.addExtFix('\u2469', UTF8toSJIS.siromarunum(10));
        UTF8toSJIS.addExtFix('\u246a', UTF8toSJIS.siromarunum(11));
        UTF8toSJIS.addExtFix('\u2471', UTF8toSJIS.siromarunum(18));
        UTF8toSJIS.addExtFix('\u2474', UTF8toSJIS.parnum(1));
        UTF8toSJIS.addExtFix('\u2475', UTF8toSJIS.parnum(2));
        UTF8toSJIS.addExtFix('\u2476', UTF8toSJIS.parnum(3));
        UTF8toSJIS.addExtFix('\u2477', UTF8toSJIS.parnum(4));
        UTF8toSJIS.addExtFix('\u2478', UTF8toSJIS.parnum(5));
        UTF8toSJIS.addExtFix('\u2479', UTF8toSJIS.parnum(6));
        UTF8toSJIS.addExtFix('\u247a', UTF8toSJIS.parnum(7));
        UTF8toSJIS.addExtFixAsHex('\u3016');
        UTF8toSJIS.addExtFixAsHex('\u3017');
        UTF8toSJIS.addExtFixAsHex('\u25b7');
        String okChars = "\u3000\u3001\u3002\uff0c\uff0e\u30fb\uff1a\uff1b\uff1f\uff01\u309b\u309c\u00b4\uff40\u00a8\uff3e\uffe3\uff3f\u30fd\u30fe\u309d\u309e\u3003\u4edd\u3005\u3006\u3007\u30fc\u2015\u2010\uff0f\uff3c\uff5e\u2225\uff5c\u2026\u2025\u2018\u2019\u201c\u201d\uff08\uff09\u3014\u3015\uff3b\uff3d\uff5b\uff5d\u3008\u3009\u300a\u300b\u300c\u300d\u300e\u300f\u3010\u3011\uff0b\uff0d\u00b1\u00d7\u3000\u00f7\uff1d\u2260\uff1c\uff1e\u2266\u2267\u221e\u2234\u2642\u2640\u00b0\u2032\u2033\u2103\uffe5\uff04\uffe0\uffe1\uff05\uff03\uff06\uff0a\uff20\u00a7\u2606\u2605\u25cb\u25cf\u25ce\u25c7\u25c6\u25a1\u25a0\u25b3\u25b2\u25bd\u25bc\u203b\u3012\u2192\u2190\u2191\u2193\u3013\u30fb\u30fb\u30fb\u2208\u220b\u2286\u2287\u2282\u2283\u222a\u2229\u2227\u2228\uffe2\u21d2\u21d4\u2200\u2203\u30fb\u2220\u22a5\u2312\u2202\u2207\u2261\u2252\u226a\u226b\u221a\u223d\u221d\u2235\u222b\u222c\u212b\u2030\u266f\u266d\u266a\u2020\u2021\u00b6\u25ef";
        int i = 0;
        while (i < okChars.length()) {
            UTF8toSJIS.addExtFix(okChars.charAt(i));
            ++i;
        }
        UTF8toSJIS.addExtFix('\u2010');
        UTF8toSJIS.addExtFix('\u2015');
        UTF8toSJIS.addExtFix('\u2501');
        UTF8toSJIS.addExtFixAsHex('\u7006');
        UTF8toSJIS.addExtFix('\uff5f', "\u300a");
        UTF8toSJIS.addExtFix('\uff60', "\u300b");
        sjisOkSet = new HashSet();
        HEX = Pattern.compile("&#(x?)([0-9a-fA-F]+);");
        convpat = Pattern.compile(UNICODE_REGEXP);
    }

    private static void addExtFix(char c, String replace) {
        extFixMap.put(Integer.valueOf(c), replace);
    }

    private static String kuromarunum(int i) {
        return "<b>(" + Integer.toString(i) + ")</b>";
    }

    private static String siromarunum(int i) {
        return Integer.toString(i);
    }

    private static String parnum(int i) {
        return "(" + i + ")";
    }

    static String code2hex(char c) {
        return String.format("&#x%x;", c);
    }

    private static void addExtFixAsHex(char c) {
        UTF8toSJIS.addExtFix(c, UTF8toSJIS.code2hex(c));
    }

    private static void addExtFix(char c) {
        UTF8toSJIS.addExtFix(c, Character.toString(c));
    }

    public static String convert(String line) {
        StringBuffer sb = new StringBuffer(line.length());
        int i = 0;
        while (i < line.length()) {
            int code = line.codePointAt(i);
            String rep = extFixMap.get(code);
            if (rep != null) {
                sb.append(rep);
            } else if (code >= 65280 || 913 <= code && code <= 937 || 945 <= code && code <= 969 && code != 962) {
                sb.append(line.charAt(i));
            } else if (128 <= code && code < 1024 || 1280 <= code && code < 12288 || 57344 <= code) {
                sb.append(String.format("&#x%x;", code));
                extChSet.add(Character.valueOf(line.charAt(i)));
            } else if (code == 12316) {
                sb.append('\uff5e');
            } else {
                char c = line.charAt(i);
                if (sjisOkSet.contains(Character.valueOf(c))) {
                    sb.append(c);
                } else if (extChSet.contains(Character.valueOf(c))) {
                    sb.append(String.format("&#x%x;", code));
                } else {
                    String s = line.substring(i, i + 1);
                    try {
                        byte[] sjis = s.getBytes("Windows-31J");
                        String s2 = new String(sjis, "Windows-31J");
                        if (s.equals(s2)) {
                            sjisOkSet.add(Character.valueOf(c));
                            sb.append(c);
                        } else {
                            extChSet.add(Character.valueOf(c));
                            sb.append(String.format("&#x%x;", code));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        System.err.println(e);
                        System.exit(1);
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String hex2uni(String line) {
        StringBuffer sb = new StringBuffer(line.length());
        Matcher m = HEX.matcher(line);
        int idx = 0;
        while (m.find()) {
            if (idx < m.start()) {
                sb.append(line.substring(idx, m.start()));
            }
            int code = "x".equals(m.group(1)) ? Integer.parseInt(m.group(2), 16) : Integer.parseInt(m.group(2), 10);
            sb.append((char)code);
            idx = m.end();
        }
        if (idx < line.length()) {
            sb.append(line.substring(idx));
        }
        return sb.toString();
    }

    private void output(String line) {
        System.out.println(line);
    }

    private void convert(String[] args) throws Exception {
        String line;
        InputStream in = args.length > 0 && !args[0].equals("-") ? new FileInputStream(new File(args[0])) : System.in;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            this.output(UTF8toSJIS.convert(line));
        }
        br.close();
    }

    private void loadGaijiMap(String file) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(file));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            Matcher m = convpat.matcher(line);
            if (!m.find()) continue;
            int code = Integer.parseInt(m.group(1), 16);
            this.gaijiUniSet.add(code);
        }
        br.close();
    }

    private void checkExtChSet(String[] args) throws Exception {
        String file = "../../ebwin/GaijiMap.xml";
        if (args.length >= 3) {
            file = args[2].equals("arabic") ? "../../ebwin/ArabicGaijiMap.xml" : (args[2].equals("sanskrit") ? "../../ebwin/SanskritGaijiMap.xml" : args[2]);
        }
        this.loadGaijiMap(file);
        Character[] characterArray = extChSet.toArray(new Character[0]);
        int n = characterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character ch = characterArray[n2];
            char code = ch.charValue();
            if (!this.gaijiUniSet.contains(code)) {
                String m = String.format("&#x%04X=%c is not in %s", code, ch, file);
                System.err.println("WARN: " + m);
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        ZephyrUtil.setShiftJisOuput();
        try {
            UTF8toSJIS apl = new UTF8toSJIS();
            apl.convert(args);
            if (args.length >= 2 && args[1].equals("check")) {
                apl.checkExtChSet(args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

