/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.kagakudoujin.kagakueigo2.Util;
import zephyr.util.ZephyrUtil;

public class MakeEJHtml {
    private boolean makeJPkey = false;
    private boolean withWav = false;
    private static final Pattern EN_KEY = Pattern.compile("\\(= *(.+?)\\)");
    private static final String IRREGULARS_TXT = "\u7146\u9239\u70bb";
    private static HashSet<Character> IRREGULARS = new HashSet();
    private int nEntry = 0;

    MakeEJHtml(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.contains("jpenkey")) {
                this.makeJPkey = true;
                continue;
            }
            if (!string.contains("wav")) continue;
            this.withWav = true;
        }
    }

    private String makeENKeys(String string) {
        String string2;
        Matcher matcher = EN_KEY.matcher(string);
        StringBuilder stringBuilder = null;
        while (matcher.find()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if ((string2 = matcher.group(1)).length() == 0) continue;
            stringBuilder.append("<key type=\"\u8868\u8a18\">");
            stringBuilder.append(string2);
            stringBuilder.append("</key>");
        }
        string2 = string.replaceAll("\\[.{1,2}?\\]", "");
        if (!string2.equals(string)) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("<key type=\"\u8868\u8a18\">");
            stringBuilder.append(string2);
            stringBuilder.append("</key>");
        }
        if (stringBuilder == null) {
            return "";
        }
        return stringBuilder.toString();
    }

    private void out(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = Util.dropDot(string);
        stringBuilder.append("<dt title=\"");
        stringBuilder.append(string4);
        stringBuilder.append("\">");
        stringBuilder.append(string);
        stringBuilder.append("</dt>");
        stringBuilder.append(this.makeENKeys(string4));
        if (this.makeJPkey) {
            stringBuilder.append(Util.makeKeys(string2, string4));
        }
        stringBuilder.append("<dd>");
        if (this.withWav && string3.length() > 0) {
            stringBuilder.append("<a href=\"wav/");
            stringBuilder.append(string3);
            stringBuilder.append(".WAV\">\u767a\u97f3</a>");
        }
        stringBuilder.append("<p>");
        stringBuilder.append(string2);
        stringBuilder.append("</p></dd>");
        String string5 = stringBuilder.toString();
        string5 = string5.replace("<FT>", "").replace("</FT>", "");
        System.out.println(string5);
    }

    private String fixJp(String string, String string2) {
        int n;
        if (string.equals("heme i\uff65ron")) {
            string2 = string2.replace("\u0013", "");
        }
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            n = string2.charAt(i);
            if (IRREGULARS.contains(Character.valueOf((char)n))) {
                bl = true;
            }
            if (n >= 32) continue;
            System.err.println();
            System.err.printf("\uff0a\u7570\u5e38\u6587\u5b57\uff1a '%c'=0x%x\n", Character.valueOf((char)n), n);
            System.err.println(string + "\t" + string2);
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < string2.length(); ++n) {
                char c = string2.charAt(n);
                if (IRREGULARS.contains(Character.valueOf(c))) {
                    stringBuilder.append(String.format("&#x%x;", c));
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string2;
    }

    private void loadEIWAFile(File file) throws Exception {
        String string;
        System.err.print(file.getName() + " ");
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        while ((string = bufferedReader.readLine()) != null) {
            ArrayList<String> arrayList = Util.splitTab(string, 6);
            String string2 = arrayList.get(3);
            String string3 = arrayList.get(4);
            String string4 = arrayList.get(5);
            string3 = this.fixJp(string2, string3);
            this.out(string2, string3, string4);
            ++this.nEntry;
        }
        bufferedReader.close();
    }

    private void loadEIWA(File file) throws Exception {
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        System.out.println("<html><body>");
        for (Object object : objectArray) {
            String string = ((String)object).toLowerCase();
            if (!string.startsWith("eiwa_") || !((String)object).endsWith(".txt")) continue;
            this.loadEIWAFile(new File(file, (String)object));
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println(this.nEntry + "\u9805\u76ee");
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "C:\\Program Files\\Kagaku-Dojin\\\u5316\u5b66\u82f1\u8a9e\u306e\u6d3b\u7528\u8f9e\u5178Ver.2\\mst\\txt";
        File file = new File(string);
        if (!file.exists()) {
            System.err.println(string + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (!file.isDirectory()) {
            System.err.println(string + " \u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        System.err.println(file.getAbsolutePath() + " \u304b\u3089\u53d6\u308a\u8fbc\u307f\u307e\u3059");
        ZephyrUtil.setShiftJisOuput();
        MakeEJHtml makeEJHtml = new MakeEJHtml(stringArray);
        makeEJHtml.loadEIWA(file);
    }

    static {
        for (int i = 0; i < IRREGULARS_TXT.length(); ++i) {
            IRREGULARS.add(Character.valueOf(IRREGULARS_TXT.charAt(i)));
        }
    }
}

