/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.MultiHashMap;
import zephyr.util.ZephyrUtil;

public class MakeMorphHtml {
    private final MultiHashMap<String, String> dictIdMap = new MultiHashMap();
    private final HashSet<String> depSet = new HashSet();
    private final MultiHashMap<String, String> bodyIdMap = new MultiHashMap();
    private static final String DT_ID_REGEXP = "<dt id=\"([0-9]+)\">(.+?)</dt>";
    private static final Pattern DT_ID = Pattern.compile("<dt id=\"([0-9]+)\">(.+?)</dt>");
    private static final String DICT_ENT_REGEXP = "<dt id=\"([0-9]+)\">(.+?)\\*</dt>";
    private static final Pattern DICT_ENT = Pattern.compile("<dt id=\"([0-9]+)\">(.+?)\\*</dt>");
    private static final String MORPHKEY_REGEXP = "([a-z123]+)|(<a .+?</a>)";
    private static final Pattern MORPHKEY = Pattern.compile("([a-z123]+)|(<a .+?</a>)");
    private static final HashMap<String, String> morphKeyMap = new HashMap();

    private void loadLajpBody(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = DT_ID.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = ZephyrUtil.hex2uni(matcher.group(2));
            String string4 = ZephyrUtil.makeKey(string3, true);
            this.bodyIdMap.put(string4, matcher.group(1));
        }
        System.err.println("loaded " + this.bodyIdMap.size() + " entries from " + string);
    }

    private void loadWhitackerDict(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "ASCII"));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = DICT_ENT.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = matcher.group(2);
            this.dictIdMap.put(string3, matcher.group(1));
            if (!string2.contains("DEP\"")) continue;
            this.depSet.add(string3);
        }
        System.err.println("loaded " + this.dictIdMap.size() + " entries from " + string);
    }

    private String formatMorphDesc(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Matcher matcher = MORPHKEY.matcher(string);
        boolean bl = false;
        while (matcher.find()) {
            String string2;
            if (n < matcher.start()) {
                string2 = string.substring(n, matcher.start());
                if (!bl || !string2.trim().isEmpty()) {
                    stringBuffer.append(string2);
                }
            }
            if ((string2 = matcher.group(1)) != null) {
                if (string2.equals("part")) {
                    bl = true;
                } else {
                    String string3 = morphKeyMap.get(string2);
                    if (string3 != null) {
                        stringBuffer.append(string3);
                    } else {
                        stringBuffer.append(string2);
                    }
                    if (bl) {
                        stringBuffer.append("\u5206");
                        bl = false;
                    }
                }
            } else {
                stringBuffer.append(matcher.group(2));
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private void outBodyRef(String string) {
        LinkedList linkedList = this.bodyIdMap.getList(string);
        if (linkedList != null) {
            for (String string2 : linkedList) {
                System.out.print(String.format("<a href=\"body-lajp.html#%s\">%s</a> ", string2, string));
            }
        }
    }

    private void findFromBody(String string, char c, char c2) {
        String string2 = string.replace(c, c2);
        if (!string2.equals(string2)) {
            this.outBodyRef(string2);
        }
    }

    private void findFromBody(String string) {
        this.outBodyRef(string);
        if (this.depSet.contains(string)) {
            this.outBodyRef(string + "r");
        }
        this.findFromBody(string, 'i', 'j');
        this.findFromBody(string, 'j', 'i');
        this.findFromBody(string, 'u', 'v');
        this.findFromBody(string, 'v', 'u');
    }

    private void loadMorph(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "ASCII"));
        int n = 0;
        System.err.print("creating morphology file ");
        System.out.println("<html><body>");
        while ((string2 = bufferedReader.readLine()) != null) {
            int n2 = string2.indexOf(44);
            int n3 = string2.indexOf(32, n2 + 1);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1, n3);
            String string5 = string2.substring(n3 + 1);
            System.out.print("<dt>");
            System.out.print(string3);
            System.out.print("</dt><dd>");
            this.findFromBody(string4);
            LinkedList linkedList = this.dictIdMap.getList(string4);
            if (linkedList != null) {
                for (String string6 : linkedList) {
                    System.out.print(String.format("<a href=\"whitaker-dict.html#%s\">%s*</a> ", string6, string4));
                }
            }
            System.out.print(this.formatMorphDesc(string5));
            System.out.println("</dd>");
            if (++n % 100000 == 0) {
                System.err.print(n / 100000);
                continue;
            }
            if (n % 10000 != 0) continue;
            System.err.print(".");
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println("done. " + n + " entries");
    }

    private void makeMorph(String[] stringArray) throws Exception {
        this.loadLajpBody(stringArray[0]);
        this.loadWhitackerDict(stringArray[1]);
        this.loadMorph(stringArray[2]);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 3) {
            MakeMorphHtml makeMorphHtml = new MakeMorphHtml();
            try {
                ZephyrUtil.setShiftJisOuput();
                makeMorphHtml.makeMorph(stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeMorphHtml body-lajp.html whitaker-dict.html whitaker.morph.txt");
        }
    }

    static {
        morphKeyMap.put("noun", "\u540d");
        morphKeyMap.put("pron", "\u4ee3");
        morphKeyMap.put("adj", "\u5f62");
        morphKeyMap.put("num", "\u6570");
        morphKeyMap.put("adv", "\u526f");
        morphKeyMap.put("verb", "\u52d5");
        morphKeyMap.put("part", "\u5206\u8a5e");
        morphKeyMap.put("prep", "\u524d");
        morphKeyMap.put("conj", "\u63a5");
        morphKeyMap.put("inter", "\u611f");
        morphKeyMap.put("m", "\u7537");
        morphKeyMap.put("f", "\u5973");
        morphKeyMap.put("n", "\u4e2d");
        morphKeyMap.put("nom", "\u4e3b");
        morphKeyMap.put("voc", "\u547c");
        morphKeyMap.put("gen", "\u5c5e");
        morphKeyMap.put("dat", "\u4e0e");
        morphKeyMap.put("acc", "\u5bfe");
        morphKeyMap.put("abl", "\u596a");
        morphKeyMap.put("loc", "\u5730");
        morphKeyMap.put("sg", "\u5358");
        morphKeyMap.put("pl", "\u8907");
        morphKeyMap.put("1st", "\uff11");
        morphKeyMap.put("2nd", "\uff12");
        morphKeyMap.put("3rd", "\uff13");
        morphKeyMap.put("comp", "\u6bd4");
        morphKeyMap.put("super", "\u6700");
        morphKeyMap.put("card", "\u57fa\u6570\u8a5e");
        morphKeyMap.put("ord", "\u5e8f\u6570\u8a5e");
        morphKeyMap.put("dist", "\u914d\u5206\u8a5e");
        morphKeyMap.put("adverb", "\u6570\u526f\u8a5e");
        morphKeyMap.put("pres", "\u73fe");
        morphKeyMap.put("impf", "\u672a\u5b8c");
        morphKeyMap.put("fut", "\u672a\u6765");
        morphKeyMap.put("perf", "\u5b8c");
        morphKeyMap.put("plup", "\u904e\u5b8c");
        morphKeyMap.put("futp", "\u672a\u6765\u5b8c");
        morphKeyMap.put("act", "\u80fd");
        morphKeyMap.put("pass", "\u53d7");
        morphKeyMap.put("ind", "\u76f4");
        morphKeyMap.put("sub", "\u63a5");
        morphKeyMap.put("imp", "\u547d");
        morphKeyMap.put("inf", "\u4e0d");
        morphKeyMap.put("part", "\u5206\u8a5e");
    }
}

