/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class UTF8toSJIS {
    private static final TreeSet<Character> extChSet = new TreeSet();
    private static final HashMap<Integer, String> extFixMap = new HashMap();
    private static final String UNICODE_REGEXP = "unicode=\"#x([^\"]*)\"";
    private static final Pattern convpat;
    private HashSet<Integer> gaijiUniSet = new HashSet();

    static {
        UTF8toSJIS.addExtFix('\u278a', UTF8toSJIS.kuromarunum(1));
        UTF8toSJIS.addExtFix('\u278b', UTF8toSJIS.kuromarunum(2));
        UTF8toSJIS.addExtFix('\u278c', UTF8toSJIS.kuromarunum(3));
        UTF8toSJIS.addExtFix('\u278d', UTF8toSJIS.kuromarunum(4));
        UTF8toSJIS.addExtFix('\u278e', UTF8toSJIS.kuromarunum(5));
        UTF8toSJIS.addExtFix('\u278f', UTF8toSJIS.kuromarunum(6));
        UTF8toSJIS.addExtFix('\u2790', UTF8toSJIS.kuromarunum(7));
        UTF8toSJIS.addExtFix('\u2791', UTF8toSJIS.kuromarunum(8));
        UTF8toSJIS.addExtFix('\u2792', UTF8toSJIS.kuromarunum(9));
        UTF8toSJIS.addExtFix('\u2793', UTF8toSJIS.kuromarunum(10));
        UTF8toSJIS.addExtFix('\u24eb', UTF8toSJIS.kuromarunum(11));
        UTF8toSJIS.addExtFix('\u24ec', UTF8toSJIS.kuromarunum(12));
        UTF8toSJIS.addExtFix('\u24ed', UTF8toSJIS.kuromarunum(13));
        UTF8toSJIS.addExtFix('\u24ee', UTF8toSJIS.kuromarunum(14));
        UTF8toSJIS.addExtFix('\u24ef', UTF8toSJIS.kuromarunum(15));
        UTF8toSJIS.addExtFix('\u24f0', UTF8toSJIS.kuromarunum(16));
        UTF8toSJIS.addExtFix('\u24f1', UTF8toSJIS.kuromarunum(17));
        UTF8toSJIS.addExtFix('\u24f2', UTF8toSJIS.kuromarunum(18));
        UTF8toSJIS.addExtFix('\u24f3', UTF8toSJIS.kuromarunum(19));
        UTF8toSJIS.addExtFix('\u24f4', UTF8toSJIS.kuromarunum(20));
        UTF8toSJIS.addExtFix('\u2460', UTF8toSJIS.siromarunum(1));
        UTF8toSJIS.addExtFix('\u2461', UTF8toSJIS.siromarunum(2));
        UTF8toSJIS.addExtFix('\u2462', UTF8toSJIS.siromarunum(3));
        UTF8toSJIS.addExtFix('\u2463', UTF8toSJIS.siromarunum(4));
        UTF8toSJIS.addExtFix('\u2464', UTF8toSJIS.siromarunum(5));
        UTF8toSJIS.addExtFix('\u2465', UTF8toSJIS.siromarunum(6));
        UTF8toSJIS.addExtFix('\u2466', UTF8toSJIS.siromarunum(7));
        UTF8toSJIS.addExtFix('\u2467', UTF8toSJIS.siromarunum(8));
        UTF8toSJIS.addExtFix('\u2469', UTF8toSJIS.siromarunum(10));
        UTF8toSJIS.addExtFix('\u246a', UTF8toSJIS.siromarunum(11));
        UTF8toSJIS.addExtFix('\u2471', UTF8toSJIS.siromarunum(18));
        UTF8toSJIS.addExtFix('\u2474', UTF8toSJIS.parnum(1));
        UTF8toSJIS.addExtFix('\u2475', UTF8toSJIS.parnum(2));
        UTF8toSJIS.addExtFix('\u2476', UTF8toSJIS.parnum(3));
        UTF8toSJIS.addExtFix('\u2477', UTF8toSJIS.parnum(4));
        UTF8toSJIS.addExtFix('\u2478', UTF8toSJIS.parnum(5));
        UTF8toSJIS.addExtFix('\u2479', UTF8toSJIS.parnum(6));
        UTF8toSJIS.addExtFix('\u247a', UTF8toSJIS.parnum(7));
        UTF8toSJIS.addExtFixAsHex('\u3016');
        UTF8toSJIS.addExtFixAsHex('\u3017');
        UTF8toSJIS.addExtFixAsHex('\u25b7');
        UTF8toSJIS.addExtFix('\u2192');
        UTF8toSJIS.addExtFix('\u2190');
        UTF8toSJIS.addExtFix('\u2191');
        UTF8toSJIS.addExtFix('\u2193');
        UTF8toSJIS.addExtFix('\u21d4');
        UTF8toSJIS.addExtFix('\u21d2');
        UTF8toSJIS.addExtFix('\u2605');
        UTF8toSJIS.addExtFix('\u25b3');
        UTF8toSJIS.addExtFix('\u25bd');
        UTF8toSJIS.addExtFix('\u25c6');
        UTF8toSJIS.addExtFix('\u25bc');
        UTF8toSJIS.addExtFix('\u25c7');
        UTF8toSJIS.addExtFix('\u25cb');
        UTF8toSJIS.addExtFix('\u25cf');
        UTF8toSJIS.addExtFix('\u2640');
        UTF8toSJIS.addExtFix('\u2642');
        UTF8toSJIS.addExtFix('\u266d');
        UTF8toSJIS.addExtFix('\u266f');
        UTF8toSJIS.addExtFix('\u2010');
        UTF8toSJIS.addExtFix('\u2015');
        UTF8toSJIS.addExtFix('\u2501');
        UTF8toSJIS.addExtFix('\u2020');
        UTF8toSJIS.addExtFix('\u2103');
        UTF8toSJIS.addExtFix('\u226a');
        UTF8toSJIS.addExtFix('\uff3b');
        UTF8toSJIS.addExtFix('\uff3d');
        UTF8toSJIS.addExtFix('\u2026');
        UTF8toSJIS.addExtFix('\u221a');
        UTF8toSJIS.addExtFix('\u3010');
        UTF8toSJIS.addExtFix('\u3011');
        convpat = Pattern.compile(UNICODE_REGEXP);
    }

    private static void addExtFix(char c, String replace) {
        extFixMap.put(Integer.valueOf(c), replace);
    }

    private static String kuromarunum(int i) {
        return Integer.toString(i);
    }

    private static String siromarunum(int i) {
        return Integer.toString(i);
    }

    private static String parnum(int i) {
        return "(" + i + ")";
    }

    static String code2hex(char c) {
        return String.format("&#x%x;", c);
    }

    private static void addExtFixAsHex(char c) {
        UTF8toSJIS.addExtFix(c, UTF8toSJIS.code2hex(c));
    }

    private static void addExtFix(char c) {
        UTF8toSJIS.addExtFix(c, Character.toString(c));
    }

    public static String convert(String line) {
        StringBuffer sb = new StringBuffer(line.length());
        int i = 0;
        while (i < line.length()) {
            int code = line.codePointAt(i);
            String rep = extFixMap.get(code);
            if (rep != null) {
                sb.append(rep);
            } else if (code >= 65280 || 913 <= code && code <= 969) {
                sb.append(line.charAt(i));
            } else if (128 <= code && code < 1024 || 1280 <= code && code < 12288 || 57344 <= code) {
                sb.append(String.format("&#x%x;", code));
                extChSet.add(Character.valueOf(line.charAt(i)));
            } else if (code == 12316) {
                sb.append('\uff5e');
            } else {
                sb.append(line.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    private void output(String line) {
        System.out.println(line);
    }

    private void convert(String[] args) throws Exception {
        String line;
        InputStream in = args.length > 0 && !args[0].equals("-") ? new FileInputStream(new File(args[0])) : System.in;
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((line = br.readLine()) != null) {
            this.output(UTF8toSJIS.convert(line));
        }
    }

    private void loadGaijiMap(String file) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(new File(file));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            Matcher m = convpat.matcher(line);
            if (!m.find()) continue;
            int code = Integer.parseInt(m.group(1), 16);
            this.gaijiUniSet.add(code);
        }
    }

    private void checkExtChSet(String[] args) throws Exception {
        String file = "../../ebwin/GaijiMap.xml";
        if (args.length >= 3) {
            file = args[2].equals("arabic") ? "../../ebwin/ArabicGaijiMap.xml" : (args[2].equals("sanskrit") ? "../../ebwin/SanskritGaijiMap.xml" : args[2]);
        }
        this.loadGaijiMap(file);
        Character[] characterArray = extChSet.toArray(new Character[0]);
        int n = characterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character ch = characterArray[n2];
            char code = ch.charValue();
            if (!this.gaijiUniSet.contains(code)) {
                String m = String.format("&#x%04X=%c is not in %s", code, ch, file);
                System.err.println("WARN: " + m);
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        ZephyrUtil.setShiftJisOuput();
        try {
            UTF8toSJIS apl = new UTF8toSJIS();
            apl.convert(args);
            if (args.length >= 2 && args[1].equals("check")) {
                apl.checkExtChSet(args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

