/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanshusha.accessdejp;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.sanshusha.accessdejp.BinaryFile;
import zephyr.sanshusha.accessdejp.Buffer;
import zephyr.sanshusha.accessdejp.Table1;
import zephyr.sanshusha.accessdejp.Table2;
import zephyr.sanshusha.accessdejp.TagDecoder;
import zephyr.sanshusha.accessdejp.Util;
import zephyr.util.ZephyrUtil;

public class DecodeRoboword4 {
    private final TagDecoder tagDecoder = new TagDecoder();
    private static final String SINGLE_REGEXP = "^<b>((<sub>.+?</sub> *)?(.+?))</b>\u3000?";
    private static final Pattern SINGLE = Pattern.compile("^<b>((<sub>.+?</sub> *)?(.+?))</b>\u3000?");
    private static final String LINE_REGEXP = "[^\n]+";
    private static final Pattern LINE = Pattern.compile("[^\n]+");
    private static final String MIDASHI_REGEXP = "(\u2026|\u2026?\uff3b.+?\uff3d)([^\uff3b\u3008]+)";
    private static final Pattern MIDASHI = Pattern.compile("(\u2026|\u2026?\uff3b.+?\uff3d)([^\uff3b\u3008]+)");
    private static final String MORPH_REGEXP = "<p>(.+?)</p>";
    private static final Pattern MORPH = Pattern.compile("<p>(.+?)</p>");
    private final HashMap<String, Integer> dtIdMap = new HashMap();
    private static final String REF_REGEXP = "\uff1c([^\u300c]+?)\u300c";
    private static final Pattern REF = Pattern.compile("\uff1c([^\u300c]+?)\u300c");
    private static final String PART_REGEXP = "\uff08([^\u306e\uff09]+?)\u306e.+?\uff09";
    private static final Pattern PART = Pattern.compile("\uff08([^\u306e\uff09]+?)\u306e.+?\uff09");
    private static final String REL_REGEXP = "\u2190([a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc]+)";
    private static final Pattern REL = Pattern.compile("\u2190([a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc]+)");
    private static final String DEWORD_REGEXP = "([a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\|]+)";
    private static final Pattern DEWORD = Pattern.compile("([a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\|]+)");

    private int decodeByLZ(byte[] inData, int index, int lenoff, int stoff, Buffer outBuf) {
        int length = Table2.decode(Util.sbyte2int(inData[index + 1])) + lenoff;
        int start = Table2.decode(Util.sbyte2int(inData[index + 2])) + stoff;
        int outbase = outBuf.length() - start;
        if (outbase < 0) {
            System.err.println("ignore outbase=" + outbase);
            return 2;
        }
        int i = 0;
        while (i < length) {
            int v = Util.sbyte2int(outBuf.data[outbase + i]);
            outBuf.add((byte)v);
            ++i;
        }
        return 2;
    }

    private int decodeByte(byte[] inData, int index, Buffer outBuf) {
        int unsignedByte = Util.sbyte2int(inData[index]);
        int code = Table1.decode(unsignedByte);
        if (code > 0) {
            outBuf.add((byte)code);
            return 0;
        }
        int skip = 0;
        switch (unsignedByte) {
            case 35: {
                outBuf.add(outBuf.getLeftByte(2, 0));
                break;
            }
            case 61: {
                byte d = outBuf.getLeftByte(1, 0);
                outBuf.add(d);
                outBuf.add(d);
                outBuf.add(d);
                break;
            }
            case 62: {
                outBuf.add(outBuf.getLeftByte(1, 3));
                break;
            }
            case 66: {
                outBuf.add(outBuf.getLeftByte(1, -1));
                break;
            }
            case 72: {
                outBuf.add(outBuf.getLeftByte(1, -3));
                break;
            }
            case 74: {
                byte d = outBuf.getLeftByte(1, 0);
                outBuf.add(d);
                outBuf.add(d);
                break;
            }
            case 163: {
                outBuf.add(outBuf.getLeftByte(1, 0));
                break;
            }
            case 202: {
                outBuf.add(outBuf.getLeftByte(1, 2));
                break;
            }
            case 222: {
                outBuf.add(outBuf.getLeftByte(1, 1));
                break;
            }
            case 226: {
                outBuf.add(outBuf.getLeftByte(1, 0));
                break;
            }
            case 233: {
                outBuf.add(outBuf.getLeftByte(1, -2));
                break;
            }
            case 237: {
                if (Util.sbyte2int(inData[index + 1]) == 202) {
                    outBuf.add((byte)10);
                    skip = 1;
                    break;
                }
                outBuf.deleteLast();
                break;
            }
            case 41: {
                skip = this.decodeByLZ(inData, index, 0, -1, outBuf);
                break;
            }
            case 111: {
                skip = this.decodeByLZ(inData, index, 0, -2, outBuf);
                break;
            }
            case 120: {
                skip = this.decodeByLZ(inData, index, 0, 0, outBuf);
                break;
            }
            case 235: {
                skip = this.decodeByLZ(inData, index, 1, 0, outBuf);
                break;
            }
            case 224: 
            case 225: {
                outBuf.add(inData[index]);
                break;
            }
            case 37: 
            case 38: 
            case 50: 
            case 57: 
            case 166: 
            case 177: 
            case 203: 
            case 241: {
                outBuf.add(inData[index]);
                break;
            }
            default: {
                System.err.println("unknown byte: " + String.format("0x%X=%d", unsignedByte, unsignedByte));
            }
        }
        return skip;
    }

    private void decode(byte[] inData, int datalen, Buffer outBuf) {
        int i = 0;
        while (i < datalen) {
            int nSkip = this.decodeByte(inData, i, outBuf);
            if (nSkip > 0) {
                i += nSkip;
            }
            ++i;
        }
    }

    private int parseHeader(BinaryFile bin) throws Exception {
        bin.skip(896);
        int bodyAddress = bin.readInt();
        bin.skip(20);
        int indexAddress = bin.readInt();
        int nSkip = bodyAddress - 924;
        if (nSkip > 0) {
            bin.skip(nSkip);
        }
        return indexAddress - bodyAddress;
    }

    private String makeHyokiKey(String key) {
        return "<key type=\"\u8868\u8a18\">" + key + "</key>";
    }

    private String makeKey(String key) {
        return this.makeHyokiKey(key);
    }

    private String fixMorphTable(String txt) {
        String TABLE_START = "<p>\u25c6\u6d3b\u7528\u8868<SUBSECTION/></p>";
        String TABLE_END = "<SECTION/></p>";
        int idx = txt.indexOf("<p>\u25c6\u6d3b\u7528\u8868<SUBSECTION/></p>");
        if (idx < 0) {
            return txt;
        }
        int idx2 = txt.indexOf("<SECTION/></p>", idx += "<p>\u25c6\u6d3b\u7528\u8868<SUBSECTION/></p>".length());
        if (idx2 < 0) {
            return txt;
        }
        idx2 += "<SECTION/></p>".length();
        StringBuffer sb = new StringBuffer();
        sb.append(txt.substring(0, idx));
        sb.append("<indent val=\"2\"><p>");
        String tabletxt = txt.substring(idx, idx2);
        Matcher m = MORPH.matcher(tabletxt);
        boolean bFirst = true;
        int k = 0;
        int nent = 0;
        int indent = 2;
        while (m.find()) {
            String column = m.group(1);
            if (bFirst) {
                bFirst = false;
            } else if (column.startsWith("\uff08")) {
                if (indent == 2) {
                    sb.append("</p><p>");
                } else {
                    sb.append("</p><indent val=\"2\"><p>");
                    indent = 2;
                }
                nent = 0;
            } else if (column.startsWith("\u00b7")) {
                sb.append("</p><indent val=\"3\"><p>");
                indent = 3;
                nent = 0;
                column = "\u30fb" + column.substring(1);
            } else {
                ++nent;
            }
            if (nent >= 2) {
                sb.append(" / ");
            }
            sb.append(column);
            if (nent == 0) {
                sb.append(" ");
            }
            k = m.end();
        }
        if (k < tabletxt.length()) {
            sb.append(tabletxt.substring(k));
        }
        sb.append("</p>");
        sb.append("<indent val=\"1\">");
        sb.append(txt.substring(idx2));
        return sb.toString();
    }

    private String fixMarks(String line) {
        String[][] replaces = new String[][]{{"\u2019", "'"}, {"\uff08\uff08", "\u300a"}, {"\uff09\uff09", "\u300b"}, {"\u300a\u82f1\uff09", "\uff08\u82f1 "}, {"\u2026", "\uff65\uff65\uff65"}, {"\ufffd", "\uff65"}, {"/\uff08", " / \uff08"}};
        String[][] regReplaces = new String[][]{{"([\\.,;:!])([^ \\.])", "$1 $2"}};
        return ZephyrUtil.sed(line, replaces, regReplaces);
    }

    private void addDtId(String dt, int idx) {
        String dt3;
        if (dt.endsWith("*")) {
            dt = dt.substring(0, dt.length() - 1);
        } else if (dt.endsWith("\uff08*\uff09")) {
            dt = dt.substring(0, dt.length() - 3);
        } else if (dt.startsWith("<sub>")) {
            int i = dt.indexOf("</sub>");
            dt = dt.substring(i + 6).trim();
        }
        this.dtIdMap.put(dt, idx);
        String dt2 = dt.replace("\u00b7", "");
        if (!dt2.equals(dt)) {
            this.dtIdMap.put(dt2, idx);
        }
        if (!(dt3 = dt2.replace("|", "")).equals(dt2)) {
            this.dtIdMap.put(dt3, idx);
        }
    }

    private int getDtId(String word) {
        Integer idx = this.dtIdMap.get(word);
        if (idx != null) {
            return idx;
        }
        String word2 = word.replace("|", "");
        if (!word2.equals(word) && (idx = this.dtIdMap.get(word2)) != null) {
            return idx;
        }
        return -1;
    }

    private String htmlFormat(String line, int idx, boolean isdejp) {
        Matcher m = SINGLE.matcher(line);
        if (!m.find()) {
            return line;
        }
        String dt = m.group(1);
        String dd = line.substring(m.end());
        String key = "";
        if (m.group(2) != null) {
            key = String.valueOf(key) + this.makeKey(m.group(3));
        }
        if ((m = MIDASHI.matcher(dt)).find()) {
            key = String.valueOf(key) + this.makeKey(m.group(2));
        }
        line = "<dt id=\"" + idx + "\">" + dt + "</dt>" + key + "<dd>";
        this.addDtId(dt, idx);
        dd = this.fixMarks(dd);
        m = LINE.matcher(dd);
        int indent = 1;
        while (m.find()) {
            String txt = m.group();
            if (isdejp) {
                char c = Character.toLowerCase(txt.charAt(0));
                if ('a' <= c && c <= 'z' || txt.startsWith("<i>") || txt.startsWith("\u25b7")) {
                    if (indent != 2) {
                        line = String.valueOf(line) + "<indent val=\"2\">";
                        indent = 2;
                    }
                } else if (indent != 1) {
                    line = String.valueOf(line) + "<indent val=\"1\">";
                    indent = 1;
                }
            }
            line = String.valueOf(line) + "<p>" + txt + "</p>";
        }
        line = this.fixMorphTable(line);
        return String.valueOf(line) + "</dd>";
    }

    private String addHref(String line, Pattern p) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Matcher m = p.matcher(line);
        while (m.find()) {
            String key = m.group(1);
            int idx = this.getDtId(key);
            if (idx < 0) continue;
            sb.append(line.substring(i, m.start(1)));
            sb.append(String.format("<a href=\"#%d\">%s</a>", idx, key));
            i = m.end(1);
        }
        if (i == 0) {
            return line;
        }
        if (i < line.length()) {
            sb.append(line.substring(i));
        }
        return sb.toString();
    }

    private String addRef(String line) {
        line = this.addHref(line, REF);
        line = this.addHref(line, PART);
        line = this.addHref(line, REL);
        String KANREN_START = "\u25c6\u95a2\u9023\u8a9e<SUBSECTION/></p><indent val=\"2\"><p>";
        int idx = line.indexOf("\u25c6\u95a2\u9023\u8a9e<SUBSECTION/></p><indent val=\"2\"><p>");
        if (idx > 0) {
            int idx2 = line.indexOf("</p>", idx += "\u25c6\u95a2\u9023\u8a9e<SUBSECTION/></p><indent val=\"2\"><p>".length());
            String sub = this.addHref(line.substring(idx, idx2), DEWORD);
            line = String.valueOf(line.substring(0, idx)) + sub + line.substring(idx2);
        }
        return line;
    }

    private String dropTags(String line) {
        String[][] replaces = new String[][]{{"<SECTION/>", ""}, {"<SUBSECTION/>", ""}, {"<WAKU_START/>", ""}, {"<WAKU_END/>", ""}, {"<p></p>", ""}, {"<b></b>", ""}};
        return ZephyrUtil.sed(line, replaces, null);
    }

    private void loadDic(String inFile) throws Exception {
        BinaryFile bin = new BinaryFile(inFile);
        byte[] inData = new byte[32768];
        Buffer outBuf = new Buffer();
        boolean isdejp = inFile.endsWith("sansygj.dic");
        int remain = this.parseHeader(bin);
        int idx = 0;
        LinkedList<String> bodyTxt = new LinkedList<String>();
        while (remain > 0) {
            bin.skip(1);
            int indexVol = bin.readInt();
            bin.skip(12);
            if (indexVol <= 0 || indexVol > inData.length) {
                System.err.println("indexVol=" + indexVol);
                break;
            }
            bin.read(inData, indexVol);
            remain -= 17 + indexVol;
            this.decode(inData, indexVol, outBuf);
            String line = this.tagDecoder.decode(outBuf.data, outBuf.length());
            outBuf.clear();
            bodyTxt.add(this.htmlFormat(line, idx, isdejp));
            if (++idx % 1000 != 0) continue;
            System.err.print(".");
        }
        System.out.println("<html><body>");
        for (String line : bodyTxt) {
            System.out.println(this.dropTags(this.addRef(line)));
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println("done. " + idx + " entries");
        TagDecoder.dumpUnknown();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            DecodeRoboword4 app = new DecodeRoboword4();
            try {
                ZephyrUtil.setUTF8Ouput();
                app.loadDic(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java EncodeRoboWord4 SOME_DIR/robo4_file.dic");
        }
    }
}

