/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanshusha.accessdejp;

import java.io.UnsupportedEncodingException;
import zephyr.sanshusha.accessdejp.Util;

class Buffer {
    final byte[] data;
    private int len = 0;
    static final int BUFSIZE = 32768;

    Buffer() {
        this(32768);
    }

    Buffer(int bufsize) {
        this.data = new byte[bufsize];
    }

    void add(byte b) {
        this.data[this.len] = b;
        ++this.len;
    }

    void add(String txt) {
        byte[] bytes;
        byte[] byArray = bytes = txt.getBytes();
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.add(b);
            ++n2;
        }
    }

    void deleteLast() {
        if (this.len > 0) {
            --this.len;
        }
    }

    byte getLeftByte(int off, int val) {
        byte b = this.data[this.len - off];
        return (byte)(Util.sbyte2int(b) + val);
    }

    int length() {
        return this.len;
    }

    void clear() {
        this.len = 0;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bShiftJIS) {
        try {
            String code = bShiftJIS ? "Windows-31J" : "UTF-8";
            return new String(this.data, 0, this.len, code);
        }
        catch (UnsupportedEncodingException e) {
            return this.data.toString();
        }
    }
}

