<?php
class RBRank_stagetime extends RBRank_times{
	var $retire_list = array();
	var $notime_list = array();
	var $retire_msec = 0;
	var $retire_mode = 0;
	var $retire_param = array();
	var $ulist = array();
	var $runner = 0;
	var $complete = 0;
	
	function SetUserlist($arr)	{
		$this->ulist = $arr;
	}
	
	function setRetireParam($mode,$param)	{
		$this->retire_mode = $mode;
		$this->retire_param = $param;
		return TRUE;
	}
	
	function setRetireTime($msec)	{
		$this->retire_msec = $msec;
		return TRUE;
	}
	
	function Retire($uid,$per)	{
		$this->retire_list[$uid] = (int) $per;
		return $this->retire_msec;
	}
	
	function NoTime($uid)	{
		$this->notime_list[$uid] = 1;
		return $this->retire_msec;
	}
	
	function finalize(&$userclass)	{ //override
		$pre = 0;
		$rank = 0;
		
		foreach($this->times as $uid=>$time)	{
			$rank++;
			
			if(isset($this->retire_list[$uid]))	{
				$status = 2;
				$per = $this->retire_list[$uid];
				$this->runner++;
				$userclass->retire($uid);
			} elseif(isset($this->notime_list[$uid])) {
				$status = 3;
				$per = 0;
			} else {
				$status = 1;
				$per = 100;
				$this->runner++;
				$this->complete++;
			}
			
			if($pre == 0 and $rank == 1)	{
				$userclass->toptime($uid);
				$toptime = $time;
				$this->times[$uid] = array($rank,$time,0,$this->msto($time),"--:--:--.--",$status,$per,"--:--:--.--",$userclass->getToptime($uid),$userclass->getRetire($uid));
			} else {
				$this->times[$uid] = array($rank,$time,$time-$pre,$this->msto($time),"+".$this->msto($time-$pre),$status,$per,"+".$this->msto($time-$toptime),$userclass->getToptime($uid),$userclass->getRetire($uid));
			}
			$pre = $time;
		}
	}
	
	function retireAdd()	{
		arsort($this->retire_list);
		foreach($this->retire_list as $uid=>$per)	{
			$this->times[$uid] = $this->retire_msec;
		}
	}
	
	function notimeAdd()	{
		foreach($this->notime_list as $uid=>$val)	{
			$this->times[$uid] = $this->retire_msec;
		}
	}
	
	function adjust()	{
		asort($this->times);
		
		$this->calcRetire();
		
		foreach($this->ulist as $uid=>$name)	{
			if(!isset($this->times[$uid]))	{
				$this->NoTime($uid);
			}
		}
		
		$this->retireAdd();
		$this->notimeAdd();
		return TRUE;
	}
	
	function calcRetire()	{
		switch ($this->retire_mode) {
		case 0: //̾ڥʥ
			$this->setRetireTime($this->retire_param[0]*1000);
			break;
		case 1:
			end($this->times);
			list($uid,$time) = each($this->times);
			$this->setRetireTime(($this->retire_param[0]*1000)+$time);
			break;
		case 2:
			end($this->times);
			list($uid,$time) = each($this->times);
			$this->setRetireTime((($this->retire_param[0]/100)*($time))+$time);
			break;
		case 3:
			reset($this->times);
			list($uid,$time) = each($this->times);
			$this->setRetireTime(($this->retire_param[0]*1000)+$time);
			break;
		case 4:
			reset($this->times);
			list($uid,$time) = each($this->times);
			$this->setRetireTime((($this->retire_param[0]/100)*($time))+$time);
			break;
		}
	}
}
?>