using System;
using NUnit.Framework;
using PrivateNUnitCore;
using System.Reflection;
namespace Test.PrivateNUnitCore
{
	[TestFixture]
	public class TestCaseGeneratorTest
	{

		

		[Test]
		public void GenerateTest()
		{
			TestCaseGenerator objToTest = new TestCaseGenerator();
			System.String result = objToTest.Generate();
		}

		[Test]
		public void GenerateMethodHeaderTest()
		{
			TestCaseGenerator objToTest = new TestCaseGenerator();
			MethodInfo method = objToTest.GetType().GetMethod("GenerateMethodHeader",BindingFlags.Instance | BindingFlags.Static | BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.DeclaredOnly);
			object[] args = {};
			object result = method.Invoke(objToTest,args);
		}

		[Test]
		public void GenerateMethodFooterTest()
		{
			TestCaseGenerator objToTest = new TestCaseGenerator();
			MethodInfo method = objToTest.GetType().GetMethod("GenerateMethodFooter",BindingFlags.Instance | BindingFlags.Static | BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.DeclaredOnly);
			object[] args = {};
			object result = method.Invoke(objToTest,args);
		}

		[Test]
		public void GeneratePublicStaticTest()
		{
			TestCaseGenerator objToTest = new TestCaseGenerator();
			MethodInfo method = objToTest.GetType().GetMethod("GeneratePublicStatic",BindingFlags.Instance | BindingFlags.Static | BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.DeclaredOnly);
			System.Reflection.MethodInfo method = null;
			object[] args = {method};
			object result = method.Invoke(objToTest,args);
		}

		[Test]
		public void GenerateNonPublicStaticTest()
		{
			TestCaseGenerator objToTest = new TestCaseGenerator();
			MethodInfo method = objToTest.GetType().GetMethod("GenerateNonPublicStatic",BindingFlags.Instance | BindingFlags.Static | BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.DeclaredOnly);
			System.Reflection.MethodInfo method = null;
			object[] args = {method};
			object result = method.Invoke(objToTest,args);
		}

		[Test]
		public void GeneratePublicInstanceTest()
		{
			TestCaseGenerator objToTest = new TestCaseGenerator();
			MethodInfo method = objToTest.GetType().GetMethod("GeneratePublicInstance",BindingFlags.Instance | BindingFlags.Static | BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.DeclaredOnly);
			System.Reflection.MethodInfo method = null;
			object[] args = {method};
			object result = method.Invoke(objToTest,args);
		}

		[Test]
		public void GenerateNonPublicInstanceTest()
		{
			TestCaseGenerator objToTest = new TestCaseGenerator();
			MethodInfo method = objToTest.GetType().GetMethod("GenerateNonPublicInstance",BindingFlags.Instance | BindingFlags.Static | BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.DeclaredOnly);
			System.Reflection.MethodInfo method = null;
			object[] args = {method};
			object result = method.Invoke(objToTest,args);
		}

	}
}

