/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.slider;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class SliderTag extends UIComponentELTag {

	private javax.el.ValueExpression _widgetVar;
	private javax.el.ValueExpression _for;
	private javax.el.ValueExpression _minValue;
	private javax.el.ValueExpression _maxValue;
	private javax.el.ValueExpression _thumbImage;
	private javax.el.ValueExpression _tickMarks;
	private javax.el.ValueExpression _size;
	private javax.el.ValueExpression _animate;
	private javax.el.ValueExpression _type;

	public void release(){
		super.release();
		this._widgetVar = null;
		this._for = null;
		this._minValue = null;
		this._maxValue = null;
		this._thumbImage = null;
		this._tickMarks = null;
		this._size = null;
		this._animate = null;
		this._type = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.slider.Slider component = null;
		try {
			component = (org.primefaces.component.slider.Slider) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_widgetVar != null) {
			component.setValueExpression("widgetVar", _widgetVar);
		}
		if(_for != null) {
			component.setValueExpression("for", _for);
		}
		if(_minValue != null) {
			component.setValueExpression("minValue", _minValue);
		}
		if(_maxValue != null) {
			component.setValueExpression("maxValue", _maxValue);
		}
		if(_thumbImage != null) {
			component.setValueExpression("thumbImage", _thumbImage);
		}
		if(_tickMarks != null) {
			component.setValueExpression("tickMarks", _tickMarks);
		}
		if(_size != null) {
			component.setValueExpression("size", _size);
		}
		if(_animate != null) {
			component.setValueExpression("animate", _animate);
		}
		if(_type != null) {
			component.setValueExpression("type", _type);
		}
	}

	public String getComponentType() {
		return Slider.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return "org.primefaces.component.SliderRenderer";
	}

	public void setWidgetVar(javax.el.ValueExpression expression){
		this._widgetVar = expression;
	}

	public void setFor(javax.el.ValueExpression expression){
		this._for = expression;
	}

	public void setMinValue(javax.el.ValueExpression expression){
		this._minValue = expression;
	}

	public void setMaxValue(javax.el.ValueExpression expression){
		this._maxValue = expression;
	}

	public void setThumbImage(javax.el.ValueExpression expression){
		this._thumbImage = expression;
	}

	public void setTickMarks(javax.el.ValueExpression expression){
		this._tickMarks = expression;
	}

	public void setSize(javax.el.ValueExpression expression){
		this._size = expression;
	}

	public void setAnimate(javax.el.ValueExpression expression){
		this._animate = expression;
	}

	public void setType(javax.el.ValueExpression expression){
		this._type = expression;
	}

}