/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.layout;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class LayoutUnit extends UIComponentBase {


	public static final String COMPONENT_TYPE = "org.primefaces.component.LayoutUnit";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.LayoutUnitRenderer";

	private java.lang.String _position;
	private java.lang.String _size;
	private java.lang.Integer _minSize;
	private java.lang.Integer _maxSize;
	private java.lang.Integer _spacingOpen;
	private java.lang.Integer _spacingClosed;
	private java.lang.Boolean _resizable;
	private java.lang.Boolean _closable;
	private java.lang.Boolean _slidable;
	private java.lang.String _style;
	private java.lang.String _styleClass;
	private java.lang.Boolean _closed;
	private java.lang.String _effect;
	private java.lang.String _effectSpeed;
	private java.lang.String _togglerLengthOpen;
	private java.lang.String _togglerLengthClosed;
	private java.lang.String _togglerAlignOpen;
	private java.lang.String _togglerAlignClosed;
	private java.lang.String _togglerTipOpen;
	private java.lang.String _togglerTipClosed;
	private java.lang.String _resizerTip;
	public LayoutUnit() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getPosition() {
		if(_position != null )
			return _position;

		ValueExpression ve = getValueExpression("position");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setPosition(java.lang.String _position) {
		this._position = _position;
	}

	public java.lang.String getSize() {
		if(_size != null )
			return _size;

		ValueExpression ve = getValueExpression("size");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setSize(java.lang.String _size) {
		this._size = _size;
	}

	public int getMinSize() {
		if(_minSize != null )
			return _minSize;

		ValueExpression ve = getValueExpression("minSize");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 50;
	}
	public void setMinSize(int _minSize) {
		this._minSize = _minSize;
	}

	public int getMaxSize() {
		if(_maxSize != null )
			return _maxSize;

		ValueExpression ve = getValueExpression("maxSize");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 0;
	}
	public void setMaxSize(int _maxSize) {
		this._maxSize = _maxSize;
	}

	public int getSpacingOpen() {
		if(_spacingOpen != null )
			return _spacingOpen;

		ValueExpression ve = getValueExpression("spacingOpen");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 6;
	}
	public void setSpacingOpen(int _spacingOpen) {
		this._spacingOpen = _spacingOpen;
	}

	public int getSpacingClosed() {
		if(_spacingClosed != null )
			return _spacingClosed;

		ValueExpression ve = getValueExpression("spacingClosed");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 6;
	}
	public void setSpacingClosed(int _spacingClosed) {
		this._spacingClosed = _spacingClosed;
	}

	public boolean isResizable() {
		if(_resizable != null )
			return _resizable;

		ValueExpression ve = getValueExpression("resizable");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setResizable(boolean _resizable) {
		this._resizable = _resizable;
	}

	public boolean isClosable() {
		if(_closable != null )
			return _closable;

		ValueExpression ve = getValueExpression("closable");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setClosable(boolean _closable) {
		this._closable = _closable;
	}

	public boolean isSlidable() {
		if(_slidable != null )
			return _slidable;

		ValueExpression ve = getValueExpression("slidable");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setSlidable(boolean _slidable) {
		this._slidable = _slidable;
	}

	public java.lang.String getStyle() {
		if(_style != null )
			return _style;

		ValueExpression ve = getValueExpression("style");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyle(java.lang.String _style) {
		this._style = _style;
	}

	public java.lang.String getStyleClass() {
		if(_styleClass != null )
			return _styleClass;

		ValueExpression ve = getValueExpression("styleClass");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyleClass(java.lang.String _styleClass) {
		this._styleClass = _styleClass;
	}

	public boolean isClosed() {
		if(_closed != null )
			return _closed;

		ValueExpression ve = getValueExpression("closed");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setClosed(boolean _closed) {
		this._closed = _closed;
	}

	public java.lang.String getEffect() {
		if(_effect != null )
			return _effect;

		ValueExpression ve = getValueExpression("effect");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setEffect(java.lang.String _effect) {
		this._effect = _effect;
	}

	public java.lang.String getEffectSpeed() {
		if(_effectSpeed != null )
			return _effectSpeed;

		ValueExpression ve = getValueExpression("effectSpeed");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setEffectSpeed(java.lang.String _effectSpeed) {
		this._effectSpeed = _effectSpeed;
	}

	public java.lang.String getTogglerLengthOpen() {
		if(_togglerLengthOpen != null )
			return _togglerLengthOpen;

		ValueExpression ve = getValueExpression("togglerLengthOpen");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTogglerLengthOpen(java.lang.String _togglerLengthOpen) {
		this._togglerLengthOpen = _togglerLengthOpen;
	}

	public java.lang.String getTogglerLengthClosed() {
		if(_togglerLengthClosed != null )
			return _togglerLengthClosed;

		ValueExpression ve = getValueExpression("togglerLengthClosed");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTogglerLengthClosed(java.lang.String _togglerLengthClosed) {
		this._togglerLengthClosed = _togglerLengthClosed;
	}

	public java.lang.String getTogglerAlignOpen() {
		if(_togglerAlignOpen != null )
			return _togglerAlignOpen;

		ValueExpression ve = getValueExpression("togglerAlignOpen");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTogglerAlignOpen(java.lang.String _togglerAlignOpen) {
		this._togglerAlignOpen = _togglerAlignOpen;
	}

	public java.lang.String getTogglerAlignClosed() {
		if(_togglerAlignClosed != null )
			return _togglerAlignClosed;

		ValueExpression ve = getValueExpression("togglerAlignClosed");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTogglerAlignClosed(java.lang.String _togglerAlignClosed) {
		this._togglerAlignClosed = _togglerAlignClosed;
	}

	public java.lang.String getTogglerTipOpen() {
		if(_togglerTipOpen != null )
			return _togglerTipOpen;

		ValueExpression ve = getValueExpression("togglerTipOpen");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTogglerTipOpen(java.lang.String _togglerTipOpen) {
		this._togglerTipOpen = _togglerTipOpen;
	}

	public java.lang.String getTogglerTipClosed() {
		if(_togglerTipClosed != null )
			return _togglerTipClosed;

		ValueExpression ve = getValueExpression("togglerTipClosed");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setTogglerTipClosed(java.lang.String _togglerTipClosed) {
		this._togglerTipClosed = _togglerTipClosed;
	}

	public java.lang.String getResizerTip() {
		if(_resizerTip != null )
			return _resizerTip;

		ValueExpression ve = getValueExpression("resizerTip");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setResizerTip(java.lang.String _resizerTip) {
		this._resizerTip = _resizerTip;
	}


	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[22];
		values[0] = super.saveState(context);
		values[1] = _position;
		values[2] = _size;
		values[3] = _minSize;
		values[4] = _maxSize;
		values[5] = _spacingOpen;
		values[6] = _spacingClosed;
		values[7] = _resizable;
		values[8] = _closable;
		values[9] = _slidable;
		values[10] = _style;
		values[11] = _styleClass;
		values[12] = _closed;
		values[13] = _effect;
		values[14] = _effectSpeed;
		values[15] = _togglerLengthOpen;
		values[16] = _togglerLengthClosed;
		values[17] = _togglerAlignOpen;
		values[18] = _togglerAlignClosed;
		values[19] = _togglerTipOpen;
		values[20] = _togglerTipClosed;
		values[21] = _resizerTip;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_position = (java.lang.String) values[1];
		_size = (java.lang.String) values[2];
		_minSize = (java.lang.Integer) values[3];
		_maxSize = (java.lang.Integer) values[4];
		_spacingOpen = (java.lang.Integer) values[5];
		_spacingClosed = (java.lang.Integer) values[6];
		_resizable = (java.lang.Boolean) values[7];
		_closable = (java.lang.Boolean) values[8];
		_slidable = (java.lang.Boolean) values[9];
		_style = (java.lang.String) values[10];
		_styleClass = (java.lang.String) values[11];
		_closed = (java.lang.Boolean) values[12];
		_effect = (java.lang.String) values[13];
		_effectSpeed = (java.lang.String) values[14];
		_togglerLengthOpen = (java.lang.String) values[15];
		_togglerLengthClosed = (java.lang.String) values[16];
		_togglerAlignOpen = (java.lang.String) values[17];
		_togglerAlignClosed = (java.lang.String) values[18];
		_togglerTipOpen = (java.lang.String) values[19];
		_togglerTipClosed = (java.lang.String) values[20];
		_resizerTip = (java.lang.String) values[21];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}