/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.dnd;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class DraggableTag extends UIComponentELTag {

	private javax.el.ValueExpression _widgetVar;
	private javax.el.ValueExpression _proxy;
	private javax.el.ValueExpression _dragOnly;
	private javax.el.ValueExpression _update;

	public void release(){
		super.release();
		this._widgetVar = null;
		this._proxy = null;
		this._dragOnly = null;
		this._update = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.dnd.Draggable component = null;
		try {
			component = (org.primefaces.component.dnd.Draggable) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_widgetVar != null) {
			component.setValueExpression("widgetVar", _widgetVar);
		}
		if(_proxy != null) {
			component.setValueExpression("proxy", _proxy);
		}
		if(_dragOnly != null) {
			component.setValueExpression("dragOnly", _dragOnly);
		}
		if(_update != null) {
			component.setValueExpression("update", _update);
		}
	}

	public String getComponentType() {
		return Draggable.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return "org.primefaces.component.DraggableRenderer";
	}

	public void setWidgetVar(javax.el.ValueExpression expression){
		this._widgetVar = expression;
	}

	public void setProxy(javax.el.ValueExpression expression){
		this._proxy = expression;
	}

	public void setDragOnly(javax.el.ValueExpression expression){
		this._dragOnly = expression;
	}

	public void setUpdate(javax.el.ValueExpression expression){
		this._update = expression;
	}

}