/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.webapp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class MultipartRequest
extends HttpServletRequestWrapper {
    private static final Logger logger = Logger.getLogger(MultipartRequest.class.getName());
    private Map<String, List<String>> formParams = new LinkedHashMap<String, List<String>>();
    private Map<String, List<FileItem>> fileParams = new LinkedHashMap<String, List<FileItem>>();

    public MultipartRequest(HttpServletRequest request, ServletFileUpload servletFileUpload) throws IOException {
        super(request);
        this.parseRequest(request, servletFileUpload);
    }

    private void parseRequest(HttpServletRequest request, ServletFileUpload servletFileUpload) throws IOException {
        try {
            List fileItems = servletFileUpload.parseRequest(request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) {
                    this.addFormParam(item);
                    continue;
                }
                this.addFileParam(item);
            }
        }
        catch (FileUploadException e) {
            logger.severe("Error in parsing fileupload request");
            throw new IOException(e.getMessage());
        }
    }

    private void addFileParam(FileItem item) {
        if (this.fileParams.containsKey(item.getFieldName())) {
            this.fileParams.get(item.getFieldName()).add(item);
        } else {
            ArrayList<FileItem> items = new ArrayList<FileItem>();
            items.add(item);
            this.fileParams.put(item.getFieldName(), items);
        }
    }

    private void addFormParam(FileItem item) {
        if (this.formParams.containsKey(item.getFieldName())) {
            this.formParams.get(item.getFieldName()).add(item.getString());
        } else {
            ArrayList<String> items = new ArrayList<String>();
            items.add(item.getString());
            this.formParams.put(item.getFieldName(), items);
        }
    }

    public String getParameter(String name) {
        if (this.formParams.containsKey(name)) {
            List<String> values = this.formParams.get(name);
            if (values.isEmpty()) {
                return "";
            }
            return values.get(0);
        }
        return null;
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.formParams);
    }

    public Enumeration getParameterNames() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        paramNames.addAll(this.formParams.keySet());
        paramNames.addAll(this.formParams.keySet());
        return Collections.enumeration(paramNames);
    }

    public String[] getParameterValues(String name) {
        if (this.formParams.containsKey(name)) {
            List<String> values = this.formParams.get(name);
            if (values.isEmpty()) {
                return new String[0];
            }
            return values.toArray(new String[values.size()]);
        }
        return null;
    }

    public FileItem getFileItem(String name) {
        if (this.fileParams.containsKey(name)) {
            List<FileItem> items = this.fileParams.get(name);
            return items.get(0);
        }
        return null;
    }
}

