/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.media;

import java.io.IOException;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.media.Media;
import org.primefaces.component.media.player.MediaPlayer;
import org.primefaces.component.media.player.MediaPlayerFactory;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.HTML;

public class MediaRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Media media = (Media)component;
        MediaPlayer player = this.resolvePlayer(facesContext, media);
        if (AgentUtils.isIE(facesContext)) {
            this.encodeObjectTag(facesContext, media, player);
        } else {
            this.encodeEmbedTag(facesContext, media, player);
        }
    }

    private void encodeObjectTag(FacesContext facesContext, Media media, MediaPlayer player) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String src = this.getMediaSrc(facesContext, media);
        writer.startElement("object", (UIComponent)media);
        writer.writeAttribute("classid", (Object)player.getClassId(), null);
        if (player.getCodebase() != null) {
            writer.writeAttribute("codebase", (Object)player.getCodebase(), null);
        }
        if (media.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)media.getStyleClass(), null);
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)media, HTML.MEDIA_ATTRS);
        this.encodeParam(writer, player.getSourceParam(), src, false);
        for (UIComponent child : media.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            this.encodeParam(writer, param.getName(), param.getValue(), false);
        }
        writer.endElement("object");
    }

    private void encodeEmbedTag(FacesContext facesContext, Media media, MediaPlayer player) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String src = this.getMediaSrc(facesContext, media);
        writer.startElement("embed", (UIComponent)media);
        writer.writeAttribute("pluginspage", (Object)player.getPlugingPage(), null);
        writer.writeAttribute("src", (Object)src, null);
        if (media.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)media.getStyleClass(), null);
        }
        if (player.getType() != null) {
            writer.writeAttribute("type", (Object)player.getType(), null);
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)media, HTML.MEDIA_ATTRS);
        for (UIComponent child : media.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            this.encodeParam(writer, param.getName(), param.getValue(), true);
        }
        writer.endElement("embed");
    }

    private void encodeParam(ResponseWriter writer, String name, Object value, boolean asAttribute) throws IOException {
        if (value == null) {
            return;
        }
        if (asAttribute) {
            writer.writeAttribute(name, value, null);
        } else {
            writer.startElement("param", null);
            writer.writeAttribute("name", (Object)name, null);
            writer.writeAttribute("value", (Object)value.toString(), null);
            writer.endElement("param");
        }
    }

    private MediaPlayer resolvePlayer(FacesContext facesContext, Media media) {
        if (media.getPlayer() != null) {
            return MediaPlayerFactory.getPlayer(media.getPlayer());
        }
        if (media.getValue() instanceof String) {
            Map<String, MediaPlayer> players = MediaPlayerFactory.getPlayers();
            String[] tokens = ((String)media.getValue()).split("\\.");
            String type = tokens[tokens.length - 1];
            for (MediaPlayer mp : players.values()) {
                if (!mp.isAppropriatePlayer(type)) continue;
                return mp;
            }
        }
        throw new IllegalArgumentException("Cannot resolve mediaplayer for media component '" + media.getClientId(facesContext) + "', cannot play source:" + media.getValue());
    }

    private String getMediaSrc(FacesContext facesContext, Media media) {
        Object value = media.getValue();
        if (value == null) {
            return "";
        }
        if (value instanceof StreamedContent) {
            ValueExpression valueVE = media.getValueExpression("value");
            String veString = valueVE.getExpressionString();
            String expressionParamValue = veString.substring(2, veString.length() - 1);
            String url = this.getActionURL(facesContext);
            url = url.contains("?") ? url + "&" : url + "?";
            StringBuilder builder = new StringBuilder(url);
            builder.append("primefacesDynamicContent").append("=").append(expressionParamValue);
            for (UIComponent kid : media.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter param = (UIParameter)kid;
                builder.append("&").append(param.getName()).append("=").append(param.getValue());
            }
            return builder.toString();
        }
        return this.getResourceURL(facesContext, media.getValue().toString());
    }
}

