/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.graphicimage;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.graphicimage.GraphicImage;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

public class GraphicImageRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        GraphicImage image = (GraphicImage)component;
        String clientId = image.getClientId(facesContext);
        writer.startElement("img", (UIComponent)image);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("src", (Object)this.getImageSrc(facesContext, image), null);
        if (image.getAlt() == null) {
            writer.writeAttribute("alt", (Object)"", null);
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)image, HTML.IMG_ATTRS);
        if (image.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)image.getStyleClass(), "styleClass");
        }
        writer.endElement("img");
    }

    private String getImageSrc(FacesContext facesContext, GraphicImage image) {
        Object value = image.getValue();
        if (value == null) {
            return "";
        }
        if (value instanceof StreamedContent) {
            ValueExpression valueVE = image.getValueExpression("value");
            String veString = valueVE.getExpressionString();
            String expressionParamValue = veString.substring(2, veString.length() - 1);
            String url = this.getActionURL(facesContext);
            url = url.contains("?") ? url + "&" : url + "?";
            StringBuilder builder = new StringBuilder(url);
            builder.append("primefacesDynamicContent").append("=").append(expressionParamValue);
            for (UIComponent kid : image.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter param = (UIParameter)kid;
                builder.append("&").append(param.getName()).append("=").append(param.getValue());
            }
            return builder.toString();
        }
        return this.getResourceURL(facesContext, value.toString());
    }
}

