/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.filedownload;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.model.StreamedContent;

public class FileDownloadActionListener
implements ActionListener,
StateHolder {
    private ValueExpression value;

    public FileDownloadActionListener() {
    }

    public FileDownloadActionListener(ValueExpression value) {
        this.value = value;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        StreamedContent content = (StreamedContent)this.value.getValue(elContext);
        try {
            int length;
            response.setContentType(content.getContentType());
            response.setHeader("Content-disposition", "attachment;filename=" + content.getName());
            byte[] buffer = new byte[2048];
            while ((length = content.getStream().read(buffer)) >= 0) {
                response.getOutputStream().write(buffer, 0, length);
            }
            response.setStatus(200);
            content.getStream().close();
            response.getOutputStream().flush();
            facesContext.responseComplete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.value = (ValueExpression)values[0];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.value};
        return values;
    }

    public void setTransient(boolean value) {
    }
}

