# prime/engine/engine.rb
# $Id: engine.rb,v 1.1.1.1.2.3 2004/01/11 23:11:46 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

$engine_class_name = 'PrimeEngine'

require 'prime/taiyaki'

class PrimeEngine
  include Debug
  attr_reader :name, :id, :description, :status

  def initialize
    @debug_mode = false
    
    @name = "vanilla engine"
    @id   = "vanilla"
    @description = "skeleton engine"
  end

  def lookup_prefix (input)
    return lookup(input, :prefix) # return PrimeResult
  end

  def lookup_exact (input)
    return lookup(input, :exact)  # return PrimeResult
  end

  def lookup_expansion (input)
    ## FIXME: Change flamework of the conversion system and
    ## FIXME: merge this method to lookup.
    ## FIXME: <komatsu@taiyaki.org> (2004-01-10)
    return PrimeResult.new()
  end

  def lookup_mixed (input)
    ## FIXME: Change flamework of the conversion system and
    ## FIXME: merge this method to lookup.
    ## FIXME: <komatsu@taiyaki.org> (2004-01-11)
    return PrimeResult.new()
  end

  def learn_word (key, value, part = nil,
		  context = nil, suffix = nil, rest = nil)
    # return true if word was learned, or return false.
    return false 
  end

  ## init
  # initialize this engine.  init should be called only once first.
  def init
    return true # or false
  end

  ## exit
  # finalize this engine.  exit should be called only once last.
  def exit
    return true # or false
  end

  ## open
  # open a connection with this engine.
  def open
    return true # or false
  end

  ## close
  # close the connection with this engine.
  def close
    return true # of false
  end

  ## refresh
  # refresh the statuses of the conversion engines.
  def refresh
    return true
  end

  private
  def lookup (input, method = :prefix)
    # return PrimeResult
    return PrimeResult.new()
  end
end

class PrimeCandidate
  attr_accessor :key, :value, :priority,
    :part, :base, :basekey, :conjugation, :suffix

  def initialize (basekey  = nil, base   = nil, priority = nil,
		  part     = nil, suffix = nil, rest = nil)
    @key      	 = [basekey, suffix, rest].join
    @value    	 = [base,    suffix, rest].join
    @priority    = priority
    @part     	 = part
    @base     	 = base
    @basekey  	 = basekey
    @conjugation = suffix # $B8l$NE}0l$r$7$h$&(B 
    @suffix      = rest   # $B8l$NE}0l$r$7$h$&(B 
  end

  def join
    [key, value,
      ("priority=#{priority}" if priority),
      ("part=#{part}" if part),
      ("base=#{base}" if base),
      ("basekey=#{basekey}" if basekey),
      ("conjugation=#{conjugation}" if conjugation),
      ("suffix=#{suffix}" if suffix)
    ].compact.join("\t")
  end
end

class PrimeResult < Array
  def PrimeResult::merge (*results)
    ## merge should be sorted by inter-engine frequency.
    result = results.flatten.compact.sort {|a, b| 
      b.priority <=> a.priority
    }

    mark = {}
    merged = PrimeResult.new
    result.each {|word|
      unless mark[word.value] then
	mark[word.value] = true
	merged.push(word)
      end
    }
    return merged
  end

  def values
    values = self.map {|cand|
      cand.value
    }
    return values
  end

  def to_text
    texts = self.map {|cand|
      cand.join
    }
    return texts.join("\n")
  end
end
