# prime/engine/engine-basic-multiclauses.rb:
#     Basic Engine with a Function for Multiple Clauses
# $Id: engine-basic-multiclauses.rb,v 1.1.2.5 2004/01/02 04:23:07 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine-basic'

$engine_class_name = 'PrimeEngineBasicMultipleClauses'

class PrimeEngineBasicMultipleClauses < PrimeEngineBasic
  def initialize
    super

    @name = "Basic Engine with a Function for Multiple Clauses"
    @id   = "basic-mc"
    @description = "Basic Engine with Multi-clauses"

    ## FIXME: ե
    ## FIXME: <komatsu@taiyaki.org> (2003-12-24)
    @pos_alias = {
      'ư::Ϣi' => ['Ը::Ϣi', 'Ը::Ϣi',
	'Ը::Ϣi', 'Ը::Ϣi', 'ʹԸ::Ϣi', 
	'йԸ::Ϣi', '޹Ը::Ϣi', 'Ը::Ϣi',
	'Ը::Ϣi', '(Ԥ)::Ϣi',
	'', 'ư::Ϣi'],
      'ư' => ['Ը', 'Ը', 'Ը', 'Ը', 'ʹԸ', 
	'йԸ', '޹Ը', 'Ը', 'Ը', '(Ԥ)',
	'', 'ư'],
      '' => ['ʽ֤ˡ', 'ʽ֤ǡ', 'ʽ֤',
	'ʽ֤Ρ', 'ʽ֤', '֤ϡ']
    }

    @pos_alias_reverse = {}
    @pos_alias.each{|key, values|
      values.each{|value|
	if @pos_alias_reverse[value] then
	  @pos_alias_reverse[value] << key
	else
	  @pos_alias_reverse[value] = [key]
	end
      }
    }

    @pos_connection_table = {
      'Ƭ' => ['̾', '()&̾'],
      '̾'   => ['', 'ư첽', '̾', '()&̾'],
      '()&̾' =>
                  ['', 'ư첽', '̾', '()&̾'],

      '̾&̾'   => ['', 'ư첽'],
      '̾'        => ['', 'ư첽'],
      '̾'        => ['', 'ư첽'],

      'ư::Ϣi' => ['ư'],
      '' => ['ƻ', 'ư', 'ư&̾', 'ư'],
      'ƻ::Ϣ'   => ['̾', '̾&̾', '̾', '̾'],
      'ƻ::Ϣku' => ['ƻ'],
      'ư::Ϣ' => ['̾', '̾&̾', '̾', '̾'],
      'ư' => ['̾', '̾&̾', '̾', '̾'],

      '֤::Ϣde' => ['ư'],
      '' => ['̾', '̾&̾', '̾', '̾', 'ư', 'ư&̾'],
    }
    @pos_connection_cost = {
#      "Ƭ\t̾" => 0.8,
#      "Ƭ\t()&̾" => 0.8,
#      "̾\t" => 0.8,
      "̾&̾\t=" => 0.99,
      "̾\t="      => 0.99,
      "=\t̾" => 0.99,
      "=\t̾" => 0.99,
      "=\t̾" => 0.99,
      "=ɤ\t̾" => 0.99,
    }
    @pos_connection_cost_default = 0.8
    @pos_connection_pos = {
#      "Ƭ\t̾" => '̾',
#      "Ƭ\t()&̾" => '()&̾',
      "̾\t" => '̾',
      "̾\tư첽" => 'ư',
      "̾&̾\t" => '̾',
      "̾&̾\tư첽" => 'ư',
      "̾\t" => '̾',
      "̾\tư첽" => 'ư',
      "̾\t" => '̾',
      "̾\tư첽" => 'ư',
    }      
  end

  def lookup (input, method = :prefix)
    results = super
    clauses_list = process_clauses(input.base)

    clauses_list.each {|clause, *clauses|
      (base1, pos1, suffix1, suffix1_pos) = clause
      results1 = lookup_dict([format("%s\t%s", base1, pos1)])

      results1.each {|result1|
	(pron1, literal1, priority1, pos1) = parse_result(result1)
	if clauses.nil? or clauses.empty? then
	  # Do nothing.
#	  cand = PrimeCandidate.new(pron1, literal1, priority1, pos1, suffix1)
#	  results << cand
	else
	  pron = pron1
	  literal = literal1
	  pos = pos1
	  rest = ""
	  cost = 1
	  priority = priority1
	  suffix = ""
	  prev_suffix = suffix1
	  clauses.each {|clause2|
	    (base2, pos2, suffix2, suffix_pos2) = clause2
	    if pos2 then
	      suffix = suffix2

              key = format("%s\t%s", base2, pos2)
	      result2 = lookup_dict([key])
	      (pron2, literal2, priority2, pos2) = parse_result(result2[0])

	      connection_key = [pos, pos2].join("\t")

	      cost = get_connection_cost(pos, literal, pos2, literal2)
	      pron    += (prev_suffix + pron2)
	      literal += (prev_suffix + literal2)
	      priority = (Math::sqrt(priority * priority2) * cost).to_i
	      pos = (@pos_connection_pos[connection_key] or pos2)

	      prev_suffix = suffix
	    else
	      pron    += prev_suffix
	      literal += prev_suffix
	      suffix  = ""
	      rest = base2
	      ## FIXME: Move the location of the following code.
	      ## FIXME: <komatsu@taiyaki.org> (2003-12-24)
	      priority = priority - (1000 * rest.length)
	    end
	  }
	  cand = PrimeCandidate.new(pron, literal, priority, pos, suffix, rest)
	  results << cand
	end
      }
    }
    return results
  end

  def get_connection_cost(pos1, literal1, pos2, literal2)
    cost =
      (@pos_connection_cost[format("=%s\t=%s", literal1, literal2)] or
       @pos_connection_cost[format("%s\t=%s",  pos1,     literal2)] or
       @pos_connection_cost[format("=%s\t%s",  literal1, pos2)]     or
       @pos_connection_cost[format("%s\t%s",   pos1,     pos2)]     or
       @pos_connection_cost_default)
    return cost
  end

  def parse_result (result_line, input = nil, rest = "")
    (pron, pos, literal, freq) = result_line.split(/\t/)
    if input then
      suffix = get_suffix(input.base, pron, rest)
    else
      suffix = ""
    end
    priority = freq.to_i + 10000 - rest.length * 1000
    return [pron, literal, priority, pos, suffix, rest]
  end

  def process_clauses (string)
    (depth, clauses_list) = guess_clauses_internal(string)
    return clauses_list.map {|clauses|
      if clauses.length <= depth then
	clauses
      end
    }
  end

  # Testing function.
  def guess_clauses (string)
    (depth, clauses_list) = guess_clauses_internal(string)
    clauses_list.each {|clauses|
      if clauses.length <= depth then
	clauses_line = clauses.map{|(base, pos, suffix, suffix_pos)|
	  if suffix.nil? or suffix.empty? then
	    #	  if suffix.empty? then
	    if pos.nil? then
	      format("%s", base)
	    else
	      format("%s(%s)", base, pos)
	    end
	  else
	    format("%s(%s) %s(%s)", base, pos, suffix, suffix_pos)
	  end
	}.join(" + ")
	puts clauses_line
      end
    }
  end

  private
  def guess_clauses_internal (string, depth = 1, prev_pos = nil, threshold = 4)
    if depth > threshold then
      return [threshold, []]
    end

    if prev_pos then
      pos_reverse = @pos_alias_reverse[prev_pos]
      if pos_reverse.nil? or pos_reverse.empty? then
        aliased_pos_list = [prev_pos]
      else
        aliased_pos_list = [prev_pos, *@pos_alias_reverse[prev_pos]]
      end
      connections = aliased_pos_list.map {|aliased_pos|
	pos_list = @pos_connection_table[aliased_pos]
	pos_list and pos_list.map {|pos|
          if @pos_alias[pos].nil? then
            pos
          else
            [pos, *@pos_alias[pos]]
          end
	}
      }.flatten
#      connections = (@pos_connection_table[prev_pos] or [])
    end

    return_value = []
    return_depth = threshold

    string.length.step(1, -1) {|i|
      base = string[0,i]
      tail = string[base.length..-1]
      pos_list = lookup_part(base)

      if prev_pos then
	valid_pos_list = (connections & pos_list)
      else
	valid_pos_list = pos_list
      end

      valid_pos_list.each{|pos|
	katsuyou_list = @grammar.lookup_katsuyou(pos, tail)
	katsuyou_list.sort!{|a, b| b[0].length <=> a[0].length}
	katsuyou_list.each {|(suffix, rest, suffix_pos)|
	  clause = [base, pos, suffix, suffix_pos]

	  if rest and rest.length > 0 then
	    (min_depth, next_clauses) =
	      guess_clauses_internal(rest, depth + 1, suffix_pos, return_depth)
	    return_depth =
	      (min_depth < return_depth) ? min_depth : return_depth
	    next_clauses.each {|next_clause|
              return_value << [clause, *next_clause]
	    }
	  else
	    return_depth = depth
	    return_value << [clause]
	  end
	}
      }
    }

    if return_value.empty? then
      strlen = string.split(//).length 
      #  FIXME: ADHOOOOC!
      #  FIXME: <komatsu@taiyaki.org> (2003-12-24)
      if strlen <= 4 then
	return_depth = depth + string.split(//).length 
#	if return_depth <= threshold
	  return_value << [[string, nil, "", ""]]
#	end
      end
    end

    return [return_depth, return_value]
  end
end

if File::expand_path($0) == File::expand_path(__FILE__) then
  require 'jcode'
  $KCODE = 'e'
  require 'prime/prime'
  ptmc  = PrimeEngineBasicMultipleClauses.new()
  input = PrimeInput.new()

  while(true) do
    print "> "
    input.set(gets.chomp)
    ptmc.guess_clauses(input.base)
    puts "===="
    cands = ptmc.lookup_prefix(input)
    cands.each {|cand|
      puts cand.join()
    }
  end
end
