# prime/engine/engine-alphabet.rb
# $Id: engine-alphabet.rb,v 1.3.2.3 2004/01/09 21:46:17 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine'
$engine_class_name = 'PrimeEngineAlphabet'

class PrimeEngineAlphabet < PrimeEngine
  def initialize
    super

    @name = "Alphabet engine"
    @id   = "alphabet"
    @description = "Alphabet engine"
  end

  private
  def lookup (input, method = :prefix)
    results = PrimeResult.new

    if input.original == input.original.upcase and
        input.original != input.original.downcase then
      results << PrimeCandidate.new(input.original.downcase, input.original,
				    17000, "̤θ") # ñ(ʸ)
    else
      results << PrimeCandidate.new(input.original.downcase, input.original,
				    8000, "̤θ") # ñ
    end
    ### FIXME: 㤦󥸥Ѥ.
    results << PrimeCandidate.new(input.base.downcase, input.base.katakana,
				  8000, "̤θ") # 
    results << PrimeCandidate.new(input.base.downcase, input.base,
				  8000, "̤θ") # Ҥ餬ʤʤ
    return results
  end
end
