# engine-japanese.rb: Meta Class for Japanese of Prime.
# $Id: engine-japanese.rb,v 1.1.1.1 2003/05/28 17:48:18 komatsu Exp $
#
# Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

require 'prime/engine/engine'
require 'prime/grammar/grammar'

$engine_class_name = 'PrimeEngineJapanese'

class PrimeEngineJapanese < PrimeEngine
  @@grammar = nil
  def initialize
    @debug_mode = false
    
    @name = "japanese vanilla engine"
    @id   = "japanese vanilla"
    @description = "japanese skeleton engine"

    @grammar = initialize_grammar
  end

  def initialize_grammar
    unless @@grammar then
      grammar_file   = File::join2(PRIME_GRAMMAR_DIR, "prime-grammar")
      grammar_object = File::join2(PRIME_USER_DIR, "prime-grammar.rbo")
      @@grammar = Marshal::init_file(grammar_object,
				     File::mtime(grammar_file)) {
	grammar = Grammar.new   ## Should this be an outer class?
	grammar.loadfile(grammar_file)
	grammar
      }
    end
    return @@grammar
  end

  ### Looking up:
  def get_suffix (string, pattern, rest)
    if string.index(pattern) == nil then
      return ""
    else
      return string[pattern.length..(string.length - rest.length - 1)]
    end
  end

  ### Queries: 
  def make_queries (string)
    queries = Query.new
    parse_word(string).each {|(pattern, part, suffix, rest)|
      queries.add(pattern, part, suffix, rest, false)
    }
    return queries
  end

  def parse_word (string)
    debug_message("parse_word(#{string})")

    results = []

    string.increase {|base|
      suffix = string[base.length..-1]
      lookup_part(base).each {|part|
	@grammar.lookup_katsuyou(part, suffix).each {|katsuyou|
	  results.push([base, part] + katsuyou)
	}
	# This form is not supported by lookup_katsuyou
	# results.push([base, part, "", suffix])
      }
    }
    # FIXME: 'uniq' should be at Query#add.
    return results.uniq
  end

  def lookup_part (base)
    return []
  end

  class Query
    def initialize
      @query = []
    end

    def add (pattern, part = nil, suffix = "", rest = "", prefix = true)
      @query << QueryItem.new(pattern, part, suffix, rest, prefix)
    end

    def query_lines (cond_rest = nil)
      query_lines = []
      @query.each {|item|
	if cond_rest == nil or cond_rest == item.rest then
	  if item.part then
	    query_lines << "#{item.pattern}\t#{item.part}\t"
	  else
	    if item.prefix then
	      query_lines << "#{item.pattern}"
	    else
	      query_lines << "#{item.pattern}\t"
	    end
	  end
	end
      }
      return query_lines
    end

    def rests
      rests = @query.map {|item| item.rest}
      return rests.uniq.sort {|rest1, rest2| rest1.length <=> rest2.length}
    end

    class QueryItem
      attr_accessor :pattern, :part, :suffix, :rest, :prefix
      def initialize (pattern, part = nil, suffix = "", rest = "",
		      prefix = true)
	@pattern = pattern
	@part    = part
	@suffix  = (suffix or "")
	@rest    = (rest   or "")
	@prefix  = part ? false : prefix ### restriction for implementation.
      end
    end
  end
end
