# dictformat-skk.rb: Converter module for skk format.
# $Id: $
#
# Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

require 'prime/makedict/dictformat'
$KCODE = 'e'

class DictFormatSkkdic < DictFormat
  def initialize
    super
    @default_pos  = nil
    @default_freq = 0
    @default_attr = nil
  end

  def parse (line)
    return nil if line =~ /^ *;/
    results = []

    line.chomp!
    (pron, *words) = line.split(/\//)
    pron.strip!
    words.each{|word|
      if valid_word?(pron, word) then
	(literal, attr) = word.split(';')
	results << [pron, @default_pos, literal, @default_freq, attr]
      end
    }
    return results
  end

  private
  def valid_word? (pron, word)
    return ((pron.length > 0) and taigen?(pron))
  end

  def taigen? (pron)
    return pron !~ /^[^a-z].*[a-z]$/
  end
end
